/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableObjectType;
import openmods.sync.SyncableObjectTypeRegistry;
import openmods.utils.bitstream.InputBitStream;
import openmods.utils.io.IByteSource;

public class SyncMapClient
extends SyncMap {
    protected final Set<ISyncListener> updateListeners = Sets.newIdentityHashSet();
    private final Map<String, ISyncableObject> availableObjects = Maps.newHashMap();
    private int bitmapLength = 0;
    private List<ISyncableObject> idToObject;
    private Map<ISyncableObject, Integer> objectToId;

    @Override
    public void read(NBTTagCompound tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(NBTTagCompound tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void safeWrite(NBTTagCompound tag) {
    }

    @Override
    public void writeInitializationData(PacketBuffer dos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendUpdates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean trySendUpdates() {
        return false;
    }

    @Override
    public void readIntializationData(PacketBuffer dis) throws IOException {
        int count = dis.func_150792_a();
        ImmutableList.Builder idToObject = ImmutableList.builder();
        ImmutableMap.Builder objectToId = ImmutableMap.builder();
        Set changedObjects = Sets.newIdentityHashSet();
        for (int i = 0; i < count; ++i) {
            String id = dis.func_150789_c(65535);
            int typeId = dis.func_150792_a();
            SyncableObjectType type = SyncableObjectTypeRegistry.getType(typeId);
            ISyncableObject object = this.availableObjects.get(id);
            if (object == null || !type.isValidType(object)) {
                object = type.createDummyObject();
            }
            object.readFromStream(dis);
            idToObject.add((Object)object);
            objectToId.put((Object)object, (Object)i);
            changedObjects.add(object);
        }
        this.idToObject = idToObject.build();
        this.objectToId = objectToId.build();
        this.bitmapLength = (count + 7) / 8;
        SyncMapClient.notifySyncListeners(this.updateListeners, Collections.unmodifiableSet(changedObjects));
    }

    @Override
    public void readUpdate(PacketBuffer dis) throws IOException {
        if (this.bitmapLength <= 0) {
            this.readIntializationData(dis);
            return;
        }
        final ByteBuf bitmapData = dis.readSlice(this.bitmapLength);
        InputBitStream bitmap = new InputBitStream(new IByteSource(){

            @Override
            public int nextByte() {
                return bitmapData.readUnsignedByte();
            }
        });
        Set changes = Sets.newIdentityHashSet();
        for (int i = 0; i < this.idToObject.size(); ++i) {
            if (!bitmap.readBit()) continue;
            ISyncableObject obj = this.idToObject.get(i);
            obj.readFromStream(dis);
            changes.add(obj);
        }
        if (!changes.isEmpty()) {
            SyncMapClient.notifySyncListeners(this.updateListeners, Collections.unmodifiableSet(changes));
        }
    }

    @Override
    public void registerObject(String name, ISyncableObject value) {
        ISyncableObject prev = this.availableObjects.put(name, value);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate object '%s': %s -> %s", (Object[])new Object[]{name, value});
    }

    @Override
    public ISyncableObject getObjectById(int id) {
        Preconditions.checkState((this.idToObject != null ? 1 : 0) != 0, (Object)"Initial data not received yet!");
        return this.idToObject.get(id);
    }

    @Override
    public int getObjectId(ISyncableObject object) {
        Preconditions.checkState((this.objectToId != null ? 1 : 0) != 0, (Object)"Initial data not received yet!");
        return this.objectToId.get(object);
    }

    @Override
    public void addSyncListener(ISyncListener listener) {
    }

    @Override
    public void addUpdateListener(ISyncListener listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void removeUpdateListener(ISyncListener listener) {
        this.updateListeners.remove(listener);
    }
}

