/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.Log;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncChannelHolder;
import openmods.sync.SyncMap;
import openmods.sync.SyncableObjectType;
import openmods.sync.SyncableObjectTypeRegistry;
import openmods.utils.bitstream.OutputBitStream;
import openmods.utils.io.IByteSink;

public abstract class SyncMapServer
extends SyncMap {
    private final Map<String, ISyncableObject> objects = Maps.newHashMap();
    private final List<Entry> orderedEntries = Lists.newArrayList();
    private final Map<ISyncableObject, Integer> objectToId = Maps.newIdentityHashMap();
    private boolean firstDataSent = false;
    private int bitmapLength;
    private final IUpdateStrategy updateStrategy = this.createUpdateStrategy();
    protected final Set<ISyncListener> syncListeners = Sets.newIdentityHashSet();

    @Override
    public void registerObject(String name, ISyncableObject value) {
        Preconditions.checkState((!this.firstDataSent ? 1 : 0) != 0, (Object)"Can't add fields to object that has already sent data to clients");
        ISyncableObject prev = this.objects.put(name, value);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate name '%s', %s -> %s", (Object[])new Object[]{name, prev, value});
        int newId = this.orderedEntries.size();
        this.orderedEntries.add(new Entry(name, value));
        Integer prev2 = this.objectToId.put(value, newId);
        Preconditions.checkState((prev2 == null ? 1 : 0) != 0, (String)"Duplicate object '%s', %s -> %s", (Object[])new Object[]{name, prev2, newId});
    }

    @Override
    public void read(NBTTagCompound tag) {
        for (Map.Entry<String, ISyncableObject> entry : this.objects.entrySet()) {
            String name = entry.getKey();
            ISyncableObject obj = entry.getValue();
            try {
                obj.readFromNBT(tag, name);
            }
            catch (Throwable e) {
                throw new SyncMap.SyncFieldException(e, name);
            }
            obj.markClean();
        }
    }

    @Override
    public void write(NBTTagCompound tag) {
        for (Map.Entry<String, ISyncableObject> entry : this.objects.entrySet()) {
            String name = entry.getKey();
            ISyncableObject obj = entry.getValue();
            try {
                obj.writeToNBT(tag, name);
            }
            catch (Throwable e) {
                throw new SyncMap.SyncFieldException(e, name);
            }
        }
    }

    @Override
    public void safeWrite(NBTTagCompound tag) {
        this.write(tag);
    }

    @Override
    public void readIntializationData(PacketBuffer dis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readUpdate(PacketBuffer dis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeInitializationData(PacketBuffer dos) throws IOException {
        if (!this.firstDataSent) {
            this.firstDataSent = true;
            this.bitmapLength = (this.objects.size() + 7) / 8;
        }
        dos.func_150787_b(this.objects.size());
        for (Entry e : this.orderedEntries) {
            dos.func_180714_a(e.name);
            int typeId = SyncableObjectTypeRegistry.getTypeId(e.type);
            dos.func_150787_b(typeId);
            e.obj.writeToStream(dos);
        }
    }

    private void writeInitialDataWithPrefix(PacketBuffer dos) throws IOException {
        this.writePrefix(dos);
        this.writeInitializationData(dos);
    }

    private void writeUpdatePacket(PacketBuffer dos, Set<ISyncableObject> changes) throws IOException {
        Preconditions.checkState((boolean)this.firstDataSent, (Object)"Initial data not sent to clients");
        this.writePrefix(dos);
        final ByteBuf bitmapData = dos.slice(dos.writerIndex(), this.bitmapLength);
        bitmapData.clear();
        dos.writeZero(this.bitmapLength);
        OutputBitStream bitmap = new OutputBitStream(new IByteSink(){

            @Override
            public void acceptByte(int b) {
                bitmapData.writeByte(b);
            }
        });
        for (Entry e : this.orderedEntries) {
            if (changes.contains(e.obj)) {
                e.obj.writeToStream(dos);
                bitmap.writeBit(true);
                continue;
            }
            bitmap.writeBit(false);
        }
        bitmap.flush();
    }

    private void writePrefix(PacketBuffer dos) {
        dos.func_150787_b(this.getOwnerType());
        this.writeOwnerData(dos);
    }

    private Set<ISyncableObject> listChanges() {
        Set changes = Sets.newIdentityHashSet();
        for (Entry e : this.orderedEntries) {
            if (!e.obj.isDirty()) continue;
            changes.add(e.obj);
            e.obj.markClean();
        }
        return changes;
    }

    @Override
    public void addSyncListener(ISyncListener listener) {
        this.syncListeners.add(listener);
    }

    @Override
    public void addUpdateListener(ISyncListener listener) {
    }

    @Override
    public void removeUpdateListener(ISyncListener dispatcher) {
    }

    @Override
    public void sendUpdates() {
        if (this.isInvalid() || !this.updateStrategy.sendsFirstPacket() && !this.firstDataSent) {
            return;
        }
        Set<ISyncableObject> changedObjects = this.listChanges();
        this.updateStrategy.sendUpdates(changedObjects);
        if (!changedObjects.isEmpty()) {
            SyncMapServer.notifySyncListeners(this.syncListeners, Collections.unmodifiableSet(changedObjects));
        }
    }

    @Override
    public boolean trySendUpdates() {
        this.sendUpdates();
        return true;
    }

    @Override
    public ISyncableObject getObjectById(int objectId) {
        try {
            return this.orderedEntries.get(objectId).obj;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(Integer.toString(objectId));
        }
    }

    @Override
    public int getObjectId(ISyncableObject object) {
        Integer result = this.objectToId.get(object);
        if (result == null) {
            throw new NoSuchElementException(String.valueOf(object));
        }
        return result;
    }

    protected abstract IUpdateStrategy createUpdateStrategy();

    protected abstract int getOwnerType();

    protected abstract void writeOwnerData(PacketBuffer var1);

    protected abstract Set<EntityPlayerMP> getPlayersWatching();

    protected abstract boolean isInvalid();

    protected class SendInitialPacketStrategy
    implements IUpdateStrategy {
        private Set<Integer> knownUsers = Sets.newHashSet();

        protected SendInitialPacketStrategy() {
        }

        @Override
        public void sendUpdates(Set<ISyncableObject> changes) {
            boolean hasChanges = !changes.isEmpty();
            ArrayList fullPacketTargets = Lists.newArrayList();
            ArrayList deltaPacketTargets = Lists.newArrayList();
            Set<EntityPlayerMP> players = SyncMapServer.this.getPlayersWatching();
            for (EntityPlayerMP player : players) {
                if (this.knownUsers.contains(player.func_145782_y())) {
                    if (!hasChanges) continue;
                    deltaPacketTargets.add(player);
                    continue;
                }
                this.knownUsers.add(player.func_145782_y());
                fullPacketTargets.add(player);
            }
            try {
                if (!deltaPacketTargets.isEmpty()) {
                    PacketBuffer deltaPayload = new PacketBuffer(Unpooled.buffer());
                    SyncMapServer.this.writeUpdatePacket(deltaPayload, changes);
                    SyncChannelHolder.INSTANCE.sendPayloadToPlayers(deltaPayload, deltaPacketTargets);
                }
            }
            catch (IOException e) {
                Log.warn(e, "IOError during delta sync", new Object[0]);
            }
            try {
                if (!fullPacketTargets.isEmpty()) {
                    PacketBuffer fullPayload = new PacketBuffer(Unpooled.buffer());
                    SyncMapServer.this.writeInitialDataWithPrefix(fullPayload);
                    SyncChannelHolder.INSTANCE.sendPayloadToPlayers(fullPayload, fullPacketTargets);
                }
            }
            catch (IOException e) {
                Log.warn(e, "IOError during full sync", new Object[0]);
            }
        }

        @Override
        public boolean sendsFirstPacket() {
            return true;
        }
    }

    protected class AutomaticInitialPacketStrategy
    implements IUpdateStrategy {
        protected AutomaticInitialPacketStrategy() {
        }

        @Override
        public void sendUpdates(Set<ISyncableObject> changedObjects) {
            if (changedObjects.isEmpty()) {
                return;
            }
            Set<EntityPlayerMP> players = SyncMapServer.this.getPlayersWatching();
            try {
                PacketBuffer deltaPayload = new PacketBuffer(Unpooled.buffer());
                SyncMapServer.this.writeUpdatePacket(deltaPayload, changedObjects);
                SyncChannelHolder.INSTANCE.sendPayloadToPlayers(deltaPayload, players);
            }
            catch (IOException e) {
                Log.warn(e, "IOError during delta sync", new Object[0]);
            }
        }

        @Override
        public boolean sendsFirstPacket() {
            return false;
        }
    }

    protected static interface IUpdateStrategy {
        public void sendUpdates(Set<ISyncableObject> var1);

        public boolean sendsFirstPacket();
    }

    private static class Entry {
        private final String name;
        private final ISyncableObject obj;
        private final SyncableObjectType type;

        public Entry(String name, ISyncableObject obj) {
            this.name = name;
            this.obj = obj;
            this.type = SyncableObjectTypeRegistry.getType(obj.getClass());
            Preconditions.checkNotNull((Object)this.type, (String)"Type %s is not registered", (Object[])new Object[]{obj.getClass()});
        }
    }
}

