/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import openmods.utils.Coord;

public class BlockProperties {
    public static String getBlockName(Block block) {
        return GameRegistry.findUniqueIdentifierFor((Block)block).toString();
    }

    public static String getBlockName(Coord c, World world) {
        return BlockProperties.getBlockName(BlockProperties.getBlock(c, world));
    }

    public static Block getBlockByName(String blockName) {
        GameRegistry.UniqueIdentifier ident = new GameRegistry.UniqueIdentifier(blockName);
        return GameRegistry.findBlock((String)ident.modId, (String)ident.name);
    }

    public static Block getBlock(Coord c, World world) {
        return world.getBlock(c.x, c.y, c.z);
    }

    public static int getBlockMetadata(Coord c, World world) {
        return world.getBlockMetadata(c.x, c.y, c.z);
    }

    public static boolean isAirBlock(Coord c, World world) {
        return world.isAirBlock(c.x, c.y, c.z);
    }

    public static boolean isFlower(Coord c, World world) {
        Block block = BlockProperties.getBlock(c, world);
        return block instanceof BlockFlower;
    }

    public static boolean isBlockNormalCube(Coord c, World world) {
        return world.isBlockNormalCubeDefault(c.x, c.y, c.z, false);
    }

    public static boolean isWood(Coord c, World world) {
        Block block = BlockProperties.getBlock(c, world);
        return block != null && block.isWood((IBlockAccess)world, c.x, c.y, c.z);
    }

    public static boolean isLeaves(Coord c, World world) {
        Block block = BlockProperties.getBlock(c, world);
        return block != null && block.isLeaves((IBlockAccess)world, c.x, c.y, c.z);
    }

    public static BiomeGenBase getBiomeGenBase(Coord c, World world) {
        return world.getBiomeGenForCoords(c.x, c.z);
    }
}

