/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandUtils {
    public static List<String> filterPrefixes(String prefix, Iterable<String> proposals) {
        prefix = prefix.toLowerCase(Locale.ENGLISH);
        ArrayList result = Lists.newArrayList();
        for (String s : proposals) {
            if (!s.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            result.add(s);
        }
        return result;
    }

    public static List<String> filterPrefixes(String prefix, String ... proposals) {
        return CommandUtils.filterPrefixes(prefix, Arrays.asList(proposals));
    }

    public static List<String> getPlayerNames() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            return ImmutableList.copyOf((Object[])server.func_71213_z());
        }
        return ImmutableList.of();
    }

    public static List<String> fiterPlayerNames(String prefix) {
        return CommandUtils.filterPrefixes(prefix, CommandUtils.getPlayerNames());
    }

    public static void respondText(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static void respond(ICommandSender sender, String format, Object ... args) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(format, args));
    }

    public static CommandException error(String format, Object ... args) throws CommandException {
        throw new CommandException(format, args);
    }
}

