/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import openmods.OpenMods;

public abstract class CommonRegistryCallbacks<T, E extends IForgeRegistryEntry<E>>
implements IForgeRegistry.AddCallback<E>,
IForgeRegistry.ClearCallback<E>,
IForgeRegistry.CreateCallback<E> {
    private static final ResourceLocation OBJECT_TO_ENTRY = OpenMods.location("object_to_entry");
    private static final ResourceLocation ENTRY_TO_ID = OpenMods.location("entry_to_id");

    protected abstract T getWrappedObject(E var1);

    public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        HashMap classToEntryMap = Maps.newHashMap();
        slaveset.put(OBJECT_TO_ENTRY, classToEntryMap);
        HashBiMap entryToId = HashBiMap.create();
        slaveset.put(ENTRY_TO_ID, entryToId);
    }

    public void onClear(IForgeRegistry<E> is, Map<ResourceLocation, ?> slaveset) {
        ((Map)slaveset.get(OBJECT_TO_ENTRY)).clear();
        ((BiMap)slaveset.get(ENTRY_TO_ID)).clear();
    }

    public void onAdd(E obj, int id, Map<ResourceLocation, ?> slaveset) {
        ((Map)slaveset.get(OBJECT_TO_ENTRY)).put(this.getWrappedObject(obj), obj);
        ((BiMap)slaveset.get(ENTRY_TO_ID)).put(obj, (Object)id);
    }

    public static <T, E extends IForgeRegistryEntry<E>> Map<T, E> getObjectToEntryMap(IForgeRegistry<E> registry) {
        return (Map)registry.getSlaveMap(OBJECT_TO_ENTRY, Map.class);
    }

    public static <E extends IForgeRegistryEntry<E>> BiMap<E, Integer> getEntryIdMap(IForgeRegistry<E> registry) {
        return (BiMap)registry.getSlaveMap(ENTRY_TO_ID, BiMap.class);
    }

    public static <T, E extends IForgeRegistryEntry<E>> Integer mapObjectToId(IForgeRegistry<E> registry, T object) {
        Map<T, E> objectToEntryMap = CommonRegistryCallbacks.getObjectToEntryMap(registry);
        IForgeRegistryEntry entry = (IForgeRegistryEntry)objectToEntryMap.get(object);
        BiMap<E, Integer> entryIdMap = CommonRegistryCallbacks.getEntryIdMap(registry);
        return (Integer)entryIdMap.get((Object)entry);
    }
}

