/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Objects;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import openmods.utils.Coord;
import openmods.utils.EnumUtils;

public class NbtUtils {
    private static final String KEY = "K";
    private static final String VALUE = "V";
    private static final String TAG_Z = "Z";
    private static final String TAG_Y = "Y";
    private static final String TAG_X = "X";

    public static boolean hasCoordinates(NBTTagCompound tag) {
        return tag.func_150297_b(TAG_X, 99) && tag.func_150297_b(TAG_Y, 99) && tag.func_150297_b(TAG_Z, 99);
    }

    public static NBTTagCompound store(NBTTagCompound tag, int x, int y, int z) {
        tag.func_74768_a(TAG_X, x);
        tag.func_74768_a(TAG_Y, y);
        tag.func_74768_a(TAG_Z, z);
        return tag;
    }

    public static NBTTagCompound store(int x, int y, int z) {
        return NbtUtils.store(new NBTTagCompound(), x, y, z);
    }

    public static NBTTagCompound store(NBTTagCompound tag, double x, double y, double z) {
        tag.func_74780_a(TAG_X, x);
        tag.func_74780_a(TAG_Y, y);
        tag.func_74780_a(TAG_Z, z);
        return tag;
    }

    public static NBTTagCompound store(double x, double y, double z) {
        return NbtUtils.store(new NBTTagCompound(), x, y, z);
    }

    public static NBTTagCompound store(NBTTagCompound tag, Vec3i coords) {
        return NbtUtils.store(tag, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
    }

    public static NBTTagCompound store(Vec3i coords) {
        return NbtUtils.store(new NBTTagCompound(), coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
    }

    public static NBTTagCompound store(NBTTagCompound tag, Coord coords) {
        return NbtUtils.store(tag, coords.x, coords.y, coords.z);
    }

    public static NBTTagCompound store(Coord coords) {
        return NbtUtils.store(new NBTTagCompound(), coords.x, coords.y, coords.z);
    }

    public static NBTTagCompound store(NBTTagCompound tag, BlockPos coords) {
        return NbtUtils.store(tag, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
    }

    public static NBTTagCompound store(BlockPos coords) {
        return NbtUtils.store(new NBTTagCompound(), coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
    }

    public static NBTTagCompound store(NBTTagCompound tag, UUID uuid) {
        tag.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
        return tag;
    }

    public static NBTTagCompound store(UUID uuid) {
        return NbtUtils.store(new NBTTagCompound(), uuid);
    }

    public static NBTTagCompound store(Vec3d vec) {
        return NbtUtils.store(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static NBTTagCompound store(NBTTagCompound tag, ResourceLocation location) {
        tag.func_74778_a(KEY, location.func_110624_b());
        tag.func_74778_a(VALUE, location.func_110623_a());
        return tag;
    }

    public static NBTTagCompound store(ResourceLocation location) {
        return NbtUtils.store(new NBTTagCompound(), location);
    }

    public static Coord readCoord(NBTTagCompound tag) {
        int x = tag.func_74762_e(TAG_X);
        int y = tag.func_74762_e(TAG_Y);
        int z = tag.func_74762_e(TAG_Z);
        return new Coord(x, y, z);
    }

    public static BlockPos readBlockPos(NBTTagCompound tag) {
        int x = tag.func_74762_e(TAG_X);
        int y = tag.func_74762_e(TAG_Y);
        int z = tag.func_74762_e(TAG_Z);
        return new BlockPos(x, y, z);
    }

    public static Vec3d readVec(NBTTagCompound tag) {
        double x = tag.func_74769_h(TAG_X);
        double y = tag.func_74769_h(TAG_Y);
        double z = tag.func_74769_h(TAG_Z);
        return new Vec3d(x, y, z);
    }

    public static UUID readUuid(NBTTagCompound tag) {
        long most = tag.func_74763_f("UUIDMost");
        long least = tag.func_74763_f("UUIDLeast");
        return new UUID(most, least);
    }

    public static ResourceLocation readResourceLocation(NBTTagCompound entry) {
        String domain = entry.func_74779_i(KEY);
        String path = entry.func_74779_i(VALUE);
        ResourceLocation blockLocation = new ResourceLocation(domain, path);
        return blockLocation;
    }

    public static <T extends Enum<T>> T readEnum(NBTTagCompound tag, String name, Class<T> cls) {
        if (tag.func_150297_b(name, 99)) {
            int ordinal = tag.func_74762_e(name);
            return EnumUtils.fromOrdinal(cls, ordinal);
        }
        return null;
    }

    public static <T extends Enum<T>> T readEnum(NBTTagCompound tag, String name, T defaultValue) {
        return (T)((Enum)Objects.firstNonNull(NbtUtils.readEnum(tag, name, defaultValue.getClass()), defaultValue));
    }
}

