/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.utils.bitmap.IReadableBitMap;

public class SidedItemHandlerAdapter {
    private final IItemHandlerModifiable inventory;
    private final Set<EnumFacing> validSides = EnumSet.noneOf(EnumFacing.class);
    private final Map<EnumFacing, ItemHandler> handlers = Maps.newEnumMap(EnumFacing.class);
    private final Map<Integer, SlotConfig> slots = Maps.newHashMap();

    public SidedItemHandlerAdapter(IItemHandlerModifiable inventory) {
        this.inventory = inventory;
    }

    public IItemHandlerModifiable getHandler(EnumFacing side) {
        if (this.validSides.contains(side)) {
            return this.handlers.get(side);
        }
        ItemHandler handler = this.createHandlerForSide(side);
        if (handler != null) {
            this.handlers.put(side, handler);
        }
        this.validSides.add(side);
        return handler;
    }

    public boolean hasHandler(EnumFacing side) {
        return this.getHandler(side) != null;
    }

    private ItemHandler createHandlerForSide(EnumFacing side) {
        ArrayList sideConfig = Lists.newArrayListWithCapacity((int)this.slots.size());
        for (SlotConfig config : this.slots.values()) {
            if (!config.canAccessFromSide(side)) continue;
            sideConfig.add(config);
        }
        return sideConfig.isEmpty() ? null : new ItemHandler(sideConfig);
    }

    public void invalidate() {
        this.validSides.clear();
        this.handlers.clear();
    }

    public ISyncListener createSyncListener() {
        return new ISyncListener(){

            @Override
            public void onSync(Set<ISyncableObject> changes) {
                SidedItemHandlerAdapter.this.invalidate();
            }
        };
    }

    public void registerSlots(int start, int count, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = start; i < start + count; ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public void registerAllSlots(IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public void registerSlot(Enum<?> slot, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        this.registerSlot(slot.ordinal(), sideFlags, canInsert, canExtract);
    }

    public void registerSlot(int slot, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
        int sizeInventory = this.inventory.getSlots();
        Preconditions.checkArgument((slot >= 0 && slot < sizeInventory ? 1 : 0) != 0, (String)"Tried to register invalid slot: %s (inventory size: %s)", (Object[])new Object[]{slot, sizeInventory});
        this.slots.put(slot, new SlotConfig(slot, sideFlags, canInsert, canExtract));
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private final List<SlotConfig> slots;

        public ItemHandler(List<SlotConfig> slots) {
            this.slots = ImmutableList.copyOf(slots);
        }

        public int getSlots() {
            return this.slots.size();
        }

        public ItemStack getStackInSlot(int slot) {
            SlotConfig mappedSlot = this.slots.get(slot);
            return SidedItemHandlerAdapter.this.inventory.getStackInSlot(mappedSlot.index);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            SlotConfig mappedSlot = this.slots.get(slot);
            SidedItemHandlerAdapter.this.inventory.setStackInSlot(mappedSlot.index, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            SlotConfig mappedSlot = this.slots.get(slot);
            if (!mappedSlot.canInsert) {
                return stack;
            }
            return SidedItemHandlerAdapter.this.inventory.insertItem(mappedSlot.index, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            SlotConfig mappedSlot = this.slots.get(slot);
            if (!mappedSlot.canExtract) {
                return null;
            }
            return SidedItemHandlerAdapter.this.inventory.extractItem(mappedSlot.index, amount, simulate);
        }
    }

    private class SlotConfig {
        private final int index;
        private final IReadableBitMap<EnumFacing> reachability;
        private final boolean canInsert;
        private final boolean canExtract;

        private SlotConfig(int index, IReadableBitMap<EnumFacing> sideFlags, boolean canInsert, boolean canExtract) {
            this.index = index;
            this.reachability = sideFlags;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        private boolean canAccessFromSide(EnumFacing side) {
            return this.reachability.get(side);
        }
    }
}

