/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class VanillaEnchantLogic {
    private final long seed;
    private final Random rand = new Random();
    private ItemStack toEnchant;
    private Level level;
    private int xpLevels;

    public VanillaEnchantLogic(long seed) {
        this.seed = seed;
    }

    public boolean setup(ItemStack stack, Level level, int power) {
        if (stack == null || !stack.func_77956_u()) {
            return false;
        }
        this.rand.setSeed(this.seed);
        this.toEnchant = stack.func_77946_l();
        this.level = level;
        this.xpLevels = EnchantmentHelper.func_77514_a((Random)this.rand, (int)level.ordinal(), (int)power, (ItemStack)this.toEnchant);
        if (this.xpLevels <= level.ordinal() + 1) {
            this.xpLevels = 0;
        }
        return true;
    }

    public int getLevelCost() {
        return this.level.ordinal() + 1;
    }

    public int getLevelRequirement() {
        return this.xpLevels;
    }

    public int getLapisCost() {
        return this.level.ordinal() + 1;
    }

    public ItemStack enchant() {
        ItemStack enchantedItem = this.toEnchant.func_77946_l();
        boolean isBook = enchantedItem.func_77973_b() == Items.field_151122_aG;
        List<EnchantmentData> enchantmentsToApply = this.getEnchantmentList(this.toEnchant, this.level, this.xpLevels);
        if (!enchantmentsToApply.isEmpty()) {
            if (isBook) {
                enchantedItem.func_150996_a((Item)Items.field_151134_bR);
            }
            for (EnchantmentData enchantment : enchantmentsToApply) {
                if (isBook) {
                    Items.field_151134_bR.func_92115_a(enchantedItem, enchantment);
                    continue;
                }
                enchantedItem.func_77966_a(enchantment.field_76302_b, enchantment.field_76303_c);
            }
        }
        return enchantedItem;
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, Level level, int xpLevels) {
        this.rand.setSeed(this.seed + (long)level.ordinal());
        List list = EnchantmentHelper.func_77513_b((Random)this.rand, (ItemStack)stack, (int)xpLevels, (boolean)false);
        if (stack.func_77973_b() == Items.field_151122_aG && list.size() > 1) {
            list.remove(this.rand.nextInt(list.size()));
        }
        return list;
    }

    public static enum Level {
        L1,
        L2,
        L3;

    }
}

