/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class PaintUtils {
    private final Set<Block> allowed = Sets.newHashSet();
    public static final PaintUtils instance = new PaintUtils();

    protected PaintUtils() {
        this.allowed.add(Blocks.stone);
        this.allowed.add(Blocks.cobblestone);
        this.allowed.add(Blocks.mossy_cobblestone);
        this.allowed.add(Blocks.sandstone);
        this.allowed.add(Blocks.iron_block);
        this.allowed.add(Blocks.stonebrick);
        this.allowed.add(Blocks.glass);
        this.allowed.add(Blocks.planks);
        this.allowed.add(Blocks.dirt);
        this.allowed.add(Blocks.log);
        this.allowed.add(Blocks.log2);
        this.allowed.add(Blocks.gold_block);
        this.allowed.add(Blocks.emerald_block);
        this.allowed.add(Blocks.lapis_block);
        this.allowed.add(Blocks.quartz_block);
        this.allowed.add(Blocks.end_stone);
        if (Loader.isModLoaded((String)"TConstruct")) {
            this.addBlocksForMod("TConstruct", "GlassBlock", "decoration.multibrick", "decoration.multibrickfancy");
        }
        if (Loader.isModLoaded((String)"ExtraUtilities")) {
            this.addBlocksForMod("ExtraUtilities", "greenScreen", "extrautils:decor");
        }
        if (Loader.isModLoaded((String)"BiomesOPlenty")) {
            this.addBlocksForMod("BiomesOPlenty", "bop.planks");
        }
    }

    protected void addBlocksForMod(String modId, String ... blocks) {
        for (String blockName : blocks) {
            Block block = GameRegistry.findBlock((String)modId, (String)blockName);
            if (block == null) continue;
            this.allowed.add(block);
        }
    }

    public boolean isAllowedToReplace(Block block) {
        if (block == null || block.canProvidePower()) {
            return false;
        }
        return this.allowed.contains(block);
    }

    public boolean isAllowedToReplace(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return false;
        }
        return this.isAllowedToReplace(world.getBlock(x, y, z));
    }
}

