/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.apparatus;

import cofh.api.tileentity.IInventoryConnection;
import cofh.core.entity.CoFHFakePlayer;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.apparatus.BlockApparatus;
import cofh.thermalexpansion.block.apparatus.TileApparatusBase;
import cofh.thermalexpansion.gui.client.apparatus.GuiBreaker;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileBreaker
extends TileApparatusBase
implements IInventoryConnection,
ITickable {
    private static final int TYPE = BlockApparatus.Type.BREAKER.getMetadata();
    protected boolean augmentFluid;

    public static void initialize() {
        TileBreaker.SIDE_CONFIGS[TileBreaker.TYPE] = new TileTEBase.SideConfig();
        TileBreaker.SIDE_CONFIGS[TileBreaker.TYPE].numConfig = 2;
        TileBreaker.SIDE_CONFIGS[TileBreaker.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileBreaker.SIDE_CONFIGS[TileBreaker.TYPE].sideTypes = new int[]{0, 4};
        TileBreaker.SIDE_CONFIGS[TileBreaker.TYPE].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        TileBreaker.SLOT_CONFIGS[TileBreaker.TYPE] = new TileTEBase.SlotConfig();
        TileBreaker.SLOT_CONFIGS[TileBreaker.TYPE].allowInsertionSlot = new boolean[0];
        TileBreaker.SLOT_CONFIGS[TileBreaker.TYPE].allowExtractionSlot = new boolean[0];
        GameRegistry.registerTileEntity(TileBreaker.class, (String)"thermalexpansion:apparatus_breaker");
    }

    public static void config() {
        String category = "Apparatus.Breaker";
        BlockApparatus.enable[TileBreaker.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileBreaker() {
        this.inventory = new ItemStack[1];
        this.radius = 0;
        this.depth = 0;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected void activate() {
        this.breakBlocksInArea();
    }

    private void breakBlocksInArea() {
        Iterable area;
        switch (this.facing) {
            case 0: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-this.radius, -1 - this.depth, -this.radius), (BlockPos)this.field_174879_c.func_177982_a(this.radius, -1, this.radius));
                break;
            }
            case 1: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-this.radius, 1, -this.radius), (BlockPos)this.field_174879_c.func_177982_a(this.radius, 1 + this.depth, this.radius));
                break;
            }
            case 2: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-this.radius, -this.radius, -1 - this.depth), (BlockPos)this.field_174879_c.func_177982_a(this.radius, this.radius, -1));
                break;
            }
            case 3: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-this.radius, -this.radius, 1), (BlockPos)this.field_174879_c.func_177982_a(this.radius, this.radius, 1 + this.depth));
                break;
            }
            case 4: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1 - this.depth, -this.radius, -this.radius), (BlockPos)this.field_174879_c.func_177982_a(-1, this.radius, this.radius));
                break;
            }
            default: {
                area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(1, -this.radius, -this.radius), (BlockPos)this.field_174879_c.func_177982_a(1 + this.depth, this.radius, this.radius));
            }
        }
        for (BlockPos target : area) {
            if (this.augmentFluid) {
                FluidStack stack;
                FluidStack fluidStack = stack = this.augmentFluid ? FluidHelper.getFluidFromWorld((World)this.field_145850_b, (BlockPos)target, (boolean)true) : null;
                if (stack != null) {
                    for (int i = 0; i < 6 && stack.amount > 0; ++i) {
                        if (this.sideCache[i] != 1) continue;
                        stack.amount -= FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (FluidStack)stack, (boolean)true);
                    }
                    this.field_145850_b.func_175698_g(target);
                    continue;
                }
            }
            if (!CoFHFakePlayer.isBlockBreakable((CoFHFakePlayer)this.fakePlayer, (World)this.field_145850_b, (BlockPos)target)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(target);
            this.stuffedItems.addAll(BlockHelper.breakBlock((World)this.field_145850_b, (EntityPlayer)this.fakePlayer, (BlockPos)target, (IBlockState)state, (int)0, (boolean)true, (boolean)false));
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiBreaker(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)EmptyFluidHandler.INSTANCE);
        }
        return super.getCapability(capability, facing);
    }
}

