/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.blockbakery.BlockBakery;
import codechicken.lib.model.blockbakery.BlockBakeryProperties;
import codechicken.lib.model.blockbakery.CCBakeryModel;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.render.IModelRegister;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.device.ItemBlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.block.device.TileFisher;
import cofh.thermalexpansion.block.device.TileHeatSink;
import cofh.thermalexpansion.block.device.TileItemBuffer;
import cofh.thermalexpansion.block.device.TileNullifier;
import cofh.thermalexpansion.block.device.TileTapper;
import cofh.thermalexpansion.block.device.TileWaterGen;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.item.ItemFrame;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDevice
extends BlockTEBase
implements IModelRegister,
IWorldBlockTextureProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static ItemStack deviceWaterGen;
    public static ItemStack deviceNullifier;
    public static ItemStack deviceHeatSink;
    public static ItemStack deviceTapper;
    public static ItemStack deviceItemBuffer;
    public static ItemStack deviceTrader;
    public static ItemStack deviceFluidBuffer;
    public static ItemStack deviceEnergyBuffer;
    public static ItemStack deviceLexicon;
    public static ItemStack deviceChunkLoader;
    public static ItemStack deviceFountain;
    public static ItemStack deviceExtender;
    public static ItemStack deviceConcentrator;
    public static ItemBlockDevice itemBlock;

    public BlockDevice() {
        super(Material.field_151573_f);
        this.func_149663_c("device");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.WATER_GEN)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{BlockBakeryProperties.LAYER_FACE_SPRITE_MAP});
        builder.add(new IUnlistedProperty[]{TEProps.ACTIVE});
        builder.add(new IUnlistedProperty[]{TEProps.FACING});
        builder.add(new IUnlistedProperty[]{TEProps.SIDE_CONFIG});
        return builder.build();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            if (!enable[i]) continue;
            list.add(itemBlock.setDefaultTag(new ItemStack(item, 1, i)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata >= Type.values().length) {
            return null;
        }
        switch (Type.byMetadata(metadata)) {
            case WATER_GEN: {
                return new TileWaterGen();
            }
            case NULLIFIER: {
                return new TileNullifier();
            }
            case HEAT_SINK: {
                return new TileHeatSink();
            }
            case TAPPER: {
                return new TileTapper();
            }
            case FISHER: {
                return new TileFisher();
            }
            case ITEM_BUFFER: {
                return new TileItemBuffer();
            }
        }
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileDeviceBase tile = (TileDeviceBase)world.func_175625_s(pos);
            tile.readAugmentsFromNBT(stack.func_77978_p());
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing(stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache(stack, tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IFluidHandler handler;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileHeatSink && FluidHelper.drainItemToHandler((ItemStack)heldItem, (IFluidHandler)(handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (EntityPlayer)player, (EnumHand)hand)) {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (TileEntity)world.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        if (side == EnumFacing.DOWN) {
            return TETextures.DEVICE_BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TETextures.DEVICE_TOP;
        }
        return side != EnumFacing.NORTH ? TETextures.DEVICE_SIDE : TETextures.DEVICE_FACE[stack.func_77960_j() % BlockMachine.Type.values().length];
    }

    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileDeviceBase) {
            TileDeviceBase tile = (TileDeviceBase)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel("thermalexpansion:blocks/device/device_side"));
    }

    public boolean preInit() {
        this.setRegistryName("device");
        GameRegistry.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockDevice((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        TileDeviceBase.config();
        TileWaterGen.initialize();
        TileNullifier.initialize();
        TileHeatSink.initialize();
        TileTapper.initialize();
        TileItemBuffer.initialize();
        deviceWaterGen = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.WATER_GEN.getMetadata()));
        deviceNullifier = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.NULLIFIER.getMetadata()));
        deviceHeatSink = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.HEAT_SINK.getMetadata()));
        deviceTapper = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.TAPPER.getMetadata()));
        deviceItemBuffer = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ITEM_BUFFER.getMetadata()));
        this.addRecipes();
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private void addRecipes() {
        String tinPart = "gearTin";
        if (enable[Type.WATER_GEN.getMetadata()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)deviceWaterGen, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), tinPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "blockGlass"}));
        }
        if (enable[Type.NULLIFIER.getMetadata()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)deviceNullifier, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), tinPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Items.field_151129_at, Character.valueOf('Y'), Blocks.field_150336_V}));
        }
        if (enable[Type.HEAT_SINK.getMetadata()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)deviceHeatSink, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), tinPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), "blockCopper", Character.valueOf('Y'), "ingotInvar"}));
        }
        if (enable[Type.TAPPER.getMetadata()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)deviceTapper, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), tinPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "ingotCopper"}));
        }
        if (enable[Type.ITEM_BUFFER.getMetadata()]) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)deviceItemBuffer, (Object[])new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), ItemFrame.frameDevice, Character.valueOf('I'), tinPart, Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('X'), Blocks.field_150438_bZ, Character.valueOf('Y'), "dustRedstone"}));
        }
    }

    public static enum Type implements IStringSerializable
    {
        WATER_GEN(0, "water_gen"),
        NULLIFIER(1, "nullifier"),
        HEAT_SINK(2, "heat_sink"),
        TAPPER(3, "tapper"),
        FISHER(4, "fisher"),
        ITEM_BUFFER(5, "item_buffer");

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;

        private Type(int metadata, String name, int light) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

