/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiFisher;
import cofh.thermalexpansion.gui.container.device.ContainerFisher;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class TileFisher
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.FISHER.getMetadata();
    private static final int TIME_CONSTANT = 3600;
    private static final int BOOST_TIME = 16;
    private int targetWater = -1;
    private int inputTracker;
    private int outputTracker;
    private int boostMult;
    private int boostTime;
    private int offset;

    public static void initialize() {
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE] = new TileTEBase.SideConfig();
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].numConfig = 5;
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFisher.SIDE_CONFIGS[TileFisher.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE] = new TileTEBase.SlotConfig();
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false, false, false, false, false, false};
        TileFisher.SLOT_CONFIGS[TileFisher.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true};
        GameRegistry.registerTileEntity(TileFisher.class, (String)"thermalexpansion:device_fisher");
        TileFisher.config();
    }

    public static void config() {
        String category = "Device.Fisher";
        BlockDevice.enable[TileFisher.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileFisher() {
        this.inventory = new ItemStack[10];
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(3600);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        if (this.redstoneControlOrDisable() && this.targetWater >= 8) {
            this.isActive = true;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateValidity();
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferOutput();
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.targetWater > 8) {
                // empty if block
            }
            if (!this.redstoneControlOrDisable() || this.targetWater < 8) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable() && this.targetWater >= 8) {
            this.isActive = true;
        }
        this.updateValidity();
        this.updateIfChanged(curActive);
    }

    protected void updateValidity() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.targetWater = 0;
        Iterable area = BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-2, -1, -2), (BlockPos)this.field_174879_c.func_177982_a(2, -1, 2));
        for (BlockPos query : area) {
            if (!TileFisher.isWater(this.field_145850_b.func_180495_p(query))) continue;
            ++this.targetWater;
        }
    }

    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
    }

    protected static boolean isWater(IBlockState state) {
        return (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 3600L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFisher(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFisher(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.round((double)(scale * this.boostTime / 16));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetWater = nbt.func_74762_e("Water");
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.boostMult = nbt.func_74762_e("BoostMult");
        this.boostTime = nbt.func_74762_e("BoostTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Water", this.targetWater);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("BoostMult", this.boostMult);
        nbt.func_74768_a("BoostTime", this.boostTime);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.boostTime);
        payload.addInt(this.boostMult);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.boostTime = payload.getInt();
        this.boostMult = payload.getInt();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

