/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.core.IAccelerable;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiHeatSink;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.CoolantManager;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHeatSink
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.HEAT_SINK.getMetadata();
    public static int fluidAmount = 100;
    private static final int TIME_CONSTANT = 100;
    private static final int USE_FACTOR = 10;
    private boolean cached;
    private IAccelerable[] accelerables = new IAccelerable[6];
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    private int coolantRF;
    private int coolantFactor = 100;
    private int offset = MathHelper.RANDOM.nextInt(100);

    public static void initialize() {
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE] = new TileTEBase.SideConfig();
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].numConfig = 2;
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].sideTypes = new int[]{0, 1};
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].defaultSides = new byte[]{0, 1, 1, 1, 1, 1};
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE] = new TileTEBase.SlotConfig();
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE].allowInsertionSlot = new boolean[0];
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE].allowExtractionSlot = new boolean[0];
        TileHeatSink.LIGHT_VALUES[TileHeatSink.TYPE] = 3;
        GameRegistry.registerTileEntity(TileHeatSink.class, (String)"thermalexpansion:device_heat_sink");
        TileHeatSink.config();
    }

    public static void config() {
        String category = "Device.HeatSink";
        BlockDevice.enable[TileHeatSink.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (!this.timeCheckOffset()) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.coolantRF <= 0) {
                this.coolantFactor = 100;
                if (this.tank.getFluidAmount() >= fluidAmount) {
                    String prevID = this.renderFluid.getFluid().getName();
                    this.coolantRF += CoolantManager.getCoolantRF100mB(this.tank.getFluid());
                    this.coolantFactor = Math.min(100, CoolantManager.getCoolantFactor(this.tank.getFluid()));
                    if (!prevID.equals(this.renderFluid.getFluid().getName())) {
                        this.sendFluidPacket();
                    }
                    this.tank.drain(fluidAmount, true);
                    for (int i = 0; i < 6; ++i) {
                        if (this.accelerables[i] == null) continue;
                        this.coolantRF -= Math.min(5000, 10 * this.accelerables[i].updateAccelerable());
                    }
                } else {
                    this.isActive = false;
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    if (this.accelerables[i] == null) continue;
                    this.coolantRF -= Math.min(5000, 10 * this.accelerables[i].updateAccelerable());
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable() && this.canStart()) {
            this.isActive = true;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        this.updateIfChanged(curActive);
    }

    protected void updateAdjacentHandlers() {
        for (int i = 0; i < 6; ++i) {
            this.accelerables[i] = null;
            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            if (!(tile instanceof IAccelerable)) continue;
            this.accelerables[i] = (IAccelerable)tile;
        }
        this.cached = true;
    }

    protected boolean canStart() {
        return this.coolantRF > 0 || this.tank.getFluidAmount() >= fluidAmount;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % (long)this.coolantFactor == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiHeatSink(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolantRF = nbt.func_74762_e("Coolant");
        this.tank.readFromNBT(nbt);
        if (!CoolantManager.isValidCoolant(this.tank.getFluid())) {
            this.tank.setFluid(null);
        } else {
            this.coolantFactor = Math.min(100, CoolantManager.getCoolantFactor(this.tank.getFluid()));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Coolant", this.coolantRF);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    protected void handleFluidPacket(PacketCoFHBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileHeatSink.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileHeatSink.this.allowInsertion(((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]]) || !CoolantManager.isValidCoolant(resource)) {
                        return 0;
                    }
                    return TileHeatSink.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && !TileHeatSink.this.allowExtraction(((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileHeatSink.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && !TileHeatSink.this.allowExtraction(((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileHeatSink.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

