/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSawmill;
import cofh.thermalexpansion.gui.container.machine.ContainerSawmill;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSawmill
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.SAWMILL.getMetadata();
    public static int basePower = 20;
    public static int fluidFactor = 5;
    private int inputTracker;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(TFFluids.fluidResin, 0);
    protected boolean augmentTapper;
    protected boolean flagTapper;

    public static void initialize() {
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE] = new TileTEBase.SideConfig();
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].numConfig = 7;
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {2}, {1, 2}, {0, 1, 2}, {0, 1, 2}};
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE] = new TileTEBase.SlotConfig();
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE].allowExtractionSlot = new boolean[]{false, true, true, false};
        TileSawmill.VALID_AUGMENTS[TileSawmill.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSawmillTapper");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        GameRegistry.registerTileEntity(TileSawmill.class, (String)"thermalexpansion:machine_sawmill");
        TileSawmill.config();
    }

    public static void config() {
        String category = "Machine.Sawmill";
        BlockMachine.enable[TileSawmill.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileSawmill.ENERGY_CONFIGS[TileSawmill.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileSawmill() {
        this.inventory = new ItemStack[4];
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.augmentTapper) {
            this.transferOutputFluid();
        }
        super.func_73660_a();
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[2] != null) {
            if (!this.augmentSecondaryNull && !this.inventory[2].func_77969_a(secondaryItem)) {
                return false;
            }
            if (!this.augmentSecondaryNull && this.inventory[2].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[1] == null || this.inventory[1].func_77969_a(primaryItem) && this.inventory[1].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        return recipe != null && recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        if (this.augmentTapper && TapperManager.mappingExists(this.inventory[0])) {
            this.renderFluid = new FluidStack(TapperManager.getFluid(this.inventory[0]).copy(), 0);
        }
        this.processRem = this.processMax = SawmillManager.getRecipe(this.inventory[0]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        SawmillManager.RecipeSawmill recipe = SawmillManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[1].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null) {
            int modifiedChance = this.secondaryChance;
            int recipeChance = recipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[2] == null) {
                    this.inventory[2] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[2].field_77994_a += secondaryItem.field_77994_a;
                    }
                } else if (this.inventory[2].func_77969_a(secondaryItem)) {
                    this.inventory[2].field_77994_a += secondaryItem.field_77994_a;
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[2].field_77994_a += secondaryItem.field_77994_a;
                    }
                }
                if (this.inventory[2].field_77994_a > this.inventory[2].func_77976_d()) {
                    this.inventory[2].field_77994_a = this.inventory[2].func_77976_d();
                }
            }
        }
        if (this.augmentTapper && TapperManager.mappingExists(this.inventory[0])) {
            FluidStack treeFluid = TapperManager.getFluid(this.inventory[0]).copy();
            treeFluid.amount /= fluidFactor;
            this.tank.fill(treeFluid, true);
        }
        this.inventory[0].field_77994_a -= recipe.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[1] != null) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[2] == null) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiSawmill(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerSawmill(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentTapper() {
        return this.augmentTapper && this.flagTapper;
    }

    public boolean fluidArrow() {
        return this.augmentTapper && TapperManager.mappingExists(this.inventory[0]);
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerPrimary = nbt.func_74762_e("TrackOut1");
        this.outputTrackerSecondary = nbt.func_74762_e("TrackOut2");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut3");
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut1", this.outputTrackerPrimary);
        nbt.func_74768_a("TrackOut2", this.outputTrackerSecondary);
        nbt.func_74768_a("Trackout3", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.augmentTapper);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.flagTapper = this.augmentTapper = payload.getBool();
        this.renderFluid = payload.getFluidStack();
        this.tank.setFluid(this.renderFluid);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentTapper = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentTapper) {
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentTapper && "machineSawmillTapper".equals(id)) {
            this.augmentTapper = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || SawmillManager.recipeExists(stack);
    }

    @Override
    public SoundEvent getSoundEvent() {
        return TESounds.MACHINE_SAWMILL;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentTapper && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentTapper && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileSawmill.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && TileSawmill.this.sideCache[from.ordinal()] < 3) {
                        return null;
                    }
                    if (resource == null || !resource.isFluidEqual(TileSawmill.this.tank.getFluid())) {
                        return null;
                    }
                    return TileSawmill.this.tank.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && TileSawmill.this.sideCache[from.ordinal()] < 3) {
                        return null;
                    }
                    return TileSawmill.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

