/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.ISidedTexture;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.tileentity.IInventoryRetainer;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.storage.BlockCache;
import cofh.thermalexpansion.init.TETextures;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCache
extends TileInventory
implements ISidedInventory,
IReconfigurableFacing,
ISidedTexture,
ITileInfo,
IInventoryRetainer {
    public static final int CAPACITY_BASE = 20000;
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int[] SLOTS = new int[]{0, 1};
    private static boolean enableSecurity = true;
    private int compareTracker;
    private int meterTracker;
    byte facing = (byte)3;
    public byte enchantHolding;
    public boolean locked;
    int maxCacheStackSize;
    public ItemStack storedStack;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCache.class, (String)"thermalexpansion:storage_cache");
        TileCache.config();
    }

    public static void config() {
        String comment = "Enable this to allow for Caches to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Cache.Securable", true, comment);
        String category = "Storage.Cache";
        BlockCache.enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        int capacity = 20000;
        comment = "Adjust this value to change the amount of Items stored by a Basic Cache. This base value will scale with block level.";
        capacity = ThermalExpansion.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    public TileCache() {
        this.inventory = new ItemStack[2];
        this.maxCacheStackSize = TileCache.getCapacity(0, 0) - 128;
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.cache.name";
    }

    public int getType() {
        return 0;
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.maxCacheStackSize = this.storedStack != null ? TileCache.getCapacity(level, this.enchantHolding) - this.storedStack.func_77976_d() * 2 : TileCache.getCapacity(level, this.enchantHolding) - 128;
            return true;
        }
        return false;
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public static int getCapacity(int level, int enchant) {
        return CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * enchant / 2;
    }

    public int getScaledItemsStored(int scale) {
        return MathHelper.round((double)((long)this.getStoredCount() * (long)scale / (long)TileCache.getCapacity(this.level, this.enchantHolding)));
    }

    public boolean toggleLock() {
        boolean bl = this.locked = !this.locked;
        if (this.getStoredCount() <= 0 && !this.locked) {
            this.clearInventory();
        }
        this.sendTilePacket(Side.CLIENT);
        return this.locked;
    }

    public int getStoredCount() {
        return this.storedStack == null ? 0 : this.storedStack.field_77994_a + (this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a);
    }

    public ItemStack insertItem(EnumFacing from, ItemStack stack, boolean simulate) {
        if (stack == null) {
            return null;
        }
        if (this.isCreative) {
            if (!simulate && !this.locked) {
                this.setStoredItemType(stack, TileCache.getCapacity(this.level, this.enchantHolding));
            }
            return stack;
        }
        if (this.storedStack == null) {
            if (!simulate) {
                this.setStoredItemType(stack, stack.field_77994_a);
            }
            return null;
        }
        if (this.getStoredCount() == TileCache.getCapacity(this.level, this.enchantHolding)) {
            return stack;
        }
        if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack)) {
            if (this.getStoredCount() + stack.field_77994_a > TileCache.getCapacity(this.level, this.enchantHolding)) {
                ItemStack retStack = ItemHelper.cloneStack((ItemStack)stack, (int)(TileCache.getCapacity(this.level, this.enchantHolding) - this.getStoredCount()));
                if (!simulate) {
                    this.setStoredItemCount(TileCache.getCapacity(this.level, this.enchantHolding));
                }
                return retStack;
            }
            if (!simulate) {
                this.setStoredItemCount(this.getStoredCount() + stack.field_77994_a);
            }
            return null;
        }
        return stack;
    }

    public ItemStack extractItem(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.storedStack == null) {
            return null;
        }
        ItemStack ret = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.getStoredCount(), Math.min(maxExtract, this.storedStack.func_77976_d())));
        if (!simulate && !this.isCreative) {
            this.setStoredItemCount(this.getStoredCount() - ret.field_77994_a);
        }
        return ret;
    }

    protected void balanceStacks() {
        this.inventory[0] = null;
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.storedStack.func_77976_d(), this.storedStack.field_77994_a));
        this.storedStack.field_77994_a -= this.inventory[1].field_77994_a;
        if (this.storedStack.field_77994_a > this.maxCacheStackSize) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)(this.storedStack.field_77994_a - this.maxCacheStackSize));
            this.storedStack.field_77994_a = this.maxCacheStackSize;
        }
    }

    protected void clearInventory() {
        if (!this.locked) {
            this.storedStack = null;
            this.sendTilePacket(Side.CLIENT);
        } else if (this.storedStack != null) {
            this.storedStack.field_77994_a = 0;
        }
        this.inventory[0] = null;
        this.inventory[1] = null;
    }

    protected void updateTrackers() {
        int curScale = this.getScaledItemsStored(14) + (this.getStoredCount() > 0 ? 1 : 0);
        if (this.compareTracker != curScale) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        if (this.meterTracker != (curScale = Math.min(8, this.getScaledItemsStored(9)))) {
            this.meterTracker = curScale;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.facing = nbt.func_74771_c("Facing");
        this.locked = nbt.func_74767_n("Lock");
        if (nbt.func_74764_b("Item")) {
            this.storedStack = ItemHelper.readItemStackFromNBT((NBTTagCompound)nbt.func_74775_l("Item"));
            this.maxCacheStackSize = TileCache.getCapacity(this.level, this.enchantHolding) - this.storedStack.func_77976_d() * 2;
        } else {
            this.maxCacheStackSize = TileCache.getCapacity(this.level, this.enchantHolding) - 128;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        nbt.func_74757_a("Lock", this.locked);
        if (this.storedStack != null) {
            nbt.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)this.storedStack, (NBTTagCompound)new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.facing);
        payload.addByte(this.enchantHolding);
        payload.addBool(this.locked);
        payload.addItemStack(this.storedStack);
        if (this.storedStack != null) {
            payload.addInt(this.getStoredCount());
        }
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.facing = payload.getByte();
        this.enchantHolding = payload.getByte();
        this.locked = payload.getBool();
        this.storedStack = payload.getItemStack();
        if (this.storedStack != null) {
            this.storedStack.field_77994_a = payload.getInt();
            this.inventory[1] = null;
            this.balanceStacks();
        } else {
            this.storedStack = null;
            this.inventory[0] = null;
            this.inventory[1] = null;
        }
    }

    public ItemStack getStoredItemType() {
        return ItemHelper.cloneStack((ItemStack)this.storedStack, (int)this.getStoredCount());
    }

    public void setStoredItemCount(int amount) {
        if (this.storedStack == null) {
            return;
        }
        this.storedStack.field_77994_a = Math.min(amount, this.getMaxStoredCount());
        if (amount > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.markChunkDirty();
    }

    public void setStoredItemType(ItemStack stack, int amount) {
        if (stack == null) {
            this.clearInventory();
        } else {
            this.storedStack = ItemHelper.cloneStack((ItemStack)stack, (int)Math.min(amount, this.getMaxStoredCount()));
            this.maxCacheStackSize = TileCache.getCapacity(this.level, this.enchantHolding) - this.storedStack.func_77976_d() * 2;
            this.balanceStacks();
        }
        this.updateTrackers();
        this.sendTilePacket(Side.CLIENT);
        this.markChunkDirty();
    }

    public int getMaxStoredCount() {
        return TileCache.getCapacity(this.level, this.enchantHolding);
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.isCreative) {
            return ItemHelper.cloneStack((ItemStack)this.inventory[slot], (int)amount);
        }
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            amount = this.inventory[slot].field_77994_a;
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
        this.storedStack.field_77994_a = this.storedStack.field_77994_a + ((this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
        if (this.storedStack.field_77994_a > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.markChunkDirty();
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        boolean stackCheck;
        if (this.isCreative) {
            return;
        }
        this.inventory[slot] = stack;
        boolean bl = stackCheck = this.storedStack == null;
        if (slot == 0) {
            if (this.inventory[0] == null) {
                return;
            }
            if (this.storedStack == null) {
                this.storedStack = this.inventory[0].func_77946_l();
                this.inventory[0] = null;
                this.maxCacheStackSize = TileCache.getCapacity(this.level, this.enchantHolding) - this.storedStack.func_77976_d() * 2;
            } else {
                this.storedStack.field_77994_a = this.storedStack.field_77994_a + (this.inventory[0].field_77994_a + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
            }
            this.balanceStacks();
        } else {
            if (this.storedStack == null) {
                if (this.inventory[1] == null) {
                    return;
                }
                this.storedStack = this.inventory[1].func_77946_l();
                this.storedStack.field_77994_a = 0;
                this.maxCacheStackSize = TileCache.getCapacity(this.level, this.enchantHolding) - this.storedStack.func_77976_d() * 2;
            }
            this.storedStack.field_77994_a = this.storedStack.field_77994_a + ((this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
            if (this.storedStack.field_77994_a > 0) {
                this.balanceStacks();
            } else {
                this.clearInventory();
            }
        }
        this.updateTrackers();
        this.markChunkDirty();
        if (stackCheck != (this.storedStack == null)) {
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && (this.storedStack == null || ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0 && (this.storedStack == null || ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.storedStack));
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    public int getNumPasses() {
        return 2;
    }

    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return this.isCreative ? TETextures.CACHE_BOTTOM_C : TETextures.CACHE_BOTTOM[this.level];
            }
            if (side == 1) {
                return this.isCreative ? TETextures.CACHE_TOP_C : TETextures.CACHE_TOP[this.level];
            }
            return side != this.facing ? (this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level]) : (this.isCreative ? TETextures.CACHE_FACE_C : TETextures.CACHE_FACE[this.level]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG_NONE : (this.isCreative ? TETextures.CACHE_METER_C : TETextures.CACHE_METER[MathHelper.clamp((int)this.getScaledItemsStored(9), (int)0, (int)8)]);
        }
        return this.isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[this.level];
    }

    public void getTileInfo(List<ITextComponent> info, EnumFacing side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        if (this.storedStack != null) {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.getItemName((ItemStack)this.storedStack)));
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.amount") + ": " + this.getStoredCount() + " / " + TileCache.getCapacity(this.level, this.enchantHolding)));
        } else {
            info.add((ITextComponent)new TextComponentString(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.localize((String)"info.cofh.empty")));
        }
        info.add((ITextComponent)new TextComponentString(this.locked ? StringHelper.localize((String)"info.cofh.locked") : StringHelper.localize((String)"info.cofh.unlocked")));
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        int uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return true;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return true;
            }
            case CREATIVE: {
                return !this.isCreative;
            }
        }
        return false;
    }

    public boolean retainInventory() {
        return true;
    }
}

