/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.init;

import cofh.core.init.CoreProps;
import cofh.core.render.IModelRegister;
import cofh.core.util.ConfigHandler;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.ItemFlorb;
import cofh.thermalexpansion.util.BehaviorFlorbDispense;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.item.ItemMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TEFlorbs {
    public static boolean enable = true;
    public static ArrayList<ItemStack> florbList = new ArrayList();
    public static Map<String, ItemStack> florbMap = new HashMap<String, ItemStack>();
    public static final ConfigHandler CONFIG_FLORBS = new ConfigHandler("5.1.9");
    public static ItemFlorb itemFlorb;
    public static ItemStack florb;
    public static ItemStack florbMagmatic;

    private TEFlorbs() {
    }

    public static void preInit() {
        CONFIG_FLORBS.setConfiguration(new Configuration(new File(CoreProps.configDir, "cofh/thermalexpansion/florbs.cfg"), true));
        String category = "General";
        String comment = "If TRUE, the recipe for Florbs is enabled. Setting this to FALSE means that you actively dislike fun things.";
        enable = CONFIG_FLORBS.getConfiguration().getBoolean("EnableRecipe", category, enable, comment);
        itemFlorb = (ItemFlorb)new ItemFlorb().func_77655_b("florb");
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)itemFlorb);
    }

    public static void initialize() {
        florb = itemFlorb.addItem(0, "florb");
        florbMagmatic = itemFlorb.addItem(1, "florbMagmatic");
    }

    public static void postInit() {
        TEFlorbs.parseFlorbs();
        BlockDispenser.field_149943_a.func_82595_a((Object)itemFlorb, (Object)new BehaviorFlorbDispense());
        CONFIG_FLORBS.cleanUp(false, false);
    }

    public static void parseFlorbs() {
        ItemStack florbStack = ItemHelper.cloneStack((ItemStack)florb, (int)4);
        ItemStack florbMagmaticStack = ItemHelper.cloneStack((ItemStack)florbMagmatic, (int)4);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!fluid.canBePlacedInWorld()) continue;
            ItemStack stack = fluid.getTemperature() < 1000 ? new ItemStack((Item)itemFlorb, 1, 0) : new ItemStack((Item)itemFlorb, 1, 1);
            TEFlorbs.addFlorb(stack, fluid);
            if (!enable || !CONFIG_FLORBS.get("Whitelist", fluid.getName(), true)) continue;
            if (fluid.getTemperature() < 1000) {
                TransposerManager.addFillRecipe(1600, florb, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
                continue;
            }
            TransposerManager.addFillRecipe(1600, florbMagmatic, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
        }
        if (!enable) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)florbStack, (Object[])new Object[]{"dustWood", "crystalSlag", "slimeball"}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", "slimeball", Items.field_151065_br}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", Items.field_151064_bs}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)florbStack, (Object[])new Object[]{"dustWood", "crystalSlag", ItemMaterial.globRosin}));
        GameRegistry.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", ItemMaterial.globRosin, Items.field_151065_br}));
    }

    private static void addFlorb(ItemStack florb, Fluid fluid) {
        ItemFlorb.setTag(florb, fluid);
        florbList.add(florb);
        florbMap.put(fluid.getName(), florb);
    }

    @Nullable
    public static ItemStack getFlorb(Fluid fluid) {
        return florbMap.get(fluid.getName());
    }
}

