/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.charger;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiCharger;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.charger.ChargerRecipeHandler;
import cofh.thermalexpansion.plugins.jei.crafting.charger.ChargerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ChargerRecipeCategory
extends BlankRecipeCategory<ChargerRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic background;
    IDrawableStatic energyMeter;
    String localizedName;

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChargerRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ChargerRecipeHandler()});
        registry.addRecipes(ChargerRecipeCategory.getRecipes(guiHelper));
        registry.addRecipeClickArea(GuiCharger.class, 79, 53, 18, 16, new String[]{"thermalexpansion.charger"});
        registry.addRecipeCategoryCraftingItem(BlockMachine.machineCharger, new String[]{"thermalexpansion.charger"});
    }

    public static List<ChargerRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<ChargerRecipeWrapper> recipes = new ArrayList<ChargerRecipeWrapper>();
        for (ChargerManager.RecipeCharger recipe : ChargerManager.getRecipeList()) {
            recipes.add(new ChargerRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public ChargerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCharger.TEXTURE, 62, 11, 88, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.charger.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.charger";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChargerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiItemStacks.init(1, false, 78, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (ItemStack)outputs.get(0));
    }
}

