/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.refinery;

import cofh.thermalexpansion.block.machine.TileRefinery;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<FluidStack>> inputFluids;
    final List<ItemStack> outputs;
    final List<FluidStack> outputFluids;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public RefineryRecipeWrapper(IGuiHelper guiHelper, RefineryManager.RecipeRefinery recipe) {
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        recipeInputFluids.add(recipe.getInput());
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.add(recipe.getOutputItem());
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        recipeOutputFluids.add(recipe.getOutputFluid());
        this.inputFluids = Collections.singletonList(recipeInputFluids);
        this.outputs = recipeOutputs;
        this.outputFluids = recipeOutputFluids;
        this.energy = recipe.getEnergy();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(4);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileRefinery.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileRefinery.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputs);
        ingredients.setOutputs(FluidStack.class, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(46, 23, this.inputFluids.get(0).get(0), 24, 16);
        this.fluid.draw(minecraft, 46, 23);
        this.progress.draw(minecraft, 46, 23);
        this.speed.draw(minecraft, 22, 40);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

