/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.blockbakery.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class RenderDynamo
implements ILayeredBlockBakery {
    public static final RenderDynamo INSTANCE = new RenderDynamo();
    private static CCModel[][] modelCoil = new CCModel[2][6];
    private static CCModel[][] modelBase = new CCModel[2][6];
    private static CCModel[][] modelBaseOverlay = new CCModel[2][6];
    private static CCModel[] modelAnimation = new CCModel[6];

    private static void generateModels() {
        double d1 = 9.765625E-4;
        double d2 = 0.375;
        double d3 = 0.625;
        RenderDynamo.modelCoil[0][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelCoil[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 0.0, -4.0, 8.0, 8.0, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelBase[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelBase[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0, -8.0, -8.0, 16.0, 10.0, 16.0, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelBaseOverlay[0][1] = CCModel.quadModel((int)24).generateBox(0, -8.0 - d1, -8.0 - d1, -8.0 - d1, 16.0 + 2.0 * d1, 10.0 + 2.0 * d1, 16.0 + 2.0 * d1, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelBaseOverlay[1][1] = CCModel.quadModel((int)24).generateBox(0, -8.0 - d1, -8.0 - d1, -8.0 - d1, 16.0 + 2.0 * d1, 10.0 + 2.0 * d1, 16.0 + 2.0 * d1, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals().shrinkUVs(d1);
        RenderDynamo.modelAnimation[0] = CCModel.quadModel((int)16).generateBlock(0, d1, d2 + d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 3).computeNormals();
        RenderDynamo.modelAnimation[1] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, d3 - d1, 1.0 - d1, 3).computeNormals();
        RenderDynamo.modelAnimation[2] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d2 + d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 12).computeNormals();
        RenderDynamo.modelAnimation[3] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, 1.0 - d1, 1.0 - d1, d3 - d1, 12).computeNormals();
        RenderDynamo.modelAnimation[4] = CCModel.quadModel((int)16).generateBlock(0, d2 + d1, d1, d1, 1.0 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        RenderDynamo.modelAnimation[5] = CCModel.quadModel((int)16).generateBlock(0, d1, d1, d1, d3 - d1, 1.0 - d1, 1.0 - d1, 48).computeNormals();
        for (CCModel[] model : modelCoil) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
        for (CCModel[] model : modelBase) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
        for (CCModel[] model : modelBaseOverlay) {
            CCModel.generateSidedModels((CCModel[])model, (int)1, (Vector3)new Vector3());
        }
    }

    protected void renderCoil(CCRenderState ccrs, int facing, boolean active) {
        if (active) {
            modelCoil[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO_COIL_REDSTONE)});
        } else {
            modelCoil[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO_COIL_REDSTONE)});
        }
    }

    protected void renderBase(CCRenderState ccrs, int facing, boolean active, int type) {
        if (active) {
            modelBase[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO[type])});
        } else {
            modelBase[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(TETextures.DYNAMO[type])});
        }
    }

    protected void renderBaseOverlay(CCRenderState ccrs, int facing, boolean active, TextureAtlasSprite sprite) {
        if (sprite != null) {
            if (active) {
                modelBaseOverlay[0][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(sprite)});
            } else {
                modelBaseOverlay[1][facing].render(ccrs, new IVertexOperation[]{new Translation(0.5, 0.5, 0.5), new IconTransformation(sprite)});
            }
        }
    }

    protected void renderAnimation(CCRenderState ccrs, int facing, boolean active, int type, TextureAtlasSprite icon) {
        if (active) {
            modelAnimation[facing].render(ccrs, new IVertexOperation[]{new IconTransformation(icon)});
        }
    }

    private static TextureAtlasSprite getOverlaySprite(EnumFacing face, int level) {
        if (level == 0) {
            return null;
        }
        return TETextures.DYNAMO_OVERLAY[level];
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, TileEntity tile) {
        TileDynamoBase dynamo = (TileDynamoBase)tile;
        if (dynamo == null) {
            return null;
        }
        state = state.withProperty((IUnlistedProperty)TEProps.CREATIVE, (Object)dynamo.isCreative);
        state = state.withProperty((IUnlistedProperty)TEProps.LEVEL, (Object)dynamo.getLevel());
        state = state.withProperty((IUnlistedProperty)TEProps.ACTIVE, (Object)dynamo.isActive);
        state = state.withProperty((IUnlistedProperty)TEProps.FACING, (Object)EnumFacing.field_82609_l[dynamo.getFacing()]);
        state = state.withProperty((IUnlistedProperty)TEProps.ACTIVE_SPRITE_PROPERTY, (Object)new ResourceLocation(dynamo.getActiveIcon().func_94215_i()));
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        if (face == null && stack != null) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexBuffer)buffer);
            boolean creative = BlockDynamo.itemBlock.isCreative(stack);
            byte level = BlockDynamo.itemBlock.getLevel(stack);
            this.renderCoil(ccrs, 1, false);
            this.renderBase(ccrs, 1, false, stack.func_77960_j());
            if (level > 0) {
                this.renderBaseOverlay(ccrs, 1, false, creative ? TETextures.DYNAMO_OVERLAY_C : RenderDynamo.getOverlaySprite(face, level));
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        if (face == null && state != null) {
            boolean creative = (Boolean)state.getValue((IUnlistedProperty)TEProps.CREATIVE);
            int level = (Integer)state.getValue((IUnlistedProperty)TEProps.LEVEL);
            boolean active = (Boolean)state.getValue((IUnlistedProperty)TEProps.ACTIVE);
            int facing = ((EnumFacing)state.getValue((IUnlistedProperty)TEProps.FACING)).ordinal();
            int type = ((BlockDynamo.Type)((Object)state.func_177229_b(BlockDynamo.VARIANT))).getMetadata();
            TextureAtlasSprite activeSprite = TextureUtils.getTexture((ResourceLocation)((ResourceLocation)state.getValue((IUnlistedProperty)TEProps.ACTIVE_SPRITE_PROPERTY)));
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexBuffer)buffer);
            if (layer == BlockRenderLayer.SOLID) {
                this.renderCoil(ccrs, facing, active);
                this.renderAnimation(ccrs, facing, active, type, activeSprite);
            } else {
                this.renderBase(ccrs, facing, active, type);
                if (level > 0) {
                    this.renderBaseOverlay(ccrs, facing, active, creative ? TETextures.DYNAMO_OVERLAY_C : RenderDynamo.getOverlaySprite(face, level));
                }
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return new ArrayList<BakedQuad>();
    }

    static {
        RenderDynamo.generateModels();
    }
}

