/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.item.ItemMaterial;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class SteamManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 32000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return 0;
        }
        int energy = fuelMap.get((Object)new ComparableItemStack(stack));
        return energy > 0 ? energy : TileEntityFurnace.func_145952_a((ItemStack)stack) * 10;
    }

    public static void initialize() {
        SteamManager.addFuel(new ItemStack(Items.field_151044_h, 1, 0), 24000);
        SteamManager.addFuel(new ItemStack(Blocks.field_150402_ci), 240000);
        SteamManager.addFuel(new ItemStack(Items.field_151044_h, 1, 1), 16000);
        SteamManager.addFuel(ItemHelper.cloneStack((ItemStack)ItemMaterial.gemCoke, (int)1), 40000);
        SteamManager.loadFuels();
    }

    public static void loadFuels() {
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack == null || energy < 1000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

