/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import codechicken.lib.item.ItemStackRegistry;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalfoundation.block.BlockGlass;
import cofh.thermalfoundation.block.BlockGlassAlloy;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmelterManager {
    private static Map<List<ComparableItemStackSmelter>, RecipeSmelter> recipeMap = new THashMap();
    private static Set<ComparableItemStackSmelter> validationSet = new THashSet();
    private static Set<ComparableItemStackSmelter> lockSet = new THashSet();
    static final ItemStack BLOCK_SAND = new ItemStack((Block)Blocks.field_150354_m);
    static final ItemStack BLOCK_SOUL_SAND = new ItemStack(Blocks.field_150425_aM);
    static final int ORE_MULTIPLIER = 2;
    static final int ORE_MULTIPLIER_SPECIAL = 3;
    static final int DEFAULT_ENERGY = 4000;

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return false;
        }
        ComparableItemStackSmelter query = new ComparableItemStackSmelter(primaryInput);
        ComparableItemStackSmelter querySecondary = new ComparableItemStackSmelter(secondaryInput);
        RecipeSmelter recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        return recipe == null && recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static RecipeSmelter getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return null;
        }
        ComparableItemStackSmelter query = new ComparableItemStackSmelter(primaryInput);
        ComparableItemStackSmelter querySecondary = new ComparableItemStackSmelter(secondaryInput);
        RecipeSmelter recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return SmelterManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static RecipeSmelter[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSmelter[recipeMap.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return input != null && validationSet.contains((Object)new ComparableItemStackSmelter(input));
    }

    public static boolean isItemFlux(ItemStack input) {
        return input != null && lockSet.contains((Object)new ComparableItemStackSmelter(input));
    }

    public static void initialize() {
        SmelterManager.addFlux(BLOCK_SAND);
        SmelterManager.addFlux(BLOCK_SOUL_SAND);
        SmelterManager.addFlux(ItemMaterial.crystalSlagRich);
        SmelterManager.addFlux(ItemMaterial.crystalCinnabar);
        int energy = 4000;
        SmelterManager.addRecipe(energy, new ItemStack(Blocks.field_150347_e, 2), BLOCK_SAND, new ItemStack(Blocks.field_150417_aV, 1), ItemMaterial.crystalSlag, 100);
        SmelterManager.addRecipe(energy, new ItemStack(Blocks.field_150450_ax), BLOCK_SAND, new ItemStack(Blocks.field_150451_bX), ItemMaterial.crystalSlagRich, 50);
        SmelterManager.addRecipe(energy, new ItemStack(Blocks.field_150424_aL, 2), BLOCK_SOUL_SAND, new ItemStack(Blocks.field_150385_bj, 2), ItemMaterial.dustSulfur, 25);
        SmelterManager.addRecipe(energy, new ItemStack(Blocks.field_150449_bY), BLOCK_SOUL_SAND, new ItemStack(Blocks.field_150371_ca), ItemMaterial.crystalSlagRich, 25);
        int energy2 = 4000;
        ItemStack blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassCopper, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustCopper", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotCopper", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassTin, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustTin", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotTin", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassSilver, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustSilver", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotSilver", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassLead, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustLead", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotLead", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassAluminum, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustAluminum", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotAluminum", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassNickel, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustNickel", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotNickel", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassPlatinum, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustPlatinum", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotPlatinum", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassIridium, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustIridium", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotIridium", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlass.glassMithril, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustMithril", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "dustMithril", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassSteel, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustSteel", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotSteel", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassElectrum, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustElectrum", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotElectrum", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassInvar, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustInvar", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotInvar", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassBronze, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustBronze", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotBronze", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassConstantan, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustConstantan", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotConstantan", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassSignalum, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustSignalum", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotSignalum", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassLumium, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustLumium", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotLumium", 1, "dustObsidian", 4, blockGlass);
        blockGlass = ItemHelper.cloneStack((ItemStack)BlockGlassAlloy.glassEnderium, (int)2);
        SmelterManager.addAlloyRecipe(energy2, "dustEnderium", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addAlloyRecipe(energy2, "ingotEnderium", 1, "dustObsidian", 4, blockGlass);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIron", "dustIron", ItemMaterial.ingotIron, ItemMaterial.ingotNickel);
        SmelterManager.addDefaultOreDictionaryRecipe("oreGold", "dustGold", ItemMaterial.ingotGold, null, 20, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("oreCopper", "dustCopper", ItemMaterial.ingotCopper, ItemMaterial.ingotGold);
        SmelterManager.addDefaultOreDictionaryRecipe("oreTin", "dustTin", ItemMaterial.ingotTin, ItemMaterial.ingotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreSilver", "dustSilver", ItemMaterial.ingotSilver, ItemMaterial.ingotLead);
        SmelterManager.addDefaultOreDictionaryRecipe("oreAluminum", "dustAluminum", ItemMaterial.ingotAluminum, ItemMaterial.ingotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreLead", "dustLead", ItemMaterial.ingotLead, ItemMaterial.ingotSilver);
        SmelterManager.addDefaultOreDictionaryRecipe("oreNickel", "dustNickel", ItemMaterial.ingotNickel, ItemMaterial.ingotPlatinum, 15, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("orePlatinum", "dustPlatinum", ItemMaterial.ingotPlatinum, ItemMaterial.ingotIridium);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIridium", "dustIridium", ItemMaterial.ingotIridium, ItemMaterial.ingotPlatinum);
        SmelterManager.addDefaultOreDictionaryRecipe("oreMithril", "dustMithril", ItemMaterial.ingotMithril, ItemMaterial.ingotGold);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustSteel", ItemMaterial.ingotSteel);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustElectrum", ItemMaterial.ingotElectrum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustInvar", ItemMaterial.ingotInvar);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBronze", ItemMaterial.ingotBronze);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustConstantan", ItemMaterial.ingotConstantan);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustSignalum", ItemMaterial.ingotSignalum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustLumium", ItemMaterial.ingotLumium);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustEnderium", ItemMaterial.ingotEnderium);
        ItemStack stackSteel = ItemHelper.cloneStack((ItemStack)ItemMaterial.ingotSteel, (int)1);
        SmelterManager.addAlloyRecipe(4000, "dustIron", 1, "dustCoal", 4, stackSteel);
        SmelterManager.addAlloyRecipe(4400, "ingotIron", 1, "dustCoal", 4, stackSteel);
        SmelterManager.addAlloyRecipe(4000, "dustIron", 1, "dustCharcoal", 4, stackSteel);
        SmelterManager.addAlloyRecipe(4400, "ingotIron", 1, "dustCharcoal", 4, stackSteel);
        SmelterManager.addAlloyRecipe(2000, "dustIron", 1, "fuelCoke", 1, stackSteel);
        SmelterManager.addAlloyRecipe(2400, "ingotIron", 1, "fuelCoke", 1, stackSteel);
        ItemStack stackElectrum = ItemHelper.cloneStack((ItemStack)ItemMaterial.ingotElectrum, (int)2);
        SmelterManager.addAlloyRecipe(1600, "dustSilver", 1, "dustGold", 1, stackElectrum);
        SmelterManager.addAlloyRecipe(2000, "dustSilver", 1, "ingotGold", 1, stackElectrum);
        SmelterManager.addAlloyRecipe(2000, "ingotSilver", 1, "dustGold", 1, stackElectrum);
        SmelterManager.addAlloyRecipe(2400, "ingotSilver", 1, "ingotGold", 1, stackElectrum);
        ItemStack stackInvar = ItemHelper.cloneStack((ItemStack)ItemMaterial.ingotInvar, (int)3);
        SmelterManager.addAlloyRecipe(2400, "dustNickel", 1, "dustIron", 2, stackInvar);
        SmelterManager.addAlloyRecipe(3000, "dustNickel", 1, "ingotIron", 2, stackInvar);
        SmelterManager.addAlloyRecipe(3000, "ingotNickel", 1, "dustIron", 2, stackInvar);
        SmelterManager.addAlloyRecipe(3600, "ingotNickel", 1, "ingotIron", 2, stackInvar);
        ItemStack stackBronze = ItemHelper.cloneStack((ItemStack)ItemMaterial.ingotBronze, (int)4);
        SmelterManager.addAlloyRecipe(3200, "dustTin", 1, "dustCopper", 3, stackBronze);
        SmelterManager.addAlloyRecipe(4000, "dustTin", 1, "ingotCopper", 3, stackBronze);
        SmelterManager.addAlloyRecipe(4000, "ingotTin", 1, "dustCopper", 3, stackBronze);
        SmelterManager.addAlloyRecipe(4800, "ingotTin", 1, "ingotCopper", 3, stackBronze);
        ItemStack stackConstantan = ItemHelper.cloneStack((ItemStack)ItemMaterial.ingotConstantan, (int)2);
        SmelterManager.addAlloyRecipe(1600, "dustCopper", 1, "dustNickel", 1, stackConstantan);
        SmelterManager.addAlloyRecipe(2000, "dustCopper", 1, "ingotNickel", 1, stackConstantan);
        SmelterManager.addAlloyRecipe(2000, "ingotCopper", 1, "dustNickel", 1, stackConstantan);
        SmelterManager.addAlloyRecipe(2400, "ingotCopper", 1, "ingotNickel", 1, stackConstantan);
        energy = 6000;
        SmelterManager.addRecipe(energy, BLOCK_SAND, new ItemStack(Items.field_151111_aL), new ItemStack(Items.field_151042_j, 4), ItemMaterial.crystalSlagRich, 10);
        SmelterManager.addRecipe(energy, BLOCK_SAND, new ItemStack(Items.field_151033_d), new ItemStack(Items.field_151042_j, 1), ItemMaterial.crystalSlag, 90);
        ItemStack ingot = new ItemStack(Items.field_151042_j, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151133_ar), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151139_aw), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151066_bu), ingot, 7);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Block)Blocks.field_150438_bZ), ingot, 5);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Blocks.field_150411_aY, 8), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Blocks.field_150443_bT), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151040_l), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151035_b), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151036_c), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151037_a), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151019_K), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151028_Y), ingot, 5);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151030_Z), ingot, 8);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151165_aa), ingot, 7);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151167_ab), ingot, 4);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151138_bX), ingot, 10);
        for (int i = 0; i < 3; ++i) {
            SmelterManager.addRecycleRecipe(4800 + 1200 * (3 - i), new ItemStack(Blocks.field_150467_bQ, 1, i), ingot, 4 + 9 * (3 - i));
        }
        ingot = new ItemStack(Items.field_151043_k);
        SmelterManager.addRecipe(energy, BLOCK_SAND, new ItemStack(Items.field_151113_aN), new ItemStack(Items.field_151043_k, 4), ItemMaterial.crystalSlagRich, 10);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Blocks.field_150445_bS), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151010_B), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151005_D), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151006_E), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151011_C), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151013_M), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151169_ag), ingot, 5);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151171_ah), ingot, 8);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151149_ai), ingot, 7);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151151_aj), ingot, 4);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151136_bY), ingot, 10);
        for (TFEquipment.ToolSetVanilla toolSetVanilla : new TFEquipment.ToolSetVanilla[]{TFEquipment.ToolSetVanilla.IRON, TFEquipment.ToolSetVanilla.GOLD}) {
            ingot = (ItemStack)OreDictionary.getOres((String)toolSetVanilla.ingot, (boolean)false).get(0);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolBow, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolFishingRod, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShears, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolSickle, ingot, 3);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolHammer, ingot, 5);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShield, ingot, 6);
        }
        for (TFEquipment.ToolSetVanilla toolSetVanilla : TFEquipment.ToolSet.values()) {
            ingot = (ItemStack)OreDictionary.getOres((String)toolSetVanilla.ingot, (boolean)false).get(0);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolSword, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolPickaxe, ingot, 3);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolAxe, ingot, 3);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShovel, ingot, 1);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolHoe, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolBow, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolFishingRod, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShears, ingot, 2);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolSickle, ingot, 3);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolHammer, ingot, 5);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShield, ingot, 6);
        }
        for (TFEquipment.ToolSetVanilla toolSetVanilla : TFEquipment.ArmorSet.values()) {
            ingot = (ItemStack)OreDictionary.getOres((String)toolSetVanilla.ingot, (boolean)false).get(0);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.armorHelmet, ingot, 5);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.armorChestplate, ingot, 8);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.armorLegs, ingot, 7);
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.armorBoots, ingot, 4);
        }
        SmelterManager.loadRecipes();
    }

    public static void loadRecipes() {
        ItemStack output;
        String[] oreNames;
        for (String oreName : oreNames = OreDictionary.getOreNames()) {
            String oreType;
            if (oreName.startsWith("ore")) {
                oreType = oreName.substring(3, oreName.length());
                if (!SmelterManager.isStandardOre(oreName)) continue;
                SmelterManager.addDefaultOreDictionaryRecipe(oreType);
                continue;
            }
            if (!oreName.startsWith("dust")) continue;
            oreType = oreName.substring(4, oreName.length());
            if (!SmelterManager.isStandardOre(oreName)) continue;
            SmelterManager.addDefaultOreDictionaryRecipe(oreType);
        }
        if (ItemHelper.oreNameExists((String)"ingotConductiveIron")) {
            output = (ItemStack)OreDictionary.getOres((String)"ingotConductiveIron", (boolean)false).get(0);
            SmelterManager.addAlloyRecipe(1600, "dustIron", 1, "dustRedstone", 1, output);
            SmelterManager.addAlloyRecipe(2000, "ingotIron", 1, "dustRedstone", 1, output);
        }
        if (ItemHelper.oreNameExists((String)"ingotPulsatingIron")) {
            output = (ItemStack)OreDictionary.getOres((String)"ingotPulsatingIron", (boolean)false).get(0);
            SmelterManager.addAlloyRecipe(2000, "dustIron", 1, "enderpearl", 1, output);
            SmelterManager.addAlloyRecipe(2400, "ingotIron", 1, "enderpearl", 1, output);
        }
        if (ItemHelper.oreNameExists((String)"ingotVibrantAlloy")) {
            output = (ItemStack)OreDictionary.getOres((String)"ingotVibrantAlloy", (boolean)false).get(0);
            SmelterManager.addAlloyRecipe(2000, "dustEnergeticAlloy", 1, "enderpearl", 1, output);
            SmelterManager.addAlloyRecipe(2400, "ingotEnergeticAlloy", 1, "enderpearl", 1, output);
        }
        if (ItemHelper.oreNameExists((String)"ingotSoularium")) {
            output = (ItemStack)OreDictionary.getOres((String)"ingotSoularium", (boolean)false).get(0);
            SmelterManager.addAlloyRecipe(2000, ItemMaterial.dustGold, BLOCK_SOUL_SAND, output);
            SmelterManager.addAlloyRecipe(2400, ItemMaterial.ingotGold, BLOCK_SOUL_SAND, output);
        }
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<ComparableItemStackSmelter>, RecipeSmelter> entry : recipeMap.entrySet()) {
            RecipeSmelter tempRecipe = entry.getValue();
            ComparableItemStackSmelter primary = new ComparableItemStackSmelter(tempRecipe.primaryInput);
            ComparableItemStackSmelter secondary = new ComparableItemStackSmelter(tempRecipe.secondaryInput);
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        THashSet tempSet2 = new THashSet();
        for (ComparableItemStackSmelter entry : lockSet) {
            ComparableItemStackSmelter lock = new ComparableItemStackSmelter(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static RecipeSmelter addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || energy <= 0 || SmelterManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        RecipeSmelter recipe = new RecipeSmelter(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(new ComparableItemStackSmelter(primaryInput), new ComparableItemStackSmelter(secondaryInput)), recipe);
        validationSet.add(new ComparableItemStackSmelter(primaryInput));
        validationSet.add(new ComparableItemStackSmelter(secondaryInput));
        return recipe;
    }

    public static RecipeSmelter addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static RecipeSmelter addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static RecipeSmelter removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        return recipeMap.remove(Arrays.asList(new ComparableItemStackSmelter(primaryInput), new ComparableItemStackSmelter(secondaryInput)));
    }

    private static void addFlux(ItemStack flux) {
        lockSet.add(new ComparableItemStackSmelter(flux));
    }

    private static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot, ItemStack ingotRelated, int richSlagChance, int slagOreChance, int slagDustChance) {
        if (ingot == null) {
            return;
        }
        if (oreName != null) {
            SmelterManager.addOreToIngotRecipe(4000, oreName, ItemHelper.cloneStack((ItemStack)ingot, (int)2), ItemHelper.cloneStack((ItemStack)ingot, (int)3), ItemHelper.cloneStack((ItemStack)ingotRelated, (int)1), richSlagChance, slagOreChance);
        }
        if (dustName != null) {
            SmelterManager.addDustToIngotRecipe(800, dustName, ItemHelper.cloneStack((ItemStack)ingot, (int)2), slagDustChance);
        }
    }

    private static void addDefaultOreDictionaryRecipe(String oreType) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreType, "");
    }

    private static void addDefaultOreDictionaryRecipe(String oreType, String relatedType) {
        if (oreType.length() <= 0) {
            return;
        }
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        String relatedName = null;
        List registeredOre = OreDictionary.getOres((String)oreName, (boolean)false);
        List registeredDust = OreDictionary.getOres((String)dustName, (boolean)false);
        List registeredIngot = OreDictionary.getOres((String)ingotName, (boolean)false);
        List registeredRelated = new ArrayList();
        if (!relatedType.isEmpty()) {
            relatedName = "ingot" + StringHelper.titleCase((String)relatedType);
            registeredRelated = OreDictionary.getOres((String)relatedName, (boolean)false);
        }
        if (registeredIngot.isEmpty()) {
            return;
        }
        ItemStack ingot = ItemStackRegistry.findItemStack((String)"thermalfoundation", (String)ingotName, (int)1);
        if (ingot != null && !OreDictionaryArbiter.getAllOreNames((ItemStack)ingot).contains(ingotName)) {
            ingot = null;
        }
        if (ingot == null) {
            ingot = (ItemStack)registeredIngot.get(0);
        }
        if (registeredOre.isEmpty()) {
            oreName = null;
        }
        if (registeredDust.isEmpty()) {
            dustName = null;
        }
        ItemStack related = null;
        if (relatedName != null && (related = ItemStackRegistry.findItemStack((String)"thermalfoundation", (String)relatedName, (int)1)) != null && !OreDictionaryArbiter.getAllOreNames((ItemStack)related).contains(relatedName)) {
            related = null;
        }
        if (related == null && !registeredRelated.isEmpty()) {
            related = (ItemStack)registeredRelated.get(0);
        }
        SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, ingot, related, 5, 75, 25);
    }

    private static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, ingot, null, 5, 75, 25);
    }

    private static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot, ItemStack ingotRelated) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, ingot, ingotRelated, 5, 75, 25);
    }

    private static void addOreToIngotRecipe(int energy, String oreName, ItemStack ingot2, ItemStack ingot3, ItemStack ingotSecondary, int richSlagChance, int slagOreChance) {
        List registeredOres = OreDictionary.getOres((String)oreName, (boolean)false);
        if (registeredOres.size() > 0) {
            ItemStack ore = (ItemStack)registeredOres.get(0);
            SmelterManager.addRecipe(energy, ore, BLOCK_SAND, ingot2, ItemMaterial.crystalSlagRich, richSlagChance);
            SmelterManager.addRecipe(energy, ore, ItemMaterial.crystalSlagRich, ingot3, ItemMaterial.crystalSlag, slagOreChance);
            if (ingotSecondary != null) {
                SmelterManager.addRecipe(energy, ore, ItemMaterial.crystalCinnabar, ingot3, ingotSecondary, 100);
            } else {
                SmelterManager.addRecipe(energy, ore, ItemMaterial.crystalCinnabar, ingot3, ItemMaterial.crystalSlagRich, 75);
            }
        }
    }

    private static void addDustToIngotRecipe(int energy, String dustName, ItemStack ingot2, int slagDustChance) {
        List registeredOres = OreDictionary.getOres((String)dustName, (boolean)false);
        if (registeredOres.size() > 0) {
            SmelterManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)2), BLOCK_SAND, ingot2, ItemMaterial.crystalSlag, slagDustChance);
        }
    }

    private static void addAlloyRecipe(int energy, String primaryOreName, int primaryAmount, String secondaryOreName, int secondaryAmount, ItemStack primaryOutput) {
        List primaryOreList = OreDictionary.getOres((String)primaryOreName, (boolean)false);
        List secondaryOreList = OreDictionary.getOres((String)secondaryOreName, (boolean)false);
        if (primaryOreList.size() > 0 && secondaryOreList.size() > 0) {
            SmelterManager.addAlloyRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)primaryOreList.get(0)), (int)primaryAmount), ItemHelper.cloneStack((ItemStack)((ItemStack)secondaryOreList.get(0)), (int)secondaryAmount), primaryOutput);
        }
    }

    private static void addAlloyRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    private static RecipeSmelter addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize) {
        return SmelterManager.addRecipe(energy, input, BLOCK_SAND, ItemHelper.cloneStack((ItemStack)output, (int)outputSize), ItemMaterial.crystalSlag, outputSize * 5 + 5);
    }

    private static boolean isStandardOre(String oreName) {
        return ItemHelper.oreNameExists((String)oreName) && FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0));
    }

    public static class ComparableItemStackSmelter
    extends ComparableItemStack {
        public static final String ORE = "ore";
        public static final String DUST = "dust";
        public static final String INGOT = "ingot";
        public static final String BLOCK = "block";
        public static final String NUGGET = "nugget";
        public static final Set<String> EQUALS = new THashSet();

        public static boolean safeOreType(String oreName) {
            return EQUALS.contains(oreName) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(BLOCK) || oreName.startsWith(NUGGET);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                int i = 0;
                int e = ids.size();
                while (i < e) {
                    int id;
                    if ((id = ((Integer)ids.get(i++)).intValue()) == -1 || !ComparableItemStackSmelter.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackSmelter(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackSmelter.getOreID(stack);
        }

        public ComparableItemStackSmelter set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackSmelter.getOreID(stack);
            return this;
        }

        static {
            EQUALS.add("sand");
            EQUALS.add("crystalSlag");
            EQUALS.add("crystalSlagRich");
            EQUALS.add("crystalCinnabar");
            EQUALS.add("itemSlag");
            EQUALS.add("itemSlagRich");
            EQUALS.add("itemCinnabar");
        }
    }

    public static class RecipeSmelter {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSmelter(ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
            if (primaryInput.field_77994_a <= 0) {
                primaryInput.field_77994_a = 1;
            }
            if (secondaryInput.field_77994_a <= 0) {
                secondaryInput.field_77994_a = 1;
            }
            if (primaryOutput.field_77994_a <= 0) {
                primaryOutput.field_77994_a = 1;
            }
            if (secondaryOutput != null && secondaryOutput.field_77994_a <= 0) {
                secondaryOutput.field_77994_a = 1;
            }
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

