/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class ArcFurnaceRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack input;
    public final String oreInputString;
    public final IngredientStack[] additives;
    public final ItemStack output;
    public final ItemStack slag;
    public String specialRecipeType;
    public static ArrayList<String> specialRecipeTypes = new ArrayList();
    public static ArrayList<ArcFurnaceRecipe> recipeList = new ArrayList();
    public static ArrayList recyclingAllowed = new ArrayList();
    public static ArrayList invalidRecyclingOutput = new ArrayList();

    public ArcFurnaceRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        this.output = output;
        this.input = ApiUtils.createIngredientStack(input);
        this.oreInputString = input instanceof String ? (String)input : null;
        this.slag = slag;
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.totalProcessEnergy = (int)Math.floor((float)energyPerTick * energyModifier) * this.totalProcessTime;
        if (additives == null) {
            this.additives = new IngredientStack[0];
        } else {
            this.additives = new IngredientStack[additives.length];
            for (int i = 0; i < additives.length; ++i) {
                this.additives[i] = ApiUtils.createIngredientStack(additives[i]);
            }
        }
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        if (this.additives.length > 0) {
            this.inputList.addAll(Lists.newArrayList((Object[])this.additives));
        }
        this.outputList = Lists.newArrayList((Object[])new ItemStack[]{this.output});
    }

    @Override
    public void setupJEI() {
        super.setupJEI();
        this.jeiTotalItemOutputList.add(this.slag);
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        if (this.additives.length > 0) {
            NBTTagList list = new NBTTagList();
            for (IngredientStack add : this.additives) {
                list.func_74742_a((NBTBase)add.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("additives", (NBTBase)list);
        }
        return nbt;
    }

    public static ArcFurnaceRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT(nbt.func_74775_l("input"));
        IngredientStack[] additives = null;
        if (nbt.func_74764_b("additives")) {
            NBTTagList list = nbt.func_150295_c("additives", 10);
            additives = new IngredientStack[list.func_74745_c()];
            for (int i = 0; i < additives.length; ++i) {
                additives[i] = IngredientStack.readFromNBT(list.func_150305_b(i));
            }
        }
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (!recipe.input.equals(input)) continue;
            if (additives == null && recipe.additives.length < 1) {
                return recipe;
            }
            if (additives == null || recipe.additives.length != additives.length) continue;
            boolean b = true;
            for (int i = 0; i < additives.length; ++i) {
                if (additives[i].equals(recipe.additives[i])) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return recipe;
        }
        return null;
    }

    public List<ItemStack> getOutputs(ItemStack input, ItemStack[] additives) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.output});
    }

    public boolean matches(ItemStack input, ItemStack[] additives) {
        if (this.input != null && this.input.matches(input)) {
            ArrayList<ItemStack> qAdd = new ArrayList<ItemStack>(additives.length);
            for (ItemStack itemStack : additives) {
                qAdd.add(itemStack);
            }
            for (IngredientStack ingredientStack : this.additives) {
                if (ingredientStack == null) continue;
                int addAmount = ingredientStack.inputSize;
                Iterator it = qAdd.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query == null) continue;
                    if (ingredientStack.matches(query)) {
                        if (query.field_77994_a > addAmount) {
                            query.field_77994_a -= addAmount;
                            addAmount = 0;
                        } else {
                            addAmount -= query.field_77994_a;
                            query.field_77994_a = 0;
                        }
                    }
                    if (query.field_77994_a <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.matches(stack);
    }

    public boolean isValidAdditive(ItemStack stack) {
        for (IngredientStack add : this.additives) {
            if (add == null || !add.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public ArcFurnaceRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static ArcFurnaceRecipe addRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(output, input, slag, time, energyPerTick, additives);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
        return recipe;
    }

    public static ArcFurnaceRecipe findRecipe(ItemStack input, ItemStack[] additives) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.matches(input, additives)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ArcFurnaceRecipe> removeRecipes(ItemStack stack) {
        ArrayList<ArcFurnaceRecipe> list = new ArrayList<ArcFurnaceRecipe>();
        Iterator<ArcFurnaceRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            ArcFurnaceRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeAdditive(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidAdditive(stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowItemForRecycling(Object stack) {
        recyclingAllowed.add(ApiUtils.convertToValidRecipeInput(stack));
    }

    public static void makeItemInvalidRecyclingOutput(Object stack) {
        invalidRecyclingOutput.add(ApiUtils.convertToValidRecipeInput(stack));
    }
}

