/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class ShaderCase {
    protected ShaderLayer[] layers;

    protected ShaderCase(ShaderLayer ... layers) {
        this.layers = layers;
    }

    protected ShaderCase(Collection<ShaderLayer> layers) {
        this.layers = layers.toArray(new ShaderLayer[layers.size()]);
    }

    public ShaderLayer[] getLayers() {
        return this.layers;
    }

    public ShaderCase addLayers(ShaderLayer ... addedLayers) {
        ShaderLayer[] newLayers = new ShaderLayer[this.layers.length + addedLayers.length];
        int insert = this.getLayerInsertionIndex();
        System.arraycopy(this.layers, 0, newLayers, 0, insert);
        System.arraycopy(addedLayers, 0, newLayers, insert, addedLayers.length);
        System.arraycopy(this.layers, insert, newLayers, insert + addedLayers.length, this.layers.length - insert);
        this.layers = newLayers;
        return this;
    }

    public abstract int getLayerInsertionIndex();

    public abstract boolean renderModelPartForPass(ItemStack var1, ItemStack var2, String var3, int var4);

    public abstract String getShaderType();

    public boolean stitchIntoSheet() {
        return true;
    }

    public ResourceLocation getReplacementSprite(ItemStack shader, ItemStack item, String modelPart, int pass) {
        return this.getLayers()[pass].getTexture();
    }

    public int getARGBColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        return this.getLayers()[pass].getColour();
    }

    public abstract void modifyRender(ItemStack var1, ItemStack var2, String var3, int var4, boolean var5, boolean var6);

    public static class ShaderLayer {
        private final ResourceLocation texture;
        private final int colour;
        private double[] textureBounds;
        private double[] cutoutBounds;

        public ShaderLayer(ResourceLocation texture, int colour) {
            this.texture = texture;
            this.colour = colour;
        }

        public ShaderLayer setTextureBounds(double ... bounds) {
            if (bounds == null) {
                return this;
            }
            assert (bounds.length == 4);
            this.textureBounds = bounds;
            return this;
        }

        public double[] getTextureBounds() {
            return this.textureBounds;
        }

        public ShaderLayer setCutoutBounds(double ... bounds) {
            if (bounds == null) {
                return this;
            }
            assert (bounds.length == 4);
            this.cutoutBounds = bounds;
            return this;
        }

        public double[] getCutoutBounds() {
            return this.cutoutBounds;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public int getColour() {
            return this.colour;
        }
    }
}

