/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.base.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityBelljar
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHasDummyBlocks,
IIEInventory,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IGuiTile,
IOBJModelCallback<IBlockState> {
    public EnumFacing facing = EnumFacing.NORTH;
    public int dummy = 0;
    private ItemStack[] inventory = new ItemStack[7];
    public FluidTank tank = new FluidTank(4000){

        protected void onContentsChanged() {
            TileEntityBelljar.this.sendSyncPacket(2);
        }
    };
    public FluxStorage energyStorage = new FluxStorage(16000, Math.max(256, Config.IEConfig.Machines.belljar_consumption));
    private BelljarHandler.IPlantHandler curPlantHandler;
    public int fertilizerAmount = 0;
    public float fertilizerMod = 1.0f;
    private float growth = 0.0f;
    public float renderGrowth = 0.0f;
    public boolean renderActive = false;
    IItemHandler inputHandler = new IEInventoryHandler(1, (IIEInventory)this, 2, true, false);
    IItemHandler outputHandler = new IEInventoryHandler(4, (IIEInventory)this, 3, false, true);
    EnergyHelper.IEForgeEnergyWrapper energyWrapper = new EnergyHelper.IEForgeEnergyWrapper(this, EnumFacing.UP);
    AxisAlignedBB renderBB;

    public void func_73660_a() {
        block32: {
            BlockPos outputPos;
            TileEntity outputTile;
            block31: {
                BelljarHandler.IPlantHandler handler;
                if (this.dummy != 0) {
                    return;
                }
                if (this.field_145850_b.field_72995_K && !this.renderActive) {
                    return;
                }
                if (this.field_145850_b.func_175687_A(this.func_174877_v()) != 0) {
                    if (this.renderActive) {
                        this.renderActive = false;
                        this.sendSyncPacket(0);
                    }
                    return;
                }
                if (!this.func_145831_w().field_72995_K) break block31;
                if (this.energyStorage.getEnergyStored() <= Config.IEConfig.Machines.belljar_consumption || this.fertilizerAmount <= 0 || !this.renderActive || (handler = this.getCurrentPlantHandler()) == null || !handler.isCorrectSoil(this.inventory[1], this.inventory[0]) || this.fertilizerAmount <= 0) break block32;
                if (this.renderGrowth < 1.0f) {
                    this.renderGrowth += handler.getGrowthStep(this.inventory[1], this.inventory[0], this.renderGrowth, this, this.fertilizerMod, true);
                    --this.fertilizerAmount;
                } else {
                    this.renderGrowth = handler.resetGrowth(this.inventory[1], this.inventory[0], this.renderGrowth, this, true);
                }
                if (this.func_145831_w().field_73012_v.nextInt(8) != 0) break block32;
                double partX = (double)this.func_174877_v().func_177958_n() + 0.5;
                double partY = (double)this.func_174877_v().func_177956_o() + 2.6875;
                double partZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                ImmersiveEngineering.proxy.spawnRedstoneFX(this.func_145831_w(), partX, partY, partZ, 0.25, 0.25, 0.25, 1.0f, 0.55f, 0.1f, 0.1f);
                break block32;
            }
            if (this.inventory[1] != null) {
                BelljarHandler.FluidFertilizerHandler fluidFert;
                BelljarHandler.IPlantHandler handler = this.getCurrentPlantHandler();
                if (handler != null && handler.isCorrectSoil(this.inventory[1], this.inventory[0]) && this.fertilizerAmount > 0 && this.energyStorage.extractEnergy(Config.IEConfig.Machines.belljar_consumption, true) == Config.IEConfig.Machines.belljar_consumption) {
                    boolean consume = false;
                    if (this.growth >= 1.0f) {
                        ItemStack[] outputs = handler.getOutput(this.inventory[1], this.inventory[0], this);
                        int canFit = 0;
                        for (int i = 0; i < outputs.length; ++i) {
                            if (outputs[i] == null) continue;
                            for (int j = 3; j < 7; ++j) {
                                if (this.inventory[j] != null && (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.inventory[j], (ItemStack)outputs[i]) || this.inventory[j].field_77994_a + outputs[i].field_77994_a > this.inventory[j].func_77976_d())) continue;
                                ++canFit;
                            }
                        }
                        if (canFit >= outputs.length) {
                            block2: for (ItemStack output : outputs) {
                                for (int j = 3; j < 7; ++j) {
                                    if (this.inventory[j] == null) {
                                        this.inventory[j] = output.func_77946_l();
                                        continue block2;
                                    }
                                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.inventory[j], (ItemStack)output) || this.inventory[j].field_77994_a + output.field_77994_a > this.inventory[j].func_77976_d()) continue;
                                    this.inventory[j].field_77994_a += output.field_77994_a;
                                    continue block2;
                                }
                            }
                            this.growth = handler.resetGrowth(this.inventory[1], this.inventory[0], this.growth, this, false);
                            consume = true;
                        }
                    } else if (this.growth < 1.0f) {
                        this.growth += handler.getGrowthStep(this.inventory[1], this.inventory[0], this.growth, this, this.fertilizerMod, false);
                        consume = true;
                        if (this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F)) {
                            this.sendSyncPacket(0);
                        }
                    }
                    if (consume) {
                        this.energyStorage.extractEnergy(Config.IEConfig.Machines.belljar_consumption, false);
                        --this.fertilizerAmount;
                        if (!this.renderActive) {
                            this.renderActive = true;
                            this.sendSyncPacket(0);
                        }
                    } else if (this.renderActive) {
                        this.renderActive = false;
                        this.sendSyncPacket(0);
                    }
                } else {
                    this.growth = 0.0f;
                }
                if (this.fertilizerAmount <= 0 && this.tank.getFluidAmount() >= Config.IEConfig.Machines.belljar_fluid && (fluidFert = BelljarHandler.getFluidFertilizerHandler(this.tank.getFluid())) != null) {
                    this.fertilizerMod = fluidFert.getGrowthMultiplier(this.tank.getFluid(), this.inventory[1], this.inventory[0], this);
                    this.tank.drain(Config.IEConfig.Machines.belljar_fluid, true);
                    if (this.inventory[2] != null) {
                        BelljarHandler.ItemFertilizerHandler itemFert = BelljarHandler.getItemFertilizerHandler(this.inventory[2]);
                        if (itemFert != null) {
                            this.fertilizerMod *= itemFert.getGrowthMultiplier(this.inventory[2], this.inventory[1], this.inventory[0], this);
                        }
                        --this.inventory[2].field_77994_a;
                        if (this.inventory[2].field_77994_a <= 0) {
                            this.inventory[2] = null;
                        }
                    }
                    this.fertilizerAmount = Config.IEConfig.Machines.belljar_fertilizer;
                    this.sendSyncPacket(1);
                }
            } else {
                this.growth = 0.0f;
            }
            if (this.field_145850_b.func_82737_E() % 8L == 0L && (outputTile = this.field_145850_b.func_175625_s(outputPos = this.func_174877_v().func_177984_a().func_177972_a(this.facing.func_176734_d()))) != null) {
                for (int j = 3; j < 7; ++j) {
                    if (this.inventory[j] == null) continue;
                    int out = Math.min(this.inventory[j].field_77994_a, 16);
                    ItemStack stack = Utils.copyStackWithAmount(this.inventory[j], out);
                    if ((stack = Utils.insertStackIntoInventory(outputTile, stack, this.facing)) != null) {
                        out -= stack.field_77994_a;
                    }
                    if ((this.inventory[j].field_77994_a -= out) > 0) continue;
                    this.inventory[j] = null;
                }
            }
        }
    }

    public BelljarHandler.IPlantHandler getCurrentPlantHandler() {
        if (this.curPlantHandler == null || !this.curPlantHandler.isValid(this.inventory[1])) {
            this.curPlantHandler = BelljarHandler.getHandler(this.inventory[1]);
        }
        return this.curPlantHandler;
    }

    protected void sendSyncPacket(int type) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (type == 0) {
            nbt.func_74776_a("growth", this.growth);
            nbt.func_74768_a("energy", this.energyStorage.getEnergyStored());
            nbt.func_74757_a("renderActive", this.renderActive);
        } else if (type == 1) {
            nbt.func_74768_a("fertilizerAmount", this.fertilizerAmount);
            nbt.func_74776_a("fertilizerMod", this.fertilizerMod);
        } else if (type == 2) {
            nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync(this, nbt), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.func_74764_b("growth")) {
            this.renderGrowth = message.func_74760_g("growth");
        }
        if (message.func_74764_b("renderActive")) {
            this.renderActive = message.func_74767_n("renderActive");
        }
        if (message.func_74764_b("energy")) {
            this.energyStorage.setEnergy(message.func_74762_e("energy"));
        }
        if (message.func_74764_b("fertilizerAmount")) {
            this.fertilizerAmount = message.func_74762_e("fertilizerAmount");
        }
        if (message.func_74764_b("fertilizerMod")) {
            this.fertilizerMod = message.func_74760_g("fertilizerMod");
        }
        if (message.func_74764_b("tank")) {
            this.tank.readFromNBT(message.func_74775_l("tank"));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.dummy = nbt.func_74762_e("dummy");
        this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 7);
        this.energyStorage.readFromNBT(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.fertilizerAmount = nbt.func_74762_e("fertilizerAmount");
        this.fertilizerMod = nbt.func_74760_g("fertilizerMod");
        this.growth = nbt.func_74760_g("growth");
        this.renderBB = null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        this.energyStorage.writeToNBT(nbt);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        nbt.func_74768_a("fertilizerAmount", this.fertilizerAmount);
        nbt.func_74776_a("fertilizerMod", this.fertilizerMod);
        nbt.func_74776_a("growth", this.growth);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(pos.func_177981_b(i), state);
            ((TileEntityBelljar)this.field_145850_b.func_175625_s((BlockPos)pos.func_177981_b((int)i))).dummy = i;
            ((TileEntityBelljar)this.field_145850_b.func_175625_s((BlockPos)pos.func_177981_b((int)i))).facing = this.facing;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            BlockPos p = this.func_174877_v().func_177979_c(this.dummy).func_177981_b(i);
            if (!(this.field_145850_b.func_175625_s(p) instanceof TileEntityBelljar)) continue;
            this.field_145850_b.func_175698_g(p);
        }
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 2 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        if (slot == 0) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.dummy == 0 ? facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k() : this.dummy == 1 && (facing == null || facing == this.facing.func_176734_d());
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.dummy == 0 && (facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k());
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.dummy == 0 && (facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k())) {
                return (T)this.inputHandler;
            }
            if (this.dummy == 1 && (facing == null || facing == this.facing.func_176734_d())) {
                return (T)this.outputHandler;
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.dummy == 0 && (facing == null || facing.func_176740_k() != this.facing.func_176746_e().func_176740_k())) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 14;
    }

    @Override
    public TileEntity getGuiMaster() {
        if (this.dummy == 0) {
            return this;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177979_c(this.dummy));
        if (te instanceof TileEntityBelljar) {
            return te;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        ResourceLocation rl;
        if (this.inventory[0] != null && "farmland".equals(material) && (rl = this.getSoilTexture()) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        return !"glass".equals(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        ResourceLocation rl;
        if (this.inventory[0] != null && (rl = this.getSoilTexture()) != null) {
            return rl.toString();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private ResourceLocation getSoilTexture() {
        FluidStack fs;
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = this.curPlantHandler != null ? this.curPlantHandler.getSoilTexture(this.inventory[1], this.inventory[0], this) : null;
        if (rl == null) {
            rl = BelljarHandler.getSoilTexture(this.inventory[0]);
        }
        if (rl == null) {
            try {
                IBlockState state = Utils.getStateFromItemStack(this.inventory[0]);
                if (state != null) {
                    rl = ClientUtils.getSideTexture(state, EnumFacing.UP);
                }
            }
            catch (Exception e) {
                rl = ClientUtils.getSideTexture(this.inventory[0], EnumFacing.UP);
            }
        }
        if (rl == null && this.inventory[0] != null && Utils.isFluidRelatedItemStack(this.inventory[0]) && (fs = FluidUtil.getFluidContained((ItemStack)this.inventory[0])) != null) {
            rl = fs.getFluid().getStill(fs);
        }
        return rl;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177979_c(this.dummy))) instanceof TileEntityBelljar) {
            return ((TileEntityBelljar)te).energyStorage;
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(@Nullable EnumFacing facing) {
        return facing == null || this.dummy == 0 && facing.func_176740_k() == this.facing.func_176746_e().func_176740_k() || this.dummy == 2 && facing == EnumFacing.UP ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == null || this.dummy == 0 && facing.func_176740_k() == this.facing.func_176746_e().func_176740_k() || this.dummy == 2 && facing == EnumFacing.UP) {
            return this.energyWrapper;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).func_186670_a(this.field_174879_c);
        }
        return this.renderBB;
    }
}

