/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;

public class TileEntityCapacitorLV
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.ITileDrop {
    public IEEnums.SideConfig[] sideConfig = new IEEnums.SideConfig[]{IEEnums.SideConfig.NONE, IEEnums.SideConfig.INPUT, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE, IEEnums.SideConfig.NONE};
    FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    public int comparatorOutput = 0;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
            if (this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(int side) {
        if (this.sideConfig[side] != IEEnums.SideConfig.OUTPUT) {
            return;
        }
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        int out = Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
        this.energyStorage.modifyEnergyStored(-EnergyHelper.insertFlux(tileEntity, fd.func_176734_d(), out, false));
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return this.sideConfig[side];
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer player) {
        this.sideConfig[side] = IEEnums.SideConfig.next(this.sideConfig[side]);
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        return true;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public int getMaxStorage() {
        return Config.IEConfig.Machines.capacitorLV_storage;
    }

    public int getMaxInput() {
        return Config.IEConfig.Machines.capacitorLV_input;
    }

    public int getMaxOutput() {
        return Config.IEConfig.Machines.capacitorLV_output;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        for (int i = 0; i < 6; ++i) {
            nbt.func_74768_a("sideConfig_" + i, this.sideConfig[i].ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.func_74764_b("sideConfig")) {
            int[] old = nbt.func_74759_k("sideConfig");
            for (int i = 0; i < old.length; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[old[i] + 1];
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = IEEnums.SideConfig.values()[nbt.func_74762_e("sideConfig_" + i)];
            }
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        if (facing == null) {
            return IEEnums.SideConfig.NONE;
        }
        return this.sideConfig[facing.ordinal()];
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        return this.wrappers[facing.ordinal()];
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.IEConfig.colourblindSupport) {
            IEEnums.SideConfig i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            IEEnums.SideConfig j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + (Object)((Object)i)), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + (Object)((Object)j)), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (this.energyStorage.getEnergyStored() > 0) {
            ItemNBTHelper.setInt(stack, "energyStorage", this.energyStorage.getEnergyStored());
        }
        for (int i = 0; i < 6; ++i) {
            ItemNBTHelper.setInt(stack, "sideConfig_" + i, this.sideConfig[i].ordinal());
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            this.energyStorage.setEnergy(ItemNBTHelper.getInt(stack, "energyStorage"));
        }
        for (int i = 0; i < 6; ++i) {
            if (!ItemNBTHelper.hasKey(stack, "sideConfig_" + i)) continue;
            this.sideConfig[i] = IEEnums.SideConfig.values()[ItemNBTHelper.getInt(stack, "sideConfig_" + i)];
        }
    }
}

