/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SkylineHelper {
    public static ImmersiveNetHandler.Connection getTargetConnection(World world, BlockPos pos, EntityLivingBase living, ImmersiveNetHandler.Connection invalidCon) {
        if (!(world.func_175625_s(pos) instanceof IImmersiveConnectable)) {
            return null;
        }
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, pos);
        if (outputs != null && outputs.size() > 0) {
            Vec3d vec = living.func_70040_Z();
            vec = vec.func_72432_b();
            ImmersiveNetHandler.Connection line = null;
            for (ImmersiveNetHandler.Connection c : outputs) {
                if (c == null || c.hasSameConnectors(invalidCon)) continue;
                if (line == null) {
                    line = c;
                    continue;
                }
                Vec3d lineVec = new Vec3d((double)(line.end.func_177958_n() - line.start.func_177958_n()), (double)(line.end.func_177956_o() - line.start.func_177956_o()), (double)(line.end.func_177952_p() - line.start.func_177952_p())).func_72432_b();
                Vec3d conVec = new Vec3d((double)(c.end.func_177958_n() - c.start.func_177958_n()), (double)(c.end.func_177956_o() - c.start.func_177956_o()), (double)(c.end.func_177952_p() - c.start.func_177952_p())).func_72432_b();
                if (!(conVec.func_72438_d(vec) < lineVec.func_72438_d(vec))) continue;
                line = c;
            }
            return line;
        }
        return null;
    }

    public static EntitySkylineHook spawnHook(EntityPlayer player, TileEntity start, ImmersiveNetHandler.Connection connection) {
        BlockPos cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
        BlockPos cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
        IImmersiveConnectable iicStart = ApiUtils.toIIC(cc1, player.field_70170_p);
        IImmersiveConnectable iicEnd = ApiUtils.toIIC(cc0, player.field_70170_p);
        Vec3d vStart = new Vec3d((Vec3i)cc1);
        Vec3d vEnd = new Vec3d((Vec3i)cc0);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
        }
        Vec3d[] steps = SkylineHelper.getConnectionCatenary(connection, vStart, vEnd);
        double dx = steps[0].field_72450_a - vStart.field_72450_a;
        double dy = steps[0].field_72448_b - vStart.field_72448_b;
        double dz = steps[0].field_72449_c - vStart.field_72449_c;
        double d = 1.0;
        EntitySkylineHook hook = new EntitySkylineHook(player.field_70170_p, vStart.field_72450_a, vStart.field_72448_b, vStart.field_72449_c, connection, cc0, steps);
        float speed = 1.0f;
        if (player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() instanceof ItemSkyhook) {
            speed = ((ItemSkyhook)player.func_184607_cu().func_77973_b()).getSkylineSpeed(player.func_184607_cu());
        }
        Vec3d moveVec = SkylineHelper.getSubMovementVector(vStart, steps[0], speed);
        hook.field_70159_w = moveVec.field_72450_a;
        hook.field_70181_x = moveVec.field_72448_b;
        hook.field_70179_y = moveVec.field_72449_c;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)hook);
        }
        ItemSkyhook.existingHooks.put(player.func_70005_c_(), hook);
        player.func_184220_m((Entity)hook);
        return hook;
    }

    public static Vec3d[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3d start, Vec3d end) {
        boolean vertical;
        boolean bl = vertical = connection.end.func_177958_n() == connection.start.func_177958_n() && connection.end.func_177952_p() == connection.start.func_177952_p();
        if (vertical) {
            return new Vec3d[]{new Vec3d(end.field_72450_a, end.field_72448_b, end.field_72449_c)};
        }
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * connection.cableType.getSlack();
        double l = 0.0;
        for (int limiter = 0; !vertical && limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double p = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double q = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        int vertices = 16;
        Vec3d[] vex = new Vec3d[vertices];
        for (int i = 0; i < vertices; ++i) {
            float n1 = (float)(i + 1) / (float)vertices;
            double x1 = 0.0 + dx * (double)n1;
            double z1 = 0.0 + dz * (double)n1;
            double y1 = a * Math.cosh((Math.sqrt(x1 * x1 + z1 * z1) - p) / a) + q;
            vex[i] = new Vec3d(start.field_72450_a + x1, start.field_72448_b + y1, start.field_72449_c + z1);
        }
        return vex;
    }

    public static Vec3d getSubMovementVector(Vec3d start, Vec3d target, float speed) {
        Vec3d movementVec = new Vec3d(target.field_72450_a - start.field_72450_a, target.field_72448_b - start.field_72448_b, target.field_72449_c - start.field_72449_c);
        int lPixel = (int)Math.max(1.0, movementVec.func_72433_c() / (0.125 * (double)speed));
        return new Vec3d(movementVec.field_72450_a / (double)lPixel, movementVec.field_72448_b / (double)lPixel, movementVec.field_72449_c / (double)lPixel);
    }

    public static boolean isInBlock(EntityPlayer player, World w) {
        BlockPos init = player.func_180425_c();
        AxisAlignedBB hitbox = player.func_174813_aQ();
        hitbox = new AxisAlignedBB(hitbox.field_72340_a - 1.0, hitbox.field_72338_b - 1.0, hitbox.field_72339_c - 1.0, hitbox.field_72336_d, hitbox.field_72337_e, hitbox.field_72334_f);
        for (int xOff = 0; xOff < 2; ++xOff) {
            for (int yOff = 0; yOff < 3; ++yOff) {
                for (int zOff = 0; zOff < 2; ++zOff) {
                    Vec3d v = new Vec3d((double)(init.func_177958_n() + xOff), (double)(init.func_177956_o() + yOff), (double)(init.func_177952_p() + zOff));
                    if (!hitbox.func_72318_a(v) || w.func_175623_d(new BlockPos(v))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

