/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.permissions.ITurtlePermissionProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.core.filesystem.ComboMount;
import dan200.computercraft.core.filesystem.FileMount;
import dan200.computercraft.core.filesystem.JarMount;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.computer.blocks.BlockCommandComputer;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ClientComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.media.items.ItemDiskExpanded;
import dan200.computercraft.shared.media.items.ItemDiskLegacy;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.network.ComputerCraftPacket;
import dan200.computercraft.shared.network.PacketHandler;
import dan200.computercraft.shared.peripheral.common.BlockCable;
import dan200.computercraft.shared.peripheral.common.BlockPeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.modem.BlockAdvancedModem;
import dan200.computercraft.shared.peripheral.modem.WirelessNetwork;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.proxy.ICCTurtleProxy;
import dan200.computercraft.shared.proxy.IComputerCraftProxy;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.upgrades.TurtleAxe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleHoe;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleShovel;
import dan200.computercraft.shared.turtle.upgrades.TurtleSword;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.CreativeTabMain;
import dan200.computercraft.shared.util.IDAssigner;
import dan200.computercraft.shared.util.IEntityDropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="computercraft", name="Computality", version="1.10.2-1.82pr1-bugfix1", guiFactory="dan200.computercraft.client.gui.GuiConfig$Factory", acceptedMinecraftVersions="[1.10.2]")
public class ComputerCraft {
    public static final int diskDriveGUIID = 100;
    public static final int computerGUIID = 101;
    public static final int printerGUIID = 102;
    public static final int turtleGUIID = 103;
    public static final int printoutGUIID = 105;
    public static final int pocketComputerGUIID = 106;
    public static final int terminalWidth_computer = 51;
    public static final int terminalHeight_computer = 19;
    public static final int terminalWidth_turtle = 39;
    public static final int terminalHeight_turtle = 13;
    public static final int terminalWidth_pocketComputer = 26;
    public static final int terminalHeight_pocketComputer = 20;
    private static final Map<String, IPocketUpgrade> pocketUpgrades = new HashMap<String, IPocketUpgrade>();
    public static ClientComputerRegistry clientComputerRegistry = new ClientComputerRegistry();
    public static ServerComputerRegistry serverComputerRegistry = new ServerComputerRegistry();
    public static FMLEventChannel networkEventChannel;
    public static CreativeTabMain mainCreativeTab;
    @Mod.Instance(value="computercraft")
    public static ComputerCraft instance;
    @SidedProxy(clientSide="dan200.computercraft.client.proxy.ComputerCraftProxyClient", serverSide="dan200.computercraft.server.proxy.ComputerCraftProxyServer")
    public static IComputerCraftProxy proxy;
    @SidedProxy(clientSide="dan200.computercraft.client.proxy.CCTurtleProxyClient", serverSide="dan200.computercraft.server.proxy.CCTurtleProxyServer")
    public static ICCTurtleProxy turtleProxy;
    private static List<IPeripheralProvider> peripheralProviders;
    private static List<IBundledRedstoneProvider> bundledRedstoneProviders;
    private static List<IMediaProvider> mediaProviders;
    private static List<ITurtlePermissionProvider> permissionProviders;

    public static Iterable<IPocketUpgrade> getVanillaPocketUpgrades() {
        ArrayList<IPocketUpgrade> upgrades = new ArrayList<IPocketUpgrade>();
        for (IPocketUpgrade upgrade : pocketUpgrades.values()) {
            if (!(upgrade instanceof PocketModem)) continue;
            upgrades.add(upgrade);
        }
        return upgrades;
    }

    public static IPocketUpgrade getPocketUpgrade(String id) {
        return pocketUpgrades.get(id);
    }

    public static IPocketUpgrade getPocketUpgrade(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (IPocketUpgrade upgrade : pocketUpgrades.values()) {
            ItemStack craftingStack = upgrade.getCraftingItem();
            if (craftingStack == null || !InventoryUtil.areItemsStackable(stack, craftingStack)) continue;
            return upgrade;
        }
        return null;
    }

    public static String getVersion() {
        return "1.10.2-1.82pr1-bugfix1";
    }

    public static boolean isClient() {
        return proxy.isClient();
    }

    public static boolean getGlobalCursorBlink() {
        return proxy.getGlobalCursorBlink();
    }

    public static long getRenderFrame() {
        return proxy.getRenderFrame();
    }

    public static void deleteDisplayLists(int list, int range) {
        proxy.deleteDisplayLists(list, range);
    }

    public static Object getFixedWidthFontRenderer() {
        return proxy.getFixedWidthFontRenderer();
    }

    public static void playRecord(SoundEvent record, String recordInfo, World world, BlockPos pos) {
        proxy.playRecord(record, recordInfo, world, pos);
    }

    public static String getRecordInfo(ItemStack recordStack) {
        return proxy.getRecordInfo(recordStack);
    }

    public static void openDiskDriveGUI(EntityPlayer player, TileDiskDrive drive) {
        BlockPos pos = drive.func_174877_v();
        player.openGui((Object)instance, 100, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openComputerGUI(EntityPlayer player, TileComputer computer) {
        BlockPos pos = computer.func_174877_v();
        player.openGui((Object)instance, 101, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openPrinterGUI(EntityPlayer player, TilePrinter printer) {
        BlockPos pos = printer.func_174877_v();
        player.openGui((Object)instance, 102, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openTurtleGUI(EntityPlayer player, TileTurtle turtle) {
        BlockPos pos = turtle.func_174877_v();
        player.openGui((Object)instance, 103, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openPrintoutGUI(EntityPlayer player, EnumHand hand) {
        player.openGui((Object)instance, 105, player.func_130014_f_(), hand.ordinal(), 0, 0);
    }

    public static void openPocketComputerGUI(EntityPlayer player, EnumHand hand) {
        player.openGui((Object)instance, 106, player.func_130014_f_(), hand.ordinal(), 0, 0);
    }

    public static File getBaseDir() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f(".");
    }

    public static File getResourcePackDir() {
        return new File(ComputerCraft.getBaseDir(), "resourcepacks");
    }

    public static File getWorldDir(World world) {
        return proxy.getWorldDir(world);
    }

    private static FMLProxyPacket encode(ComputerCraftPacket packet) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        packet.toBytes(buffer);
        return new FMLProxyPacket(buffer, "CC");
    }

    public static void sendToPlayer(EntityPlayer player, ComputerCraftPacket packet) {
        networkEventChannel.sendTo(ComputerCraft.encode(packet), (EntityPlayerMP)player);
    }

    public static void sendToAllPlayers(ComputerCraftPacket packet) {
        networkEventChannel.sendToAll(ComputerCraft.encode(packet));
    }

    public static void sendToServer(ComputerCraftPacket packet) {
        networkEventChannel.sendToServer(ComputerCraft.encode(packet));
    }

    public static void handlePacket(ComputerCraftPacket packet, EntityPlayer player) {
        proxy.handlePacket(packet, player);
    }

    public static boolean canPlayerUseCommands(EntityPlayer player) {
        MinecraftServer server = player.func_184102_h();
        return server != null && server.func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        MinecraftServer server = player.func_184102_h();
        return server != null && server.func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) > 0;
    }

    public static void registerPermissionProvider(ITurtlePermissionProvider provider) {
        if (provider != null && !permissionProviders.contains(provider)) {
            permissionProviders.add(provider);
        }
    }

    public static boolean isBlockEnterable(World world, BlockPos pos, EntityPlayer player) {
        MinecraftServer server = player.func_184102_h();
        if (server != null && !world.field_72995_K && server.func_175579_a(world, pos, player)) {
            return false;
        }
        for (ITurtlePermissionProvider provider : permissionProviders) {
            if (provider.isBlockEnterable(world, pos)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockEditable(World world, BlockPos pos, EntityPlayer player) {
        MinecraftServer server = player.func_184102_h();
        if (server != null && !world.field_72995_K && server.func_175579_a(world, pos, player)) {
            return false;
        }
        for (ITurtlePermissionProvider provider : permissionProviders) {
            if (provider.isBlockEditable(world, pos)) continue;
            return false;
        }
        return true;
    }

    public static void registerPocketUpgrade(IPocketUpgrade upgrade) {
        String id = upgrade.getUpgradeID().toString();
        IPocketUpgrade existing = pocketUpgrades.get(id);
        if (existing != null) {
            throw new RuntimeException("Error registering '" + upgrade.getUnlocalisedAdjective() + " pocket computer'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " pocket computer'");
        }
        pocketUpgrades.put(id, upgrade);
    }

    public static void registerPeripheralProvider(IPeripheralProvider provider) {
        if (provider != null && !peripheralProviders.contains(provider)) {
            peripheralProviders.add(provider);
        }
    }

    public static void registerBundledRedstoneProvider(IBundledRedstoneProvider provider) {
        if (provider != null && !bundledRedstoneProviders.contains(provider)) {
            bundledRedstoneProviders.add(provider);
        }
    }

    public static void registerMediaProvider(IMediaProvider provider) {
        if (provider != null && !mediaProviders.contains(provider)) {
            mediaProviders.add(provider);
        }
    }

    public static IPeripheral getPeripheralAt(World world, BlockPos pos, EnumFacing side) {
        for (IPeripheralProvider peripheralProvider : peripheralProviders) {
            try {
                IPeripheralProvider handler = peripheralProvider;
                IPeripheral peripheral = handler.getPeripheral(world, pos, side);
                if (peripheral == null) continue;
                return peripheral;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static int getDefaultBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        if (WorldUtil.isBlockInWorld(world, pos)) {
            return DefaultBundledRedstoneProvider.getDefaultBundledRedstoneOutput(world, pos, side);
        }
        return -1;
    }

    public static int getBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        int y = pos.func_177956_o();
        if (y < 0 || y >= world.func_72800_K()) {
            return -1;
        }
        int combinedSignal = -1;
        for (IBundledRedstoneProvider bundledRedstoneProvider : bundledRedstoneProviders) {
            try {
                int signal = bundledRedstoneProvider.getBundledRedstoneOutput(world, pos, side);
                if (signal < 0) continue;
                if (combinedSignal < 0) {
                    combinedSignal = signal & 0xFFFF;
                    continue;
                }
                combinedSignal |= signal & 0xFFFF;
            }
            catch (Exception exception) {}
        }
        return combinedSignal;
    }

    public static IMedia getMedia(ItemStack stack) {
        if (stack != null) {
            for (IMediaProvider mediaProvider : mediaProviders) {
                try {
                    IMedia media = mediaProvider.getMedia(stack);
                    if (media == null) continue;
                    return media;
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
        return null;
    }

    public static int createUniqueNumberedSaveDir(World world, String parentSubPath) {
        return IDAssigner.getNextIDFromDirectory(new File(ComputerCraft.getWorldDir(world), parentSubPath));
    }

    public static IWritableMount createSaveDirMount(World world, String subPath, long capacity) {
        try {
            return new FileMount(new File(ComputerCraft.getWorldDir(world), subPath), capacity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IMount createResourceMount(@Nonnull Class modClass, @Nonnull String domain, @Nonnull String subPath) {
        String[] resourcePacks;
        File resourcePackDir;
        File modJar;
        File subResource;
        ArrayList<IMount> mounts = new ArrayList<IMount>();
        subPath = "assets/" + domain + "/" + subPath;
        File codeDir = ComputerCraft.getDebugCodeDir(modClass);
        if (codeDir != null && (subResource = new File(codeDir, subPath)).exists()) {
            FileMount resourcePackMount = new FileMount(subResource, 0L);
            mounts.add(resourcePackMount);
        }
        if ((modJar = ComputerCraft.getContainingJar(modClass)) != null) {
            try {
                JarMount jarMount = new JarMount(modJar, subPath);
                mounts.add(jarMount);
            }
            catch (IOException jarMount) {
                // empty catch block
            }
        }
        if ((resourcePackDir = ComputerCraft.getResourcePackDir()).exists() && resourcePackDir.isDirectory() && (resourcePacks = resourcePackDir.list()) != null) {
            for (String resourcePack1 : resourcePacks) {
                try {
                    File resourcePack = new File(resourcePackDir, resourcePack1);
                    if (!resourcePack.isDirectory()) {
                        JarMount resourcePackMount = new JarMount(resourcePack, subPath);
                        mounts.add(resourcePackMount);
                        continue;
                    }
                    File subResource2 = new File(resourcePack, subPath);
                    if (!subResource2.exists()) continue;
                    FileMount resourcePackMount = new FileMount(subResource2, 0L);
                    mounts.add(resourcePackMount);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (mounts.size() >= 2) {
            IMount[] mountArray = new IMount[mounts.size()];
            mounts.toArray(mountArray);
            return new ComboMount(mountArray);
        }
        if (mounts.size() == 1) {
            return (IMount)mounts.get(0);
        }
        return null;
    }

    private static File getContainingJar(Class modClass) {
        File file;
        URL url;
        String path = modClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        int bangIndex = path.indexOf("!");
        if (bangIndex >= 0) {
            path = path.substring(0, bangIndex);
        }
        try {
            url = new URL(path);
        }
        catch (MalformedURLException e1) {
            return null;
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getPath());
        }
        return file;
    }

    private static File getDebugCodeDir(Class modClass) {
        String path = modClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        int bangIndex = path.indexOf("!");
        if (bangIndex >= 0) {
            return null;
        }
        return new File(new File(path).getParentFile(), "../..");
    }

    public static void registerTurtleUpgrade(ITurtleUpgrade upgrade) {
        turtleProxy.registerTurtleUpgrade(upgrade);
    }

    public static ITurtleUpgrade getTurtleUpgrade(String id) {
        return turtleProxy.getTurtleUpgrade(id);
    }

    public static ITurtleUpgrade getTurtleUpgrade(int legacyID) {
        return turtleProxy.getTurtleUpgrade(legacyID);
    }

    public static ITurtleUpgrade getTurtleUpgrade(ItemStack item) {
        return turtleProxy.getTurtleUpgrade(item);
    }

    public static void addAllUpgradedTurtles(List<ItemStack> list) {
        turtleProxy.addAllUpgradedTurtles(list);
    }

    public static void setEntityDropConsumer(Entity entity, IEntityDropConsumer consumer) {
        turtleProxy.setEntityDropConsumer(entity, consumer);
    }

    public static void clearEntityDropConsumer(Entity entity) {
        turtleProxy.clearEntityDropConsumer(entity);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.config = new Configuration(event.getSuggestedConfigurationFile());
        Config.config.load();
        Property prop = Config.config.get("general", "http_enable", Config.http_enable);
        prop.setComment("Enable the \"http\" API on Computers (see \"http_whitelist\" for more fine grained control than this)");
        Config.http_enable = prop.getBoolean(Config.http_enable);
        prop = Config.config.get("general", "http_whitelist", Config.http_whitelist);
        prop.setComment("A semicolon limited list of wildcards for domains that can be accessed through the \"http\" API on Computers. Set this to \"*\" to access to the entire internet. Example: \"*.pastebin.com;*.github.com;*.computercraft.info\" will restrict access to just those 3 domains.");
        Config.http_whitelist = prop.getString();
        prop = Config.config.get("general", "disable_lua51_features", Config.disable_lua51_features);
        prop.setComment("Set this to true to disable Lua 5.1 functions that will be removed in a future update. Useful for ensuring forward compatibility of your programs now.");
        Config.disable_lua51_features = prop.getBoolean(Config.disable_lua51_features);
        prop = Config.config.get("general", "default_computer_settings", Config.default_computer_settings);
        prop.setComment("A comma separated list of default system settings to set on new computers. Example: \"shell.autocomplete=false,lua.autocomplete=false,edit.autocomplete=false\" will disable all autocompletion");
        Config.default_computer_settings = prop.getString();
        prop = Config.config.get("general", "enableCommandBlock", Config.enableCommandBlock);
        prop.setComment("Enable Command Block peripheral support");
        Config.enableCommandBlock = prop.getBoolean(Config.enableCommandBlock);
        prop = Config.config.get("general", "modem_range", Config.modem_range);
        prop.setComment("The range of Wireless Modems at low altitude in clear weather, in meters");
        Config.modem_range = Math.min(prop.getInt(), 100000);
        prop = Config.config.get("general", "modem_highAltitudeRange", Config.modem_highAltitudeRange);
        prop.setComment("The range of Wireless Modems at maximum altitude in clear weather, in meters");
        Config.modem_highAltitudeRange = Math.min(prop.getInt(), 100000);
        prop = Config.config.get("general", "modem_rangeDuringStorm", Config.modem_rangeDuringStorm);
        prop.setComment("The range of Wireless Modems at low altitude in stormy weather, in meters");
        Config.modem_rangeDuringStorm = Math.min(prop.getInt(), 100000);
        prop = Config.config.get("general", "modem_highAltitudeRangeDuringStorm", Config.modem_highAltitudeRangeDuringStorm);
        prop.setComment("The range of Wireless Modems at maximum altitude in stormy weather, in meters");
        Config.modem_highAltitudeRangeDuringStorm = Math.min(prop.getInt(), 100000);
        prop = Config.config.get("general", "monitorFullbright", Config.monitorFullbright);
        prop.setComment("Make monitors ignore light level and render at full brightness at all times");
        Config.monitorFullbright = prop.getBoolean();
        prop = Config.config.get("general", "computerSpaceLimit", Config.computerSpaceLimit);
        prop.setComment("The disk space limit for computers and turtles, in bytes");
        Config.computerSpaceLimit = prop.getInt();
        prop = Config.config.get("general", "floppySpaceLimit", Config.floppySpaceLimit);
        prop.setComment("The disk space limit for floppy disks, in bytes");
        Config.floppySpaceLimit = prop.getInt();
        prop = Config.config.get("general", "maximumFilesOpen", Config.maximumFilesOpen);
        prop.setComment("How many files a computer can have open at the same time");
        Config.maximumFilesOpen = prop.getInt();
        prop = Config.config.get("general", "turtlesNeedFuel", Config.turtlesNeedFuel);
        prop.setComment("Set whether Turtles require fuel to move");
        Config.turtlesNeedFuel = prop.getBoolean(Config.turtlesNeedFuel);
        prop = Config.config.get("general", "turtleFuelLimit", Config.turtleFuelLimit);
        prop.setComment("The fuel limit for Turtles");
        Config.turtleFuelLimit = prop.getInt(Config.turtleFuelLimit);
        prop = Config.config.get("general", "advancedTurtleFuelLimit", Config.advancedTurtleFuelLimit);
        prop.setComment("The fuel limit for Advanced Turtles");
        Config.advancedTurtleFuelLimit = prop.getInt(Config.advancedTurtleFuelLimit);
        prop = Config.config.get("general", "turtlesObeyBlockProtection", Config.turtlesObeyBlockProtection);
        prop.setComment("If set to true, Turtles will be unable to build, dig, or enter protected areas (such as near the server spawn point)");
        Config.turtlesObeyBlockProtection = prop.getBoolean(Config.turtlesObeyBlockProtection);
        prop = Config.config.get("general", "turtlesCanPush", Config.turtlesCanPush);
        prop.setComment("If set to true, Turtles will push entities out of the way instead of stopping if there is space to do so");
        Config.turtlesCanPush = prop.getBoolean(Config.turtlesCanPush);
        Config.config.save();
        networkEventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CC");
        networkEventChannel.register((Object)new PacketHandler());
        proxy.preInit();
        turtleProxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        turtleProxy.init();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            serverComputerRegistry.reset();
            WirelessNetwork.resetNetworks();
        }
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            serverComputerRegistry.reset();
            WirelessNetwork.resetNetworks();
        }
    }

    static {
        peripheralProviders = new ArrayList<IPeripheralProvider>();
        bundledRedstoneProviders = new ArrayList<IBundledRedstoneProvider>();
        mediaProviders = new ArrayList<IMediaProvider>();
        permissionProviders = new ArrayList<ITurtlePermissionProvider>();
    }

    public static class Upgrades {
        public static TurtleModem wirelessModem;
        public static TurtleCraftingTable craftingTable;
        public static TurtleSword diamondSword;
        public static TurtleShovel diamondShovel;
        public static TurtleTool diamondPickaxe;
        public static TurtleAxe diamondAxe;
        public static TurtleHoe diamondHoe;
        public static TurtleModem advancedModem;
    }

    public static class Items {
        public static ItemDiskLegacy disk;
        public static ItemDiskExpanded diskExpanded;
        public static ItemPrintout printout;
        public static ItemTreasureDisk treasureDisk;
        public static ItemPocketComputer pocketComputer;
    }

    public static class Blocks {
        public static BlockComputer computer;
        public static BlockPeripheral peripheral;
        public static BlockCable cable;
        public static BlockTurtle turtle;
        public static BlockTurtle turtleExpanded;
        public static BlockTurtle turtleAdvanced;
        public static BlockCommandComputer commandComputer;
        public static BlockAdvancedModem advancedModem;
    }

    public static class PocketUpgrades {
        public static PocketModem wirelessModem;
        public static PocketModem advancedModem;
    }

    public static class Config {
        public static boolean http_enable = true;
        public static String http_whitelist = "*";
        public static boolean disable_lua51_features = false;
        public static String default_computer_settings = "";
        public static boolean enableCommandBlock = false;
        public static boolean turtlesNeedFuel = true;
        public static int turtleFuelLimit = 20000;
        public static int advancedTurtleFuelLimit = 100000;
        public static boolean turtlesObeyBlockProtection = true;
        public static boolean turtlesCanPush = true;
        public static int modem_range = 64;
        public static int modem_highAltitudeRange = 384;
        public static int modem_rangeDuringStorm = 64;
        public static int modem_highAltitudeRangeDuringStorm = 384;
        public static int computerSpaceLimit = 1000000;
        public static int floppySpaceLimit = 125000;
        public static int maximumFilesOpen = 128;
        public static boolean monitorFullbright = true;
        public static Configuration config;
    }
}

