/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.client.gui.GuiDiskDrive;
import dan200.computercraft.client.gui.GuiPocketComputer;
import dan200.computercraft.client.gui.GuiPrinter;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.client.gui.GuiTurtle;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.media.inventory.ContainerHeldItem;
import dan200.computercraft.shared.media.items.ItemDiskLegacy;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.network.ComputerCraftPacket;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.proxy.ComputerCraftProxyCommon;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.entity.TurtleVisionCamera;
import dan200.computercraft.shared.util.Colour;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ComputerCraftProxyClient
extends ComputerCraftProxyCommon {
    private long m_tick;
    private long m_renderFrame;
    private FixedWidthFontRenderer m_fixedWidthFontRenderer;

    @Override
    public void init() {
        super.init();
        this.m_tick = 0L;
        this.m_renderFrame = 0L;
        Minecraft mc = Minecraft.func_71410_x();
        this.m_fixedWidthFontRenderer = new FixedWidthFontRenderer(mc.func_110434_K());
        this.registerItemModel((Block)ComputerCraft.Blocks.computer, new ItemMeshDefinition(){
            private ModelResourceLocation computer = new ModelResourceLocation("computercraft:computer", "inventory");
            private ModelResourceLocation advanced_computer = new ModelResourceLocation("computercraft:advanced_computer", "inventory");

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                ItemComputer itemComputer = (ItemComputer)stack.func_77973_b();
                ComputerFamily family = itemComputer.getFamily(stack.func_77952_i());
                return family == ComputerFamily.Advanced ? this.advanced_computer : this.computer;
            }
        }, new String[]{"computer", "advanced_computer"});
        this.registerItemModel((Block)ComputerCraft.Blocks.peripheral, 0, "peripheral");
        this.registerItemModel((Block)ComputerCraft.Blocks.peripheral, 1, "wireless_modem");
        this.registerItemModel((Block)ComputerCraft.Blocks.peripheral, 2, "monitor");
        this.registerItemModel((Block)ComputerCraft.Blocks.peripheral, 3, "printer");
        this.registerItemModel((Block)ComputerCraft.Blocks.peripheral, 4, "advanced_monitor");
        this.registerItemModel((Block)ComputerCraft.Blocks.cable, 0, "cable");
        this.registerItemModel((Block)ComputerCraft.Blocks.cable, 1, "wired_modem");
        this.registerItemModel(ComputerCraft.Blocks.commandComputer, "command_computer");
        this.registerItemModel(ComputerCraft.Blocks.advancedModem, "advanced_modem");
        this.registerItemModel(ComputerCraft.Items.disk, "disk");
        this.registerItemModel(ComputerCraft.Items.diskExpanded, "disk_expanded");
        this.registerItemModel(ComputerCraft.Items.treasureDisk, "disk_treasure");
        this.registerItemModel((Item)ComputerCraft.Items.printout, 0, "printout");
        this.registerItemModel((Item)ComputerCraft.Items.printout, 1, "pages");
        this.registerItemModel((Item)ComputerCraft.Items.printout, 2, "book");
        this.registerItemModel((Item)ComputerCraft.Items.pocketComputer, new ItemMeshDefinition(){
            private ModelResourceLocation pocket_computer_off = new ModelResourceLocation("computercraft:pocket_computer", "inventory");
            private ModelResourceLocation pocket_computer_on = new ModelResourceLocation("computercraft:pocket_computer_on", "inventory");
            private ModelResourceLocation pocket_computer_blinking = new ModelResourceLocation("computercraft:pocket_computer_blinking", "inventory");
            private ModelResourceLocation pocket_computer_on_modem_on = new ModelResourceLocation("computercraft:pocket_computer_on_modem_on", "inventory");
            private ModelResourceLocation pocket_computer_blinking_modem_on = new ModelResourceLocation("computercraft:pocket_computer_blinking_modem_on", "inventory");
            private ModelResourceLocation advanced_pocket_computer_off = new ModelResourceLocation("computercraft:advanced_pocket_computer_off", "inventory");
            private ModelResourceLocation advanced_pocket_computer_on = new ModelResourceLocation("computercraft:advanced_pocket_computer_on", "inventory");
            private ModelResourceLocation advanced_pocket_computer_blinking = new ModelResourceLocation("computercraft:advanced_pocket_computer_blinking", "inventory");
            private ModelResourceLocation advanced_pocket_computer_on_modem_on = new ModelResourceLocation("computercraft:advanced_pocket_computer_on_modem_on", "inventory");
            private ModelResourceLocation advanced_pocket_computer_blinking_modem_on = new ModelResourceLocation("computercraft:advanced_pocket_computer_blinking_modem_on", "inventory");

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                ItemPocketComputer itemPocketComputer = (ItemPocketComputer)stack.func_77973_b();
                switch (itemPocketComputer.getFamily(stack)) {
                    case Advanced: {
                        switch (itemPocketComputer.getState(stack)) {
                            default: {
                                return this.advanced_pocket_computer_off;
                            }
                            case On: {
                                return this.advanced_pocket_computer_on;
                            }
                            case Blinking: 
                        }
                        return this.advanced_pocket_computer_blinking;
                    }
                }
                switch (itemPocketComputer.getState(stack)) {
                    default: {
                        return this.pocket_computer_off;
                    }
                    case On: {
                        return this.pocket_computer_on;
                    }
                    case Blinking: 
                }
                return this.pocket_computer_blinking;
            }
        }, new String[]{"pocket_computer", "pocket_computer_on", "pocket_computer_blinking", "advanced_pocket_computer_off", "advanced_pocket_computer_on", "advanced_pocket_computer_blinking"});
        mc.getItemColors().func_186730_a((IItemColor)new DiskColorHandler(ComputerCraft.Items.disk), new Item[]{ComputerCraft.Items.disk});
        mc.getItemColors().func_186730_a((IItemColor)new DiskColorHandler(ComputerCraft.Items.diskExpanded), new Item[]{ComputerCraft.Items.diskExpanded});
        mc.getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex != 1) {
                return 0xFFFFFF;
            }
            return Colour.fromInt(ItemPocketComputer.getLightState(stack)).getHex();
        }, new Item[]{ComputerCraft.Items.pocketComputer});
        ClientRegistry.bindTileEntitySpecialRenderer(TileMonitor.class, (TileEntitySpecialRenderer)new TileEntityMonitorRenderer());
        this.registerForgeHandlers();
    }

    private void registerItemModel(Block block, int damage, String name) {
        this.registerItemModel(Item.func_150898_a((Block)block), damage, name);
    }

    private void registerItemModel(Item item, int damage, String name) {
        ModelResourceLocation res = new ModelResourceLocation("computercraft:" + name, "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("computercraft", name)});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, damage, res);
    }

    private void registerItemModel(Block block, String name) {
        this.registerItemModel(Item.func_150898_a((Block)block), name);
    }

    private void registerItemModel(Item item, String name) {
        final ModelResourceLocation res = new ModelResourceLocation("computercraft:" + name, "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("computercraft", name)});
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return res;
            }
        });
    }

    private void registerItemModel(Block block, ItemMeshDefinition definition, String[] names) {
        this.registerItemModel(Item.func_150898_a((Block)block), definition, names);
    }

    private void registerItemModel(Item item, ItemMeshDefinition definition, String[] names) {
        ResourceLocation[] resources = new ResourceLocation[names.length];
        for (int i = 0; i < resources.length; ++i) {
            resources[i] = new ResourceLocation("computercraft", names[i]);
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resources);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, definition);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean getGlobalCursorBlink() {
        return this.m_tick / 8L % 2L == 0L;
    }

    @Override
    public long getRenderFrame() {
        return this.m_renderFrame;
    }

    @Override
    public void deleteDisplayLists(int list, int range) {
        GL11.glDeleteLists((int)list, (int)range);
    }

    @Override
    public Object getFixedWidthFontRenderer() {
        return this.m_fixedWidthFontRenderer;
    }

    @Override
    public String getRecordInfo(ItemStack recordStack) {
        ArrayList info = new ArrayList(1);
        recordStack.func_77973_b().func_77624_a(recordStack, null, info, false);
        if (info.size() > 0) {
            return info.get(0).toString();
        }
        return super.getRecordInfo(recordStack);
    }

    @Override
    public void playRecord(SoundEvent record, String recordInfo, World world, BlockPos pos) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        world.func_184149_a(pos, record);
        if (record != null) {
            mc.field_71456_v.func_73833_a(recordInfo);
        }
    }

    @Override
    public Object getDiskDriveGUI(InventoryPlayer inventory, TileDiskDrive drive) {
        return new GuiDiskDrive(inventory, drive);
    }

    @Override
    public Object getComputerGUI(TileComputer computer) {
        return new GuiComputer(computer);
    }

    @Override
    public Object getPrinterGUI(InventoryPlayer inventory, TilePrinter printer) {
        return new GuiPrinter(inventory, printer);
    }

    @Override
    public Object getTurtleGUI(InventoryPlayer inventory, TileTurtle turtle) {
        return new GuiTurtle(turtle.func_145831_w(), inventory, turtle);
    }

    @Override
    public Object getPrintoutGUI(EntityPlayer player, EnumHand hand) {
        ContainerHeldItem container = new ContainerHeldItem(player, hand);
        if (container.getStack() != null && container.getStack().func_77973_b() instanceof ItemPrintout) {
            return new GuiPrintout(container);
        }
        return null;
    }

    @Override
    public Object getPocketComputerGUI(EntityPlayer player, EnumHand hand) {
        ContainerHeldItem container = new ContainerHeldItem(player, hand);
        if (container.getStack() != null && container.getStack().func_77973_b() instanceof ItemPocketComputer) {
            return new GuiPocketComputer(container);
        }
        return null;
    }

    @Override
    public File getWorldDir(World world) {
        return world.func_72860_G().func_75765_b();
    }

    @Override
    public void handlePacket(final ComputerCraftPacket packet, final EntityPlayer player) {
        switch (packet.m_packetType) {
            case 7: 
            case 8: {
                Minecraft listener = Minecraft.func_71410_x();
                if (listener == null) break;
                if (listener.func_152345_ab()) {
                    this.processPacket(packet, player);
                    break;
                }
                listener.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ComputerCraftProxyClient.this.processPacket(packet, player);
                    }
                });
                break;
            }
            default: {
                super.handlePacket(packet, player);
            }
        }
    }

    private void processPacket(ComputerCraftPacket packet, EntityPlayer player) {
        switch (packet.m_packetType) {
            case 7: {
                int instanceID = packet.m_dataInt[0];
                if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                    ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
                }
                ((ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID)).handlePacket(packet, player);
                break;
            }
            case 8: {
                int instanceID = packet.m_dataInt[0];
                if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) break;
                ComputerCraft.clientComputerRegistry.remove(instanceID);
                break;
            }
        }
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        FMLCommonHandler.instance().bus().register((Object)handlers);
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    public class ForgeHandlers {
        @SubscribeEvent
        public void onRenderHand(RenderHandEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.func_175606_aa() instanceof TurtleVisionCamera) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onRenderPlayer(RenderPlayerEvent.Pre event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!event.getEntityPlayer().func_175144_cb() || mc.func_175606_aa() instanceof TurtleVisionCamera) {
                // empty if block
            }
        }

        @SubscribeEvent
        public void onRenderPlayer(RenderPlayerEvent.Post event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!event.getEntityPlayer().func_175144_cb() || mc.func_175606_aa() instanceof TurtleVisionCamera) {
                // empty if block
            }
        }

        @SubscribeEvent
        public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.func_175606_aa() instanceof TurtleVisionCamera) {
                switch (event.getType()) {
                    case HELMET: 
                    case PORTAL: 
                    case BOSSHEALTH: 
                    case ARMOR: 
                    case HEALTH: 
                    case FOOD: 
                    case AIR: 
                    case HOTBAR: 
                    case EXPERIENCE: 
                    case HEALTHMOUNT: 
                    case JUMPBAR: {
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                ComputerCraftProxyClient.this.m_tick++;
            }
        }

        @SubscribeEvent
        public void onRenderTick(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                ComputerCraftProxyClient.this.m_renderFrame++;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class DiskColorHandler
    implements IItemColor {
        private final ItemDiskLegacy disk;

        private DiskColorHandler(ItemDiskLegacy disk) {
            this.disk = disk;
        }

        public int func_186726_a(ItemStack stack, int layer) {
            return layer == 0 ? 0xFFFFFF : this.disk.getColor(stack);
        }
    }
}

