/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.HTTPRequest;
import dan200.computercraft.core.apis.HTTPRequestException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HTTPAPI
implements ILuaAPI {
    private IAPIEnvironment m_apiEnvironment;
    private List<HTTPRequest> m_httpRequests;

    public HTTPAPI(IAPIEnvironment environment) {
        this.m_apiEnvironment = environment;
        this.m_httpRequests = new ArrayList<HTTPRequest>();
    }

    private static ILuaObject wrapBufferedReader(final BufferedReader reader, final int responseCode, final Map<String, String> responseHeaders) {
        return new ILuaObject(){

            @Override
            public String[] getMethodNames() {
                return new String[]{"readLine", "readAll", "close", "getResponseCode", "getResponseHeaders"};
            }

            @Override
            public Object[] callMethod(ILuaContext context, int method, Object[] args) throws LuaException {
                switch (method) {
                    case 0: {
                        try {
                            String line = reader.readLine();
                            if (line != null) {
                                return new Object[]{line};
                            }
                            return null;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    case 1: {
                        try {
                            StringBuilder result = new StringBuilder("");
                            String line = reader.readLine();
                            while (line != null) {
                                result.append(line);
                                line = reader.readLine();
                                if (line == null) continue;
                                result.append("\n");
                            }
                            return new Object[]{result.toString()};
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    case 2: {
                        try {
                            reader.close();
                            return null;
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    case 3: {
                        return new Object[]{responseCode};
                    }
                    case 4: {
                        return new Object[]{responseHeaders};
                    }
                }
                return null;
            }
        };
    }

    @Override
    public String[] getNames() {
        return new String[]{"http"};
    }

    @Override
    public void startup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance(double _dt) {
        List<HTTPRequest> list = this.m_httpRequests;
        synchronized (list) {
            Iterator<HTTPRequest> it = this.m_httpRequests.iterator();
            while (it.hasNext()) {
                ILuaObject result;
                BufferedReader contents;
                HTTPRequest h = it.next();
                if (!h.isComplete()) continue;
                String url = h.getURL();
                if (h.wasSuccessful()) {
                    contents = h.getContents();
                    result = HTTPAPI.wrapBufferedReader(contents, h.getResponseCode(), h.getResponseHeaders());
                    this.m_apiEnvironment.queueEvent("http_success", new Object[]{url, result});
                } else {
                    contents = h.getContents();
                    result = null;
                    if (contents != null) {
                        result = HTTPAPI.wrapBufferedReader(contents, h.getResponseCode(), h.getResponseHeaders());
                    }
                    this.m_apiEnvironment.queueEvent("http_failure", new Object[]{url, "Could not connect", result});
                }
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        List<HTTPRequest> list = this.m_httpRequests;
        synchronized (list) {
            for (HTTPRequest r : this.m_httpRequests) {
                r.cancel();
            }
            this.m_httpRequests.clear();
        }
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"request", "checkURL"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(ILuaContext context, int method, Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                if (args.length < 1 || !(args[0] instanceof String)) {
                    throw new LuaException("Expected string");
                }
                String urlString = args[0].toString();
                String postString = null;
                if (args.length >= 2 && args[1] instanceof String) {
                    postString = args[1].toString();
                }
                HashMap<String, String> headers = null;
                if (args.length >= 3 && args[2] instanceof Map) {
                    Map table = (Map)args[2];
                    headers = new HashMap<String, String>(table.size());
                    for (Object key : table.keySet()) {
                        Object value = table.get(key);
                        if (!(key instanceof String) || !(value instanceof String)) continue;
                        headers.put((String)key, (String)value);
                    }
                }
                try {
                    HTTPRequest request = new HTTPRequest(urlString, postString, headers);
                    List<HTTPRequest> list = this.m_httpRequests;
                    synchronized (list) {
                        this.m_httpRequests.add(request);
                    }
                    return new Object[]{true};
                }
                catch (HTTPRequestException e) {
                    return new Object[]{false, e.getMessage()};
                }
            }
            case 1: {
                if (args.length < 1 || !(args[0] instanceof String)) {
                    throw new LuaException("Expected string");
                }
                String urlString = args[0].toString();
                try {
                    HTTPRequest.checkURL(urlString);
                    return new Object[]{true};
                }
                catch (HTTPRequestException e) {
                    return new Object[]{false, e.getMessage()};
                }
            }
        }
        return null;
    }
}

