/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import com.google.common.base.Joiner;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.HTTPRequestException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HTTPRequest {
    private final String m_urlString;
    private Object m_lock = new Object();
    private URL m_url;
    private boolean m_complete;
    private boolean m_cancelled;
    private boolean m_success;
    private String m_result;
    private int m_responseCode;
    private Map<String, String> m_responseHeaders;

    public HTTPRequest(String url, String postText, Map<String, String> headers) throws HTTPRequestException {
        this.m_urlString = url;
        this.m_url = HTTPRequest.checkURL(this.m_urlString);
        this.m_cancelled = false;
        this.m_complete = false;
        this.m_success = false;
        this.m_result = null;
        this.m_responseCode = -1;
        Thread thread = new Thread(() -> {
            try {
                Object object;
                InputStreamReader isr;
                boolean responseSuccess;
                InputStream is;
                int code;
                HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
                if (postText != null) {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                } else {
                    connection.setRequestMethod("GET");
                }
                connection.setRequestProperty("accept-charset", "UTF-8");
                if (postText != null) {
                    connection.setRequestProperty("content-type", "application/x-www-form-urlencoded; charset=utf-8");
                    connection.setRequestProperty("content-encoding", "UTF-8");
                }
                if (headers != null) {
                    for (Map.Entry header : headers.entrySet()) {
                        connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                    }
                }
                if (postText != null) {
                    OutputStreamWriter osw;
                    OutputStream os = connection.getOutputStream();
                    try {
                        osw = new OutputStreamWriter(os, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        osw = new OutputStreamWriter(os);
                    }
                    BufferedWriter writer = new BufferedWriter(osw);
                    writer.write(postText, 0, postText.length());
                    writer.close();
                }
                if ((code = connection.getResponseCode()) >= 200 && code < 400) {
                    is = connection.getInputStream();
                    responseSuccess = true;
                } else {
                    is = connection.getErrorStream();
                    responseSuccess = false;
                }
                try {
                    String contentEncoding = connection.getContentEncoding();
                    if (contentEncoding != null) {
                        try {
                            isr = new InputStreamReader(is, contentEncoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            isr = new InputStreamReader(is, "UTF-8");
                        }
                    } else {
                        isr = new InputStreamReader(is, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    isr = new InputStreamReader(is);
                }
                BufferedReader reader = new BufferedReader(isr);
                StringBuilder result = new StringBuilder();
                while (true) {
                    object = this.m_lock;
                    synchronized (object) {
                        if (this.m_cancelled) {
                            break;
                        }
                    }
                    String line = reader.readLine();
                    if (line == null) break;
                    result.append(line);
                    result.append('\n');
                }
                reader.close();
                object = this.m_lock;
                synchronized (object) {
                    if (this.m_cancelled) {
                        this.m_complete = true;
                        this.m_success = false;
                        this.m_result = null;
                    } else {
                        this.m_complete = true;
                        this.m_success = responseSuccess;
                        this.m_result = result.toString();
                        this.m_responseCode = connection.getResponseCode();
                        Joiner joiner = Joiner.on((char)',');
                        this.m_responseHeaders = new HashMap<String, String>();
                        HashMap<String, String> headers1 = this.m_responseHeaders;
                        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                            headers1.put(header.getKey(), joiner.join((Iterable)header.getValue()));
                        }
                    }
                }
                connection.disconnect();
            }
            catch (IOException e) {
                Object object = this.m_lock;
                synchronized (object) {
                    this.m_complete = true;
                    this.m_success = false;
                    this.m_result = null;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static URL checkURL(String urlString) throws HTTPRequestException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new HTTPRequestException("URL malformed");
        }
        String protocol = url.getProtocol().toLowerCase();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new HTTPRequestException("URL not http");
        }
        boolean allowed = false;
        String whitelistString = ComputerCraft.Config.http_whitelist;
        String[] allowedURLs = whitelistString.split(";");
        for (int i = 0; i < allowedURLs.length; ++i) {
            String allowedURL = allowedURLs[i];
            Pattern allowedURLPattern = Pattern.compile("^\\Q" + allowedURL.replaceAll("\\*", "\\\\E.*\\\\Q") + "\\E$");
            if (!allowedURLPattern.matcher(url.getHost()).matches()) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return url;
    }

    public String getURL() {
        return this.m_urlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCode() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_responseCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResponseHeaders() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_responseHeaders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSuccessful() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getContents() {
        String result = null;
        Object object = this.m_lock;
        synchronized (object) {
            result = this.m_result;
        }
        if (result != null) {
            return new BufferedReader(new StringReader(result));
        }
        return null;
    }
}

