/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.shared.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OSAPI
implements ILuaAPI {
    private final Map<Integer, Timer> m_timers;
    private final Map<Integer, Alarm> m_alarms;
    private IAPIEnvironment m_apiEnvironment;
    private int m_clock;
    private double m_time;
    private int m_day;
    private int m_nextTimerToken;
    private int m_nextAlarmToken;

    public OSAPI(IAPIEnvironment environment) {
        this.m_apiEnvironment = environment;
        this.m_nextTimerToken = 0;
        this.m_nextAlarmToken = 0;
        this.m_timers = new HashMap<Integer, Timer>();
        this.m_alarms = new HashMap<Integer, Alarm>();
    }

    @Override
    public String[] getNames() {
        return new String[]{"os"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        this.m_time = this.m_apiEnvironment.getComputerEnvironment().getTimeOfDay();
        this.m_day = this.m_apiEnvironment.getComputerEnvironment().getDay();
        this.m_clock = 0;
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            this.m_timers.clear();
        }
        map = this.m_alarms;
        synchronized (map) {
            this.m_alarms.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance(double dt) {
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            ++this.m_clock;
            Iterator<Map.Entry<Integer, Timer>> it = this.m_timers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Timer> entry = it.next();
                Timer timer = entry.getValue();
                --timer.m_ticksLeft;
                if (timer.m_ticksLeft > 0) continue;
                this.queueLuaEvent("timer", new Object[]{entry.getKey()});
                it.remove();
            }
        }
        map = this.m_alarms;
        synchronized (map) {
            double previousTime = this.m_time;
            int previousDay = this.m_day;
            double time = this.m_apiEnvironment.getComputerEnvironment().getTimeOfDay();
            int day = this.m_apiEnvironment.getComputerEnvironment().getDay();
            if (time > previousTime || day > previousDay) {
                double now = (double)this.m_day * 24.0 + this.m_time;
                Iterator<Map.Entry<Integer, Alarm>> it = this.m_alarms.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Alarm> entry = it.next();
                    Alarm alarm = entry.getValue();
                    double t = (double)alarm.m_day * 24.0 + alarm.m_time;
                    if (!(now >= t)) continue;
                    this.queueLuaEvent("alarm", new Object[]{entry.getKey()});
                    it.remove();
                }
            }
            this.m_time = time;
            this.m_day = day;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<Integer, Object> map = this.m_timers;
        synchronized (map) {
            this.m_timers.clear();
        }
        map = this.m_alarms;
        synchronized (map) {
            this.m_alarms.clear();
        }
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"queueEvent", "startTimer", "setAlarm", "shutdown", "reboot", "computerID", "getComputerID", "setComputerLabel", "computerLabel", "getComputerLabel", "clock", "time", "day", "cancelTimer", "cancelAlarm"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(ILuaContext context, int method, Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                if (args.length == 0 || args[0] == null || !(args[0] instanceof String)) {
                    throw new LuaException("Expected string");
                }
                this.queueLuaEvent((String)args[0], this.trimArray(args, 1));
                return null;
            }
            case 1: {
                if (args.length < 1 || args[0] == null || !(args[0] instanceof Number)) {
                    throw new LuaException("Expected number");
                }
                double timer = ((Number)args[0]).doubleValue();
                Map<Integer, Timer> map = this.m_timers;
                synchronized (map) {
                    this.m_timers.put(this.m_nextTimerToken, new Timer((int)Math.round(timer / 0.05)));
                    return new Object[]{this.m_nextTimerToken++};
                }
            }
            case 2: {
                if (args.length < 1 || args[0] == null || !(args[0] instanceof Number)) {
                    throw new LuaException("Expected number");
                }
                double time = ((Number)args[0]).doubleValue();
                if (time < 0.0 || time >= 24.0) {
                    throw new LuaException("Number out of range");
                }
                Map<Integer, Alarm> map = this.m_alarms;
                synchronized (map) {
                    int day = time > this.m_time ? this.m_day : this.m_day + 1;
                    this.m_alarms.put(this.m_nextAlarmToken, new Alarm(time, day));
                    return new Object[]{this.m_nextAlarmToken++};
                }
            }
            case 3: {
                this.m_apiEnvironment.shutdown();
                return null;
            }
            case 4: {
                this.m_apiEnvironment.reboot();
                return null;
            }
            case 5: 
            case 6: {
                return new Object[]{this.getComputerID()};
            }
            case 7: {
                String label = null;
                if (args.length > 0 && args[0] != null) {
                    if (!(args[0] instanceof String)) {
                        throw new LuaException("Expected string or nil");
                    }
                    label = StringUtil.limit(args[0].toString());
                }
                this.m_apiEnvironment.setLabel(label);
                return null;
            }
            case 8: 
            case 9: {
                String label = this.m_apiEnvironment.getLabel();
                if (label != null) {
                    return new Object[]{label};
                }
                return null;
            }
            case 10: {
                Map<Integer, Timer> label = this.m_timers;
                synchronized (label) {
                    return new Object[]{(double)this.m_clock * 0.05};
                }
            }
            case 11: {
                Map<Integer, Alarm> label = this.m_alarms;
                synchronized (label) {
                    return new Object[]{this.m_time};
                }
            }
            case 12: {
                Map<Integer, Alarm> label = this.m_alarms;
                synchronized (label) {
                    return new Object[]{this.m_day};
                }
            }
            case 13: {
                if (args.length < 1 || args[0] == null || !(args[0] instanceof Number)) {
                    throw new LuaException("Expected number");
                }
                int token = ((Number)args[0]).intValue();
                Map<Integer, Timer> map = this.m_timers;
                synchronized (map) {
                    if (this.m_timers.containsKey(token)) {
                        this.m_timers.remove(token);
                    }
                }
                return null;
            }
            case 14: {
                if (args.length < 1 || args[0] == null || !(args[0] instanceof Number)) {
                    throw new LuaException("Expected number");
                }
                int token = ((Number)args[0]).intValue();
                Map<Integer, Alarm> map = this.m_alarms;
                synchronized (map) {
                    if (this.m_alarms.containsKey(token)) {
                        this.m_alarms.remove(token);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void queueLuaEvent(String event, Object[] args) {
        this.m_apiEnvironment.queueEvent(event, args);
    }

    private Object[] trimArray(Object[] array, int skip) {
        return Arrays.copyOfRange(array, skip, array.length);
    }

    private int getComputerID() {
        return this.m_apiEnvironment.getComputerID();
    }

    private class Alarm
    implements Comparable<Alarm> {
        public final double m_time;
        public final int m_day;

        public Alarm(double time, int day) {
            this.m_time = time;
            this.m_day = day;
        }

        @Override
        public int compareTo(Alarm o) {
            double t = (double)this.m_day * 24.0 + this.m_time;
            double ot = (double)this.m_day * 24.0 + this.m_time;
            if (t < ot) {
                return -1;
            }
            if (t > ot) {
                return 1;
            }
            return 0;
        }
    }

    private static class Timer {
        public int m_ticksLeft;

        public Timer(int ticksLeft) {
            this.m_ticksLeft = ticksLeft;
        }
    }
}

