/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.terminal.Terminal;

public class TermAPI
implements ILuaAPI {
    private Terminal m_terminal;
    private IComputerEnvironment m_environment;

    public TermAPI(IAPIEnvironment _environment) {
        this.m_terminal = _environment.getTerminal();
        this.m_environment = _environment.getComputerEnvironment();
    }

    public static int parseColour(Object[] args, boolean _enableColours) throws LuaException {
        if (args.length != 1 || args[0] == null || !(args[0] instanceof Double)) {
            throw new LuaException("Expected number");
        }
        int colour = (int)((Double)args[0]).doubleValue();
        if (colour <= 0) {
            throw new LuaException("Colour out of range");
        }
        if ((colour = TermAPI.getHighestBit(colour) - 1) < 0 || colour > 15) {
            throw new LuaException("Colour out of range");
        }
        if (!_enableColours && colour != 0 && colour != 15 && colour != 7 && colour != 8) {
            throw new LuaException("Colour not supported");
        }
        return colour;
    }

    public static Object[] encodeColour(int colour) throws LuaException {
        return new Object[]{1 << colour};
    }

    private static int getHighestBit(int group) {
        int bit = 0;
        while (group > 0) {
            group >>= 1;
            ++bit;
        }
        return bit;
    }

    @Override
    public String[] getNames() {
        return new String[]{"term"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double _dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"write", "scroll", "setCursorPos", "setCursorBlink", "getCursorPos", "getSize", "clear", "clearLine", "setTextColour", "setTextColor", "setBackgroundColour", "setBackgroundColor", "isColour", "isColor", "getTextColour", "getTextColor", "getBackgroundColour", "getBackgroundColor", "blit"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(ILuaContext context, int method, Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                String text = args.length > 0 && args[0] != null ? args[0].toString() : "";
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.write(text);
                    this.m_terminal.setCursorPos(this.m_terminal.getCursorX() + text.length(), this.m_terminal.getCursorY());
                }
                return null;
            }
            case 1: {
                if (args.length != 1 || args[0] == null || !(args[0] instanceof Double)) {
                    throw new LuaException("Expected number");
                }
                int y = (int)((Double)args[0]).doubleValue();
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.scroll(y);
                }
                return null;
            }
            case 2: {
                if (args.length != 2 || args[0] == null || !(args[0] instanceof Double) || args[1] == null || !(args[1] instanceof Double)) {
                    throw new LuaException("Expected number, number");
                }
                int x = (int)((Double)args[0]).doubleValue() - 1;
                int y = (int)((Double)args[1]).doubleValue() - 1;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.setCursorPos(x, y);
                }
                return null;
            }
            case 3: {
                if (args.length != 1 || args[0] == null || !(args[0] instanceof Boolean)) {
                    throw new LuaException("Expected boolean");
                }
                boolean b = (Boolean)args[0];
                Terminal y = this.m_terminal;
                synchronized (y) {
                    this.m_terminal.setCursorBlink(b);
                }
                return null;
            }
            case 4: {
                int y;
                int x;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    x = this.m_terminal.getCursorX();
                    y = this.m_terminal.getCursorY();
                }
                return new Object[]{x + 1, y + 1};
            }
            case 5: {
                int height;
                int width;
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    width = this.m_terminal.getWidth();
                    height = this.m_terminal.getHeight();
                }
                return new Object[]{width, height};
            }
            case 6: {
                Terminal width = this.m_terminal;
                synchronized (width) {
                    this.m_terminal.clear();
                }
                return null;
            }
            case 7: {
                Terminal width = this.m_terminal;
                synchronized (width) {
                    this.m_terminal.clearLine();
                }
                return null;
            }
            case 8: 
            case 9: {
                int colour = TermAPI.parseColour(args, this.m_environment.isColour());
                Terminal height = this.m_terminal;
                synchronized (height) {
                    this.m_terminal.setTextColour(colour);
                }
                return null;
            }
            case 10: 
            case 11: {
                int colour = TermAPI.parseColour(args, this.m_environment.isColour());
                Terminal height = this.m_terminal;
                synchronized (height) {
                    this.m_terminal.setBackgroundColour(colour);
                }
                return null;
            }
            case 12: 
            case 13: {
                return new Object[]{this.m_environment.isColour()};
            }
            case 14: 
            case 15: {
                return TermAPI.encodeColour(this.m_terminal.getTextColour());
            }
            case 16: 
            case 17: {
                return TermAPI.encodeColour(this.m_terminal.getBackgroundColour());
            }
            case 18: {
                if (!(args.length >= 3 && args[0] instanceof String && args[1] instanceof String && args[2] instanceof String)) {
                    throw new LuaException("Expected string, string, string");
                }
                String text = (String)args[0];
                String textColour = (String)args[1];
                String backgroundColour = (String)args[2];
                if (textColour.length() != text.length() || backgroundColour.length() != text.length()) {
                    throw new LuaException("Arguments must be the same length");
                }
                Terminal terminal = this.m_terminal;
                synchronized (terminal) {
                    this.m_terminal.blit(text, textColour, backgroundColour);
                    this.m_terminal.setCursorPos(this.m_terminal.getCursorX() + text.length(), this.m_terminal.getCursorY());
                }
                return null;
            }
        }
        return null;
    }
}

