/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ITask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ComputerThread {
    private static Object m_lock = new Object();
    private static Thread m_thread = null;
    private static WeakHashMap<Object, LinkedBlockingQueue<ITask>> m_computerTasks = new WeakHashMap();
    private static ArrayList<LinkedBlockingQueue<ITask>> m_computerTasksActive;
    private static ArrayList<LinkedBlockingQueue<ITask>> m_computerTasksPending;
    private static Object m_defaultQueue;
    private static Object m_monitor;
    private static boolean m_running;
    private static boolean m_stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = m_lock;
        synchronized (object) {
            if (m_running) {
                m_stopped = false;
                return;
            }
            m_thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block16: while (true) {
                        Object queue;
                        ArrayList arrayList = m_computerTasksPending;
                        synchronized (arrayList) {
                            if (!m_computerTasksPending.isEmpty()) {
                                Iterator it = m_computerTasksPending.iterator();
                                while (it.hasNext()) {
                                    queue = (LinkedBlockingQueue)it.next();
                                    if (!m_computerTasksActive.contains(queue)) {
                                        m_computerTasksActive.add(queue);
                                    }
                                    it.remove();
                                }
                            }
                        }
                        Iterator it = m_computerTasksActive.iterator();
                        while (it.hasNext()) {
                            LinkedBlockingQueue queue2;
                            block26: {
                                queue2 = (LinkedBlockingQueue)it.next();
                                if (queue2 == null || queue2.isEmpty()) continue;
                                queue = m_lock;
                                synchronized (queue) {
                                    if (m_stopped) {
                                        m_running = false;
                                        m_thread = null;
                                        return;
                                    }
                                }
                                try {
                                    final ITask task = (ITask)queue2.take();
                                    Thread worker = new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                task.execute();
                                            }
                                            catch (Throwable e) {
                                                System.out.println("ComputerCraft: Error running task.");
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    worker.setDaemon(true);
                                    worker.start();
                                    worker.join(7000L);
                                    if (!worker.isAlive()) break block26;
                                    Computer computer = task.getOwner();
                                    if (computer != null) {
                                        computer.abort(false);
                                        worker.join(1500L);
                                        if (worker.isAlive()) {
                                            computer.abort(true);
                                            worker.join(1500L);
                                        }
                                    }
                                    if (!worker.isAlive()) break block26;
                                    worker.interrupt();
                                }
                                catch (InterruptedException e) {
                                    continue;
                                }
                            }
                            LinkedBlockingQueue linkedBlockingQueue = queue2;
                            synchronized (linkedBlockingQueue) {
                                if (queue2.isEmpty()) {
                                    it.remove();
                                }
                            }
                        }
                        while (true) {
                            if (!m_computerTasksActive.isEmpty() || !m_computerTasksPending.isEmpty()) continue block16;
                            Object object = m_monitor;
                            synchronized (object) {
                                try {
                                    m_monitor.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        break;
                    }
                }
            }, "Computer Dispatch Thread");
            m_thread.setDaemon(true);
            m_thread.start();
            m_running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = m_lock;
        synchronized (object) {
            if (m_running) {
                m_stopped = true;
                m_thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueTask(ITask _task, Computer computer) {
        LinkedBlockingQueue<ITask> queue;
        Object queueObject = computer;
        if (queueObject == null) {
            queueObject = m_defaultQueue;
        }
        if ((queue = m_computerTasks.get(queueObject)) == null) {
            queue = new LinkedBlockingQueue(256);
            m_computerTasks.put(queueObject, queue);
        }
        Object object = m_computerTasksPending;
        synchronized (object) {
            if (queue.offer(_task) && !m_computerTasksPending.contains(queue)) {
                m_computerTasksPending.add(queue);
            }
        }
        object = m_monitor;
        synchronized (object) {
            m_monitor.notify();
        }
    }

    static {
        m_computerTasksPending = new ArrayList();
        m_computerTasksActive = new ArrayList();
        m_defaultQueue = new Object();
        m_monitor = new Object();
        m_running = false;
        m_stopped = false;
    }
}

