/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IMount;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ComboMount
implements IMount {
    private IMount[] m_parts;

    public ComboMount(IMount[] parts) {
        this.m_parts = parts;
    }

    @Override
    public boolean exists(String path) throws IOException {
        for (int i = this.m_parts.length - 1; i >= 0; --i) {
            IMount part = this.m_parts[i];
            if (!part.exists(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        for (int i = this.m_parts.length - 1; i >= 0; --i) {
            IMount part = this.m_parts[i];
            if (!part.isDirectory(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void list(String path, List<String> contents) throws IOException {
        ArrayList<String> foundFiles = null;
        int foundDirs = 0;
        for (int i = this.m_parts.length - 1; i >= 0; --i) {
            IMount part = this.m_parts[i];
            if (!part.exists(path) || !part.isDirectory(path)) continue;
            if (foundFiles == null) {
                foundFiles = new ArrayList<String>();
            }
            part.list(path, foundFiles);
            ++foundDirs;
        }
        if (foundDirs == 1) {
            contents.addAll(foundFiles);
        } else if (foundDirs > 1) {
            HashSet<String> seen = new HashSet<String>();
            for (int i = 0; i < foundFiles.size(); ++i) {
                String file = (String)foundFiles.get(i);
                if (!seen.add(file)) continue;
                contents.add(file);
            }
        } else {
            throw new IOException("Not a directory");
        }
    }

    @Override
    public long getSize(String path) throws IOException {
        for (int i = this.m_parts.length - 1; i >= 0; --i) {
            IMount part = this.m_parts[i];
            if (!part.exists(path)) continue;
            return part.getSize(path);
        }
        throw new IOException("No such file");
    }

    @Override
    public InputStream openForRead(String path) throws IOException {
        for (int i = this.m_parts.length - 1; i >= 0; --i) {
            IMount part = this.m_parts[i];
            if (!part.exists(path) || part.isDirectory(path)) continue;
            return part.openForRead(path);
        }
        throw new IOException("No such file");
    }
}

