/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.shared.common.TileGeneric;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockGeneric
extends Block
implements ITileEntityProvider {
    protected BlockGeneric(Material material) {
        super(material);
        this.field_149758_A = true;
    }

    protected abstract IBlockState getDefaultBlockState(int var1, EnumFacing var2);

    protected abstract TileGeneric createTile(IBlockState var1);

    protected abstract TileGeneric createTile(int var1);

    public final void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public final List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.getDroppedItems(drops, false);
        }
        return drops;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.getDefaultBlockState(meta, facing);
    }

    public final boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            boolean creative = player.field_71075_bZ.field_75098_d;
            this.dropAllItems(world, pos, creative);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public final void dropAllItems(World world, BlockPos pos, boolean creative) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.getDroppedItems(drops, creative);
        }
        if (drops.size() > 0) {
            for (ItemStack item : drops) {
                this.dropItem(world, pos, item);
            }
        }
    }

    public final void dropItem(World world, BlockPos pos, ItemStack stack) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    public final void func_180663_b(World world, BlockPos pos, IBlockState newState) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.destroy();
        }
        super.func_180663_b(world, pos, newState);
        world.func_175713_t(pos);
    }

    public final ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getPickedItem();
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.onActivate(playerIn, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.onNeighbourChange();
        }
    }

    public final boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.isSolidOnSide(side.ordinal());
        }
        return false;
    }

    public final boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileGeneric generic;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o() && (generic = (TileGeneric)tile).isImmuneToExplosion(exploder)) {
            return 2000.0f;
        }
        return super.func_149638_a(exploder);
    }

    public final AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBounds();
        }
        return field_185505_j;
    }

    public final AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)world, pos);
    }

    public final AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            ArrayList<AxisAlignedBB> collision = new ArrayList<AxisAlignedBB>(1);
            generic.getCollisionBounds(collision);
            if (collision.size() > 0) {
                AxisAlignedBB aabb = (AxisAlignedBB)collision.get(0);
                for (int i = 1; i < collision.size(); ++i) {
                    AxisAlignedBB other = (AxisAlignedBB)collision.get(1);
                    aabb = aabb.func_111270_a(other);
                }
                return aabb;
            }
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            ArrayList<AxisAlignedBB> collision = new ArrayList<AxisAlignedBB>(1);
            generic.getCollisionBounds(collision);
            if (collision.size() > 0) {
                for (AxisAlignedBB localBounds : collision) {
                    BlockGeneric.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)localBounds);
                }
            }
        }
    }

    public final boolean func_149744_f(IBlockState state) {
        return true;
    }

    public final boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getRedstoneConnectivity(side);
        }
        return false;
    }

    public final int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing oppositeSide) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getRedstoneOutput(oppositeSide.func_176734_d());
        }
        return 0;
    }

    public final int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing oppositeSide) {
        return this.func_176211_b(state, world, pos, oppositeSide);
    }

    public boolean getBundledRedstoneConnectivity(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBundledRedstoneConnectivity(side);
        }
        return false;
    }

    public int getBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileGeneric && tile.func_145830_o()) {
            TileGeneric generic = (TileGeneric)tile;
            return generic.getBundledRedstoneOutput(side);
        }
        return 0;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParameter) {
        TileEntity tile;
        if (world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileGeneric) {
            TileGeneric generic = (TileGeneric)tile;
            generic.onBlockEvent(eventID, eventParameter);
        }
        return true;
    }

    public final TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTile(state);
    }

    public final TileEntity func_149915_a(World world, int damage) {
        return this.createTile(damage);
    }
}

