/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.BlockCommandComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileCommandComputer
extends TileComputer {
    private CommandSender m_commandSender = new CommandSender();

    @Override
    public EnumFacing getDirection() {
        IBlockState state = this.getBlockState();
        return (EnumFacing)state.func_177229_b((IProperty)BlockCommandComputer.Properties.FACING);
    }

    @Override
    public void setDirection(EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            dir = EnumFacing.NORTH;
        }
        this.setBlockState(this.getBlockState().func_177226_a((IProperty)BlockCommandComputer.Properties.FACING, (Comparable)dir));
        this.updateInput();
    }

    public CommandSender getCommandSender() {
        return this.m_commandSender;
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = super.createComputer(instanceID, id);
        computer.addAPI(new CommandAPI(this));
        return computer;
    }

    @Override
    public boolean isUsable(EntityPlayer player, boolean ignoreRange) {
        MinecraftServer server = player.func_184102_h();
        if (server == null || !server.func_82356_Z()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notEnabled", new Object[0]));
            return true;
        }
        if (ComputerCraft.canPlayerUseCommands(player) && player.field_71075_bZ.field_75098_d) {
            return super.isUsable(player, ignoreRange);
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notAllowed", new Object[0]));
        return true;
    }

    public class CommandSender
    extends CommandBlockBaseLogic {
        private Map<Integer, String> m_outputTable = new HashMap<Integer, String>();

        public void clearOutput() {
            this.m_outputTable.clear();
        }

        public Map<Integer, String> getOutput() {
            return this.m_outputTable;
        }

        public Map<Integer, String> copyOutput() {
            return new HashMap<Integer, String>(this.m_outputTable);
        }

        public ITextComponent func_145748_c_() {
            String label;
            IComputer computer = TileCommandComputer.this.getComputer();
            if (computer != null && (label = computer.getLabel()) != null) {
                return new TextComponentString(computer.getLabel());
            }
            return new TextComponentString("@");
        }

        public void func_145747_a(ITextComponent component) {
            this.m_outputTable.put(this.m_outputTable.size() + 1, component.func_150260_c());
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos func_180425_c() {
            return TileCommandComputer.this.func_174877_v();
        }

        public Vec3d func_174791_d() {
            BlockPos pos = this.func_180425_c();
            return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }

        public World func_130014_f_() {
            return TileCommandComputer.this.func_145831_w();
        }

        public MinecraftServer func_184102_h() {
            return TileCommandComputer.this.func_145831_w().func_73046_m();
        }

        public Entity func_174793_f() {
            return null;
        }

        public void func_145756_e() {
        }

        public int func_145751_f() {
            return 0;
        }

        public void func_145757_a(ByteBuf buf) {
        }
    }
}

