/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemComputer
extends ItemComputerBase {
    public static int HIGHEST_DAMAGE_VALUE_ID = 16382;

    public ItemComputer(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77655_b("computercraft.computer");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    public ItemStack create(int id, String label, ComputerFamily family) {
        if (family != ComputerFamily.Normal && family != ComputerFamily.Advanced) {
            return null;
        }
        int damage = 0;
        if (id >= 0 && id <= HIGHEST_DAMAGE_VALUE_ID) {
            damage = id + 1;
        }
        if (family == ComputerFamily.Advanced) {
            damage += 16384;
        }
        ItemStack result = new ItemStack((Item)this, 1, damage);
        if (id > HIGHEST_DAMAGE_VALUE_ID) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("computerID", id);
            result.func_77982_d(nbt);
        }
        if (label != null) {
            result.func_151001_c(label);
        }
        return result;
    }

    public void func_150895_a(Item itemID, CreativeTabs tabs, List<ItemStack> list) {
        list.add(ComputerItemFactory.create(-1, null, ComputerFamily.Normal));
        list.add(ComputerItemFactory.create(-1, null, ComputerFamily.Advanced));
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof IComputerTile) {
                IComputerTile computer = (IComputerTile)tile;
                this.setupComputerAfterPlacement(stack, computer);
            }
            return true;
        }
        return false;
    }

    private void setupComputerAfterPlacement(ItemStack stack, IComputerTile computer) {
        String label;
        int id = this.getComputerID(stack);
        if (id >= 0) {
            computer.setComputerID(id);
        }
        if ((label = this.getLabel(stack)) != null) {
            computer.setLabel(label);
        }
    }

    public String func_77667_c(ItemStack stack) {
        switch (this.getFamily(stack)) {
            default: {
                return "tile.computercraft.computer";
            }
            case Advanced: {
                return "tile.computercraft.advanced_computer";
            }
            case Command: 
        }
        return "tile.computercraft.command_computer";
    }

    @Override
    public int getComputerID(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("computerID")) {
            return stack.func_77978_p().func_74762_e("computerID");
        }
        int damage = stack.func_77952_i() & 0x3FFF;
        return damage - 1;
    }

    @Override
    public ComputerFamily getFamily(int damage) {
        if ((damage & 0x4000) != 0) {
            return ComputerFamily.Advanced;
        }
        return ComputerFamily.Normal;
    }
}

