/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.media.items.ItemDiskExpanded;
import dan200.computercraft.shared.util.Colour;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemDiskLegacy
extends Item
implements IMedia {
    public ItemDiskLegacy() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("computercraft.disk");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    public static ItemStack createFromIDAndColour(int id, String label, int colour) {
        if (colour != Colour.Blue.getHex()) {
            return ItemDiskExpanded.createFromIDAndColour(id, label, colour);
        }
        ItemStack stack = new ItemStack((Item)ComputerCraft.Items.disk, 1);
        ComputerCraft.Items.disk.setDiskID(stack, id);
        ComputerCraft.Items.disk.setLabel(stack, label);
        return stack;
    }

    public void func_150895_a(Item itemID, CreativeTabs tabs, List<ItemStack> list) {
        for (int colour = 0; colour < 16; ++colour) {
            ItemStack stack = ItemDiskLegacy.createFromIDAndColour(-1, null, Colour.values()[colour].getHex());
            if (stack.func_77973_b() != this) continue;
            list.add(stack);
        }
    }

    public int getDiskID(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (damage > 0) {
            return damage;
        }
        return -1;
    }

    protected void setDiskID(ItemStack stack, int id) {
        if (id > 0) {
            stack.func_77964_b(id);
        } else {
            stack.func_77964_b(0);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        int id;
        if (debug && (id = this.getDiskID(stack)) >= 0) {
            list.add("(Disk ID: " + id + ")");
        }
    }

    @Override
    public String getLabel(ItemStack stack) {
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return null;
    }

    @Override
    public boolean setLabel(ItemStack stack, String label) {
        if (label != null) {
            stack.func_151001_c(label);
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public String getAudioTitle(ItemStack stack) {
        return null;
    }

    @Override
    public SoundEvent getAudio(ItemStack stack) {
        return null;
    }

    @Override
    public IMount createDataMount(ItemStack stack, World world) {
        int diskID = this.getDiskID(stack);
        if (diskID < 0) {
            diskID = ComputerCraft.createUniqueNumberedSaveDir(world, "computer/disk");
            this.setDiskID(stack, diskID);
        }
        return ComputerCraftAPI.createSaveDirMount(world, "computer/disk/" + diskID, ComputerCraft.Config.floppySpaceLimit);
    }

    public int getColor(ItemStack stack) {
        return Colour.Blue.getHex();
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }
}

