/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class ComputerCraftPacket {
    public static final byte TurnOn = 1;
    public static final byte Reboot = 2;
    public static final byte Shutdown = 3;
    public static final byte QueueEvent = 4;
    public static final byte RequestComputerUpdate = 5;
    public static final byte SetLabel = 6;
    public static final byte RequestTileEntityUpdate = 9;
    public static final byte ComputerChanged = 7;
    public static final byte ComputerDeleted = 8;
    public byte m_packetType = 0;
    public String[] m_dataString = null;
    public int[] m_dataInt = null;
    public byte[][] m_dataByte = null;
    public NBTTagCompound m_dataNBT = null;

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte((int)this.m_packetType);
        if (this.m_dataString != null) {
            buffer.writeByte(this.m_dataString.length);
        } else {
            buffer.writeByte(0);
        }
        if (this.m_dataInt != null) {
            buffer.writeByte(this.m_dataInt.length);
        } else {
            buffer.writeByte(0);
        }
        if (this.m_dataByte != null) {
            buffer.writeInt(this.m_dataByte.length);
        } else {
            buffer.writeInt(0);
        }
        if (this.m_dataString != null) {
            for (String s : this.m_dataString) {
                if (s != null) {
                    try {
                        byte[] b = s.getBytes("UTF-8");
                        buffer.writeBoolean(true);
                        buffer.writeInt(b.length);
                        buffer.writeBytes(b);
                    }
                    catch (UnsupportedEncodingException e) {
                        buffer.writeBoolean(false);
                    }
                    continue;
                }
                buffer.writeBoolean(false);
            }
        }
        if (this.m_dataInt != null) {
            for (int i : this.m_dataInt) {
                buffer.writeInt(i);
            }
        }
        if (this.m_dataByte != null) {
            for (byte[] bytes : this.m_dataByte) {
                if (bytes != null) {
                    buffer.writeInt(bytes.length);
                    buffer.writeBytes(bytes);
                    continue;
                }
                buffer.writeInt(0);
            }
        }
        if (this.m_dataNBT != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.m_dataNBT, (OutputStream)byteArrayOutputStream);
                byte[] bytes = byteArrayOutputStream.toByteArray();
                buffer.writeBoolean(true);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            }
            catch (IOException iOException) {
                buffer.writeBoolean(false);
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int k;
        this.m_packetType = buffer.readByte();
        int nString = buffer.readByte();
        int nInt = buffer.readByte();
        int nByte = buffer.readInt();
        if (nString == 0) {
            this.m_dataString = null;
        } else {
            this.m_dataString = new String[nString];
            for (k = 0; k < nString; ++k) {
                if (!buffer.readBoolean()) continue;
                int len = buffer.readInt();
                byte[] b = new byte[len];
                buffer.readBytes(b);
                try {
                    this.m_dataString[k] = new String(b, "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    this.m_dataString[k] = null;
                }
            }
        }
        if (nInt == 0) {
            this.m_dataInt = null;
        } else {
            this.m_dataInt = new int[nInt];
            for (k = 0; k < nInt; ++k) {
                this.m_dataInt[k] = buffer.readInt();
            }
        }
        if (nByte == 0) {
            this.m_dataByte = null;
        } else {
            this.m_dataByte = new byte[nByte][];
            for (k = 0; k < nByte; ++k) {
                int length = buffer.readInt();
                if (length <= 0) continue;
                this.m_dataByte[k] = new byte[length];
                buffer.getBytes(buffer.readerIndex(), this.m_dataByte[k]);
            }
        }
        boolean bNBT = buffer.readBoolean();
        if (!bNBT) {
            this.m_dataNBT = null;
        } else {
            int byteLength = buffer.readInt();
            byte[] bytes = new byte[byteLength];
            buffer.getBytes(buffer.readerIndex(), bytes);
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                this.m_dataNBT = CompressedStreamTools.func_74796_a((InputStream)bis);
            }
            catch (IOException e) {
                this.m_dataNBT = null;
            }
        }
    }
}

