/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import com.google.common.base.Predicate;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockPeripheralBase;
import dan200.computercraft.shared.peripheral.common.BlockPeripheralVariant;
import dan200.computercraft.shared.peripheral.common.ItemPeripheral;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.modem.TileWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPeripheral
extends BlockPeripheralBase {
    public BlockPeripheral() {
        this.func_149711_c(2.0f);
        this.func_149663_c("computercraft.peripheral");
        this.func_149647_a(ComputerCraft.mainCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH).func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveEmpty)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING, Properties.VARIANT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        switch (this.getPeripheralType(world, pos)) {
            case AdvancedMonitor: {
                return 7;
            }
            case Monitor: {
                return 5;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta >= 2 && meta <= 5) {
            state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveEmpty));
            state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
        } else if (meta <= 9) {
            if (meta == 0) {
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemDownOff));
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
            } else if (meta == 1) {
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemUpOff));
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
            } else {
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemOff));
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.func_82600_a((int)(meta - 4)));
            }
        } else if (meta == 10) {
            state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.Monitor));
        } else if (meta == 11) {
            state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterEmpty));
        } else if (meta == 12) {
            state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.AdvancedMonitor));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        BlockPeripheralVariant variant = (BlockPeripheralVariant)((Object)state.func_177229_b(Properties.VARIANT));
        block0 : switch (variant.getPeripheralType()) {
            case DiskDrive: {
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING);
                if (dir.func_176740_k() == EnumFacing.Axis.Y) {
                    dir = EnumFacing.NORTH;
                }
                meta = dir.func_176745_a();
                break;
            }
            case WirelessModem: {
                switch (variant) {
                    case WirelessModemDownOff: 
                    case WirelessModemDownOn: {
                        meta = 0;
                        break block0;
                    }
                    case WirelessModemUpOff: 
                    case WirelessModemUpOn: {
                        meta = 1;
                        break block0;
                    }
                }
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING);
                meta = dir.func_176745_a() + 4;
                break;
            }
            case Monitor: {
                meta = 10;
                break;
            }
            case Printer: {
                meta = 11;
                break;
            }
            case AdvancedMonitor: {
                meta = 12;
            }
        }
        return meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing dir;
        int anim;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TilePeripheralBase) {
            TilePeripheralBase peripheral = (TilePeripheralBase)tile;
            anim = peripheral.getAnim();
            dir = peripheral.getDirection();
        } else {
            anim = 0;
            dir = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING);
            switch ((BlockPeripheralVariant)((Object)state.func_177229_b(Properties.VARIANT))) {
                case WirelessModemDownOff: 
                case WirelessModemDownOn: {
                    dir = EnumFacing.DOWN;
                    break;
                }
                case WirelessModemUpOff: 
                case WirelessModemUpOn: {
                    dir = EnumFacing.UP;
                }
            }
        }
        PeripheralType type = this.getPeripheralType(state);
        block4 : switch (type) {
            case DiskDrive: {
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
                switch (anim) {
                    default: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveEmpty));
                        break block4;
                    }
                    case 1: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveInvalid));
                        break block4;
                    }
                    case 2: 
                }
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveFull));
                break;
            }
            case Printer: {
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
                switch (anim) {
                    default: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterEmpty));
                        break block4;
                    }
                    case 1: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterTopFull));
                        break block4;
                    }
                    case 2: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterBottomFull));
                        break block4;
                    }
                    case 3: 
                }
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterBothFull));
                break;
            }
            case WirelessModem: {
                switch (dir) {
                    case UP: {
                        state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
                        switch (anim) {
                            default: {
                                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemUpOff));
                                break block4;
                            }
                            case 1: 
                        }
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemUpOn));
                        break block4;
                    }
                    case DOWN: {
                        state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
                        switch (anim) {
                            default: {
                                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemDownOff));
                                break block4;
                            }
                            case 1: 
                        }
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemDownOn));
                        break block4;
                    }
                }
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
                switch (anim) {
                    default: {
                        state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemOff));
                        break block4;
                    }
                    case 1: 
                }
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemOn));
                break;
            }
            case AdvancedMonitor: 
            case Monitor: {
                int subType;
                BlockPeripheralVariant baseVariant;
                int height;
                int width;
                int yIndex;
                int xIndex;
                EnumFacing front;
                if (tile != null && tile instanceof TileMonitor) {
                    TileMonitor monitor = (TileMonitor)tile;
                    dir = monitor.getDirection();
                    front = monitor.getFront();
                    xIndex = monitor.getXIndex();
                    yIndex = monitor.getYIndex();
                    width = monitor.getWidth();
                    height = monitor.getHeight();
                } else {
                    dir = EnumFacing.NORTH;
                    front = EnumFacing.NORTH;
                    xIndex = 0;
                    yIndex = 0;
                    width = 1;
                    height = 1;
                }
                if (front == EnumFacing.UP) {
                    baseVariant = type == PeripheralType.AdvancedMonitor ? BlockPeripheralVariant.AdvancedMonitorUp : BlockPeripheralVariant.MonitorUp;
                } else if (front == EnumFacing.DOWN) {
                    baseVariant = type == PeripheralType.AdvancedMonitor ? BlockPeripheralVariant.AdvancedMonitorDown : BlockPeripheralVariant.MonitorDown;
                } else {
                    BlockPeripheralVariant blockPeripheralVariant = baseVariant = type == PeripheralType.AdvancedMonitor ? BlockPeripheralVariant.AdvancedMonitor : BlockPeripheralVariant.Monitor;
                }
                if (width == 1 && height == 1) {
                    subType = 0;
                } else if (height == 1) {
                    subType = xIndex == 0 ? 1 : (xIndex == width - 1 ? 3 : 2);
                } else if (width == 1) {
                    subType = yIndex == 0 ? 6 : (yIndex == height - 1 ? 4 : 5);
                } else {
                    subType = xIndex == 0 ? 7 : (xIndex == width - 1 ? 9 : 8);
                    if (yIndex == 0) {
                        subType += 6;
                    } else if (yIndex < height - 1) {
                        subType += 3;
                    }
                }
                state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
                state = state.func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.values()[baseVariant.ordinal() + subType]));
                break;
            }
        }
        return state;
    }

    @Override
    public IBlockState getDefaultBlockState(PeripheralType type, EnumFacing placedSide) {
        switch (type) {
            default: {
                IBlockState state = this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.DiskDriveEmpty));
                if (placedSide.func_176740_k() != EnumFacing.Axis.Y) {
                    return state.func_177226_a((IProperty)Properties.FACING, (Comparable)placedSide);
                }
                return state.func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
            }
            case WirelessModem: {
                EnumFacing dir = placedSide.func_176734_d();
                if (dir == EnumFacing.DOWN) {
                    return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemDownOff)).func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
                }
                if (dir == EnumFacing.UP) {
                    return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemUpOff)).func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH);
                }
                return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemOff)).func_177226_a((IProperty)Properties.FACING, (Comparable)dir);
            }
            case Monitor: {
                return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.Monitor));
            }
            case Printer: {
                return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.PrinterEmpty));
            }
            case AdvancedMonitor: 
        }
        return this.func_176223_P().func_177226_a(Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.AdvancedMonitor));
    }

    @Override
    public PeripheralType getPeripheralType(int damage) {
        return ((ItemPeripheral)Item.func_150898_a((Block)this)).getPeripheralType(damage);
    }

    @Override
    public PeripheralType getPeripheralType(IBlockState state) {
        return ((BlockPeripheralVariant)((Object)state.func_177229_b(Properties.VARIANT))).getPeripheralType();
    }

    @Override
    public TilePeripheralBase createTile(PeripheralType type) {
        switch (type) {
            default: {
                return new TileDiskDrive();
            }
            case WirelessModem: {
                return new TileWirelessModem();
            }
            case AdvancedMonitor: 
            case Monitor: {
                return new TileMonitor();
            }
            case Printer: 
        }
        return new TilePrinter();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TilePeripheralBase) {
            tile.func_145834_a(world);
            tile.func_174878_a(pos);
        }
        switch (this.getPeripheralType(state)) {
            case DiskDrive: 
            case Printer: {
                EnumFacing dir = DirectionUtil.fromEntityRot(player);
                this.setDirection(world, pos, dir);
                if (!stack.func_82837_s() || tile == null || !(tile instanceof TilePeripheralBase)) break;
                TilePeripheralBase peripheral = (TilePeripheralBase)tile;
                peripheral.setLabel(stack.func_82833_r());
                break;
            }
            case AdvancedMonitor: 
            case Monitor: {
                if (tile == null || !(tile instanceof TileMonitor)) break;
                int direction = DirectionUtil.fromEntityRot(player).func_176745_a();
                if (player.field_70125_A > 66.5f) {
                    direction += 12;
                } else if (player.field_70125_A < -66.5f) {
                    direction += 6;
                }
                TileMonitor monitor = (TileMonitor)tile;
                if (world.field_72995_K) {
                    monitor.setDir(direction);
                    break;
                }
                monitor.contractNeighbours();
                monitor.setDir(direction);
                monitor.contract();
                monitor.expand();
            }
        }
    }

    public static class Properties {
        public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        public static final PropertyEnum<BlockPeripheralVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPeripheralVariant.class);
    }
}

