/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockPeripheral;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileDiskDrive
extends TilePeripheralBase
implements ITickable,
IInventory {
    private static final int BLOCKEVENT_PLAY_RECORD = 0;
    private static final int BLOCKEVENT_STOP_RECORD = 1;
    private final Map<IComputerAccess, MountInfo> m_computers = new HashMap<IComputerAccess, MountInfo>();
    private ItemStack m_diskStack = null;
    private IMount m_diskMount = null;
    private boolean m_recordQueued = false;
    private boolean m_recordPlaying = false;
    private boolean m_restartRecord = false;
    private boolean m_ejectQueued;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.ejectContents(true);
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.m_recordPlaying) {
                this.sendBlockEvent(1);
            }
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ItemStack disk;
            if (!this.func_145831_w().field_72995_K && (disk = player.func_184586_b(EnumHand.MAIN_HAND)) != null && this.func_70301_a(0) == null && ComputerCraft.getMedia(disk) != null) {
                this.func_70299_a(0, disk);
                player.func_184611_a(EnumHand.MAIN_HAND, null);
                return true;
            }
        } else {
            if (!this.func_145831_w().field_72995_K) {
                ComputerCraft.openDiskDriveGUI(player, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumFacing getDirection() {
        IBlockState state = this.getBlockState();
        return (EnumFacing)state.func_177229_b((IProperty)BlockPeripheral.Properties.FACING);
    }

    @Override
    public void setDirection(EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            dir = EnumFacing.NORTH;
        }
        this.setBlockState(this.getBlockState().func_177226_a((IProperty)BlockPeripheral.Properties.FACING, (Comparable)dir));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("item")) {
            NBTTagCompound item = nbttagcompound.func_74775_l("item");
            this.m_diskStack = ItemStack.func_77949_a((NBTTagCompound)item);
            this.m_diskMount = null;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.m_diskStack != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.m_diskStack.func_77955_b(item);
            nbttagcompound.func_74782_a("item", (NBTBase)item);
        }
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.m_ejectQueued) {
                this.ejectContents(false);
                this.m_ejectQueued = false;
            }
        }
        tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.m_recordPlaying != this.m_recordQueued || this.m_restartRecord) {
                this.m_restartRecord = false;
                if (this.m_recordQueued) {
                    SoundEvent record;
                    IMedia contents = this.getDiskMedia();
                    SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.m_diskStack) : null;
                    if (record != null) {
                        this.m_recordPlaying = true;
                        this.sendBlockEvent(0);
                    } else {
                        this.m_recordQueued = false;
                    }
                } else {
                    this.sendBlockEvent(1);
                    this.m_recordPlaying = false;
                }
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.m_diskStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack result = this.m_diskStack;
        this.m_diskStack = null;
        this.m_diskMount = null;
        return result;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.m_diskStack == null) {
            return null;
        }
        if (this.m_diskStack.field_77994_a <= j) {
            ItemStack disk = this.m_diskStack;
            this.func_70299_a(0, null);
            return disk;
        }
        ItemStack part = this.m_diskStack.func_77979_a(j);
        if (this.m_diskStack.field_77994_a == 0) {
            this.func_70299_a(0, null);
        } else {
            this.func_70299_a(0, this.m_diskStack);
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, ItemStack itemStack) {
        if (this.func_145831_w().field_72995_K) {
            this.m_diskStack = itemStack;
            this.m_diskMount = null;
            this.func_70296_d();
            return;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            Set<IComputerAccess> computers;
            if (InventoryUtil.areItemsStackable(itemStack, this.m_diskStack)) {
                this.m_diskStack = itemStack;
                return;
            }
            if (this.m_diskStack != null) {
                computers = this.m_computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.unmountDisk(computer);
                }
            }
            if (this.m_recordPlaying) {
                this.sendBlockEvent(1);
                this.m_recordPlaying = false;
                this.m_recordQueued = false;
            }
            this.m_diskStack = itemStack;
            this.m_diskMount = null;
            this.func_70296_d();
            this.updateAnim();
            if (this.m_diskStack != null) {
                computers = this.m_computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.mountDisk(computer);
                }
            }
        }
    }

    public boolean func_145818_k_() {
        return this.getLabel() != null;
    }

    public String func_70005_c_() {
        String label = this.getLabel();
        if (label != null) {
            return label;
        }
        return "tile.computercraft.drive.name";
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_174888_l() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.func_70299_a(0, null);
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        return new DiskDrivePeripheral(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getDiskStack() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            return this.func_70301_a(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskStack(ItemStack stack) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.func_70299_a(0, stack);
        }
    }

    public IMedia getDiskMedia() {
        return ComputerCraft.getMedia(this.getDiskStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiskMountPath(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (this.m_computers.containsKey(computer)) {
                MountInfo info = this.m_computers.get(computer);
                return info.mountPath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.m_computers.put(computer, new MountInfo());
            this.mountDisk(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.unmountDisk(computer);
            this.m_computers.remove(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            IMedia media = this.getDiskMedia();
            if (media != null && media.getAudioTitle(this.m_diskStack) != null) {
                this.m_recordQueued = true;
                this.m_restartRecord = this.m_recordPlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.m_recordQueued = false;
            this.m_restartRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejectDisk() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (!this.m_ejectQueued) {
                this.m_ejectQueued = true;
            }
        }
    }

    private synchronized void mountDisk(IComputerAccess computer) {
        if (this.m_diskStack != null) {
            MountInfo info = this.m_computers.get(computer);
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                if (this.m_diskMount == null) {
                    this.m_diskMount = contents.createDataMount(this.m_diskStack, this.func_145831_w());
                }
                if (this.m_diskMount != null) {
                    if (this.m_diskMount instanceof IWritableMount) {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mountWritable(n == 1 ? "disk" : "disk" + n, (IWritableMount)this.m_diskMount);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mount(n == 1 ? "disk" : "disk" + n, this.m_diskMount);
                            ++n;
                        }
                    }
                } else {
                    info.mountPath = null;
                }
            }
            computer.queueEvent("disk", new Object[]{computer.getAttachmentName()});
        }
    }

    private synchronized void unmountDisk(IComputerAccess computer) {
        if (this.m_diskStack != null) {
            MountInfo info = this.m_computers.get(computer);
            assert (info != null);
            if (info.mountPath != null) {
                computer.unmount(info.mountPath);
                info.mountPath = null;
            }
            computer.queueEvent("disk_eject", new Object[]{computer.getAttachmentName()});
        }
    }

    private synchronized void updateAnim() {
        if (this.m_diskStack != null) {
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                this.setAnim(2);
            } else {
                this.setAnim(1);
            }
        } else {
            this.setAnim(0);
        }
    }

    private synchronized void ejectContents(boolean destroyed) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.m_diskStack != null) {
            ItemStack disks = this.m_diskStack;
            this.func_70299_a(0, null);
            int xOff = 0;
            int zOff = 0;
            if (!destroyed) {
                EnumFacing dir = this.getDirection();
                xOff = dir.func_82601_c();
                zOff = dir.func_82599_e();
            }
            BlockPos pos = this.func_174877_v();
            double x = (double)pos.func_177958_n() + 0.5 + (double)xOff * 0.5;
            double y = (double)pos.func_177956_o() + 0.75;
            double z = (double)pos.func_177952_p() + 0.5 + (double)zOff * 0.5;
            EntityItem entityitem = new EntityItem(this.func_145831_w(), x, y, z, disks);
            entityitem.field_70159_w = (double)xOff * 0.15;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = (double)zOff * 0.15;
            this.func_145831_w().func_72838_d((Entity)entityitem);
            if (!destroyed) {
                this.func_145831_w().func_175669_a(1000, this.func_174877_v(), 0);
            }
        }
    }

    @Override
    public final void readDescription(NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.m_diskStack = nbttagcompound.func_74764_b("item") ? ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("item")) : null;
        this.updateBlock();
    }

    @Override
    public void writeDescription(NBTTagCompound nbttagcompound) {
        super.writeDescription(nbttagcompound);
        if (this.m_diskStack != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.m_diskStack.func_77955_b(item);
            nbttagcompound.func_74782_a("item", (NBTBase)item);
        }
    }

    @Override
    public void onBlockEvent(int eventID, int eventParameter) {
        super.onBlockEvent(eventID, eventParameter);
        switch (eventID) {
            case 0: {
                this.playRecord();
                break;
            }
            case 1: {
                this.stopRecord();
            }
        }
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return super.shouldRefresh(world, pos, oldState, newState) || ComputerCraft.Blocks.peripheral.getPeripheralType(newState) != PeripheralType.DiskDrive;
    }

    private void playRecord() {
        SoundEvent record;
        IMedia contents = this.getDiskMedia();
        SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.m_diskStack) : null;
        if (record != null) {
            ComputerCraft.playRecord(record, contents.getAudioTitle(this.m_diskStack), this.func_145831_w(), this.func_174877_v());
        } else {
            ComputerCraft.playRecord(null, null, this.func_145831_w(), this.func_174877_v());
        }
    }

    private void stopRecord() {
        ComputerCraft.playRecord(null, null, this.func_145831_w(), this.func_174877_v());
    }

    private static class MountInfo {
        public String mountPath;

        private MountInfo() {
        }
    }
}

