/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.INetwork;
import dan200.computercraft.shared.peripheral.modem.IReceiver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ModemPeripheral
implements IPeripheral {
    private INetwork m_network = null;
    private IComputerAccess m_computer = null;
    private Map<Integer, IReceiver> m_channels = new HashMap<Integer, IReceiver>();
    private boolean m_open = false;
    private boolean m_changed = true;

    private static int parseChannel(Object[] arguments, int index) throws LuaException {
        if (arguments.length <= index || !(arguments[index] instanceof Double)) {
            throw new LuaException("Expected number");
        }
        int channel = (int)((Double)arguments[index]).doubleValue();
        if (channel < 0 || channel > 65535) {
            throw new LuaException("Expected number in range 0-65535");
        }
        return channel;
    }

    protected void switchNetwork() {
        this.setNetwork(this.getNetwork());
    }

    protected abstract World getWorld();

    protected abstract Vec3d getPosition();

    public synchronized void destroy() {
        this.setNetwork(null);
        this.m_channels.clear();
        this.m_open = false;
    }

    public synchronized boolean pollChanged() {
        if (this.m_changed) {
            this.m_changed = false;
            return true;
        }
        return false;
    }

    protected abstract double getTransmitRange();

    protected abstract boolean isInterdimensional();

    public synchronized boolean isActive() {
        return this.m_computer != null && this.m_open;
    }

    public synchronized Vec3d getWorldPosition() {
        return this.getPosition();
    }

    public synchronized double getReceiveRange() {
        return this.getTransmitRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSameDimension(int channel, int replyChannel, Object payload, double distance) {
        Map<Integer, IReceiver> map = this.m_channels;
        synchronized (map) {
            if (this.m_computer != null && this.m_channels.containsKey(channel)) {
                this.m_computer.queueEvent("modem_message", new Object[]{this.m_computer.getAttachmentName(), channel, replyChannel, payload, distance});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDifferentDimension(int channel, int replyChannel, Object payload) {
        Map<Integer, IReceiver> map = this.m_channels;
        synchronized (map) {
            if (this.m_computer != null && this.m_channels.containsKey(channel)) {
                this.m_computer.queueEvent("modem_message", new Object[]{this.m_computer.getAttachmentName(), channel, replyChannel, payload});
            }
        }
    }

    protected abstract INetwork getNetwork();

    private synchronized void setNetwork(INetwork network) {
        if (this.m_network != network) {
            Iterator<IReceiver> it;
            if (this.m_network != null) {
                it = this.m_channels.values().iterator();
                while (it.hasNext()) {
                    this.m_network.removeReceiver(it.next());
                }
            }
            this.m_network = network;
            if (this.m_network != null) {
                it = this.m_channels.values().iterator();
                while (it.hasNext()) {
                    this.m_network.addReceiver(it.next());
                }
            }
        }
    }

    @Override
    public String getType() {
        return "modem";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"open", "isOpen", "close", "closeAll", "transmit", "isWireless"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (!this.m_channels.containsKey(channel)) {
                        if (this.m_channels.size() >= 128) {
                            throw new LuaException("Too many open channels");
                        }
                        SingleChannelReceiver receiver = new SingleChannelReceiver(this, channel);
                        this.m_channels.put(channel, receiver);
                        if (this.m_network != null) {
                            this.m_network.addReceiver(receiver);
                        }
                        if (!this.m_open) {
                            this.m_open = true;
                            this.m_changed = true;
                        }
                    }
                }
                return null;
            }
            case 1: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    boolean open = this.m_channels.containsKey(channel);
                    return new Object[]{open};
                }
            }
            case 2: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (this.m_channels.containsKey(channel)) {
                        IReceiver receiver = this.m_channels.get(channel);
                        if (this.m_network != null) {
                            this.m_network.removeReceiver(receiver);
                        }
                        this.m_channels.remove(channel);
                        if (this.m_channels.size() == 0) {
                            this.m_open = false;
                            this.m_changed = true;
                        }
                    }
                }
                return null;
            }
            case 3: {
                ModemPeripheral channel = this;
                synchronized (channel) {
                    if (this.m_channels.size() > 0) {
                        if (this.m_network != null) {
                            Iterator<IReceiver> it = this.m_channels.values().iterator();
                            while (it.hasNext()) {
                                this.m_network.removeReceiver(it.next());
                            }
                        }
                        this.m_channels.clear();
                        if (this.m_open) {
                            this.m_open = false;
                            this.m_changed = true;
                        }
                    }
                }
                return null;
            }
            case 4: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                int replyChannel = ModemPeripheral.parseChannel(arguments, 1);
                Object payload = arguments.length >= 3 ? arguments[2] : null;
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    World world = this.getWorld();
                    Vec3d position = this.getPosition();
                    if (world != null && position != null && this.m_network != null) {
                        this.m_network.transmit(channel, replyChannel, payload, world, position, this.getTransmitRange(), this.isInterdimensional(), this);
                    }
                }
                return null;
            }
            case 5: {
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (this.m_network != null) {
                        return new Object[]{this.m_network.isWireless()};
                    }
                }
                return new Object[]{false};
            }
        }
        return null;
    }

    @Override
    public synchronized void attach(IComputerAccess computer) {
        this.m_computer = computer;
        this.setNetwork(this.getNetwork());
        this.m_open = !this.m_channels.isEmpty();
    }

    @Override
    public synchronized void detach(IComputerAccess computer) {
        if (this.m_network != null) {
            Iterator<IReceiver> it = this.m_channels.values().iterator();
            while (it.hasNext()) {
                this.m_network.removeReceiver(it.next());
            }
            this.m_channels.clear();
            this.m_network = null;
        }
        this.m_computer = null;
        if (this.m_open) {
            this.m_open = false;
            this.m_changed = true;
        }
    }

    @Override
    public abstract boolean equals(IPeripheral var1);

    public IComputerAccess getComputer() {
        return this.m_computer;
    }

    private static class SingleChannelReceiver
    implements IReceiver {
        private ModemPeripheral m_owner;
        private int m_channel;

        public SingleChannelReceiver(ModemPeripheral owner, int channel) {
            this.m_owner = owner;
            this.m_channel = channel;
        }

        @Override
        public int getChannel() {
            return this.m_channel;
        }

        @Override
        public World getWorld() {
            return this.m_owner.getWorld();
        }

        @Override
        public Vec3d getWorldPosition() {
            return this.m_owner.getWorldPosition();
        }

        @Override
        public boolean isInterdimensional() {
            return this.m_owner.isInterdimensional();
        }

        @Override
        public double getReceiveRange() {
            return this.m_owner.getReceiveRange();
        }

        @Override
        public void receiveSameDimension(int replyChannel, Object payload, double distance, Object senderObject) {
            if (senderObject != this.m_owner) {
                this.m_owner.receiveSameDimension(this.m_channel, replyChannel, payload, distance);
            }
        }

        @Override
        public void receiveDifferentDimension(int replyChannel, Object payload, Object senderObject) {
            if (senderObject != this.m_owner) {
                this.m_owner.receiveDifferentDimension(this.m_channel, replyChannel, payload);
            }
        }
    }
}

