/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class TileModemBase
extends TilePeripheralBase {
    protected ModemPeripheral m_modem = this.createPeripheral();

    protected TileModemBase() {
    }

    protected abstract ModemPeripheral createPeripheral();

    @Override
    public synchronized void destroy() {
        if (this.m_modem != null) {
            this.m_modem.destroy();
            this.m_modem = null;
        }
    }

    @Override
    public boolean isSolidOnSide(int side) {
        return false;
    }

    @Override
    public void onNeighbourChange() {
        EnumFacing dir = this.getDirection();
        if (!this.func_145831_w().isSideSolid(this.func_174877_v().func_177972_a(dir), dir.func_176734_d())) {
            ((BlockGeneric)this.func_145838_q()).dropAllItems(this.func_145831_w(), this.func_174877_v(), false);
            this.func_145831_w().func_175698_g(this.func_174877_v());
        }
    }

    @Override
    public AxisAlignedBB getBounds() {
        switch (this.getDirection()) {
            default: {
                return new AxisAlignedBB(0.125, 0.8125, 0.125, 0.875, 1.0, 0.875);
            }
            case DOWN: {
                return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
            }
            case NORTH: {
                return new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.1875);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.125, 0.125, 0.8125, 0.875, 0.875, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.125, 0.125, 0.1875, 0.875, 0.875);
            }
            case EAST: 
        }
        return new AxisAlignedBB(0.8125, 0.125, 0.125, 1.0, 0.875, 0.875);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.m_modem.pollChanged()) {
            this.updateAnim();
        }
    }

    protected void updateAnim() {
        if (this.m_modem.isActive()) {
            this.setAnim(1);
        } else {
            this.setAnim(0);
        }
    }

    @Override
    public final void readDescription(NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.updateBlock();
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        if (side == this.getDirection()) {
            return this.m_modem;
        }
        return null;
    }

    protected boolean isAttached() {
        return this.m_modem != null && this.m_modem.getComputer() != null;
    }
}

