/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockPeripheral;
import dan200.computercraft.shared.peripheral.common.BlockPeripheralVariant;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.TileModemBase;
import dan200.computercraft.shared.peripheral.modem.WirelessModemPeripheral;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileWirelessModem
extends TileModemBase {
    @Override
    public EnumFacing getDirection() {
        IBlockState state = this.getBlockState();
        switch ((BlockPeripheralVariant)((Object)state.func_177229_b(BlockPeripheral.Properties.VARIANT))) {
            case WirelessModemDownOff: 
            case WirelessModemDownOn: {
                return EnumFacing.DOWN;
            }
            case WirelessModemUpOff: 
            case WirelessModemUpOn: {
                return EnumFacing.UP;
            }
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockPeripheral.Properties.FACING);
    }

    @Override
    public void setDirection(EnumFacing dir) {
        if (dir == EnumFacing.UP) {
            this.setBlockState(this.getBlockState().func_177226_a(BlockPeripheral.Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemUpOff)).func_177226_a((IProperty)BlockPeripheral.Properties.FACING, (Comparable)EnumFacing.NORTH));
        } else if (dir == EnumFacing.DOWN) {
            this.setBlockState(this.getBlockState().func_177226_a(BlockPeripheral.Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemDownOff)).func_177226_a((IProperty)BlockPeripheral.Properties.FACING, (Comparable)EnumFacing.NORTH));
        } else {
            this.setBlockState(this.getBlockState().func_177226_a(BlockPeripheral.Properties.VARIANT, (Comparable)((Object)BlockPeripheralVariant.WirelessModemOff)).func_177226_a((IProperty)BlockPeripheral.Properties.FACING, (Comparable)dir));
        }
    }

    @Override
    protected ModemPeripheral createPeripheral() {
        return new Peripheral(this);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return super.shouldRefresh(world, pos, oldState, newState) || ComputerCraft.Blocks.peripheral.getPeripheralType(newState) != PeripheralType.WirelessModem;
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private TileModemBase m_entity;

        public Peripheral(TileModemBase entity) {
            super(false);
            this.m_entity = entity;
        }

        @Override
        protected World getWorld() {
            return this.m_entity.func_145831_w();
        }

        @Override
        protected Vec3d getPosition() {
            BlockPos pos = this.m_entity.func_174877_v().func_177972_a(this.m_entity.getDirection());
            return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }

        @Override
        public boolean equals(IPeripheral other) {
            if (other instanceof Peripheral) {
                Peripheral otherModem = (Peripheral)other;
                return otherModem.m_entity == this.m_entity;
            }
            return false;
        }
    }
}

