/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.modem.INetwork;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.WirelessNetwork;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class WirelessModemPeripheral
extends ModemPeripheral {
    private boolean m_advanced;

    public WirelessModemPeripheral(boolean advanced) {
        this.m_advanced = advanced;
    }

    @Override
    protected boolean isInterdimensional() {
        return this.m_advanced;
    }

    @Override
    protected double getTransmitRange() {
        if (this.m_advanced) {
            return 2.147483647E9;
        }
        World world = this.getWorld();
        if (world != null) {
            Vec3d position = this.getPosition();
            double minRange = ComputerCraft.Config.modem_range;
            double maxRange = ComputerCraft.Config.modem_highAltitudeRange;
            if (world.func_72896_J() && world.func_72911_I()) {
                minRange = ComputerCraft.Config.modem_rangeDuringStorm;
                maxRange = ComputerCraft.Config.modem_highAltitudeRangeDuringStorm;
            }
            if (position.field_72448_b > 96.0 && maxRange > minRange) {
                return minRange + (position.field_72448_b - 96.0) * ((maxRange - minRange) / ((double)(world.func_72800_K() - 1) - 96.0));
            }
            return minRange;
        }
        return 0.0;
    }

    @Override
    protected INetwork getNetwork() {
        return WirelessNetwork.getUniversal();
    }
}

