/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.TilePeripheralBase;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.InventoryUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TilePrinter
extends TilePeripheralBase
implements IInventory,
ISidedInventory {
    private static final int[] bottomSlots = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] topSlots = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] sideSlots = new int[]{0};
    private final Terminal m_page;
    ItemStackHandler inventory = new ItemStackHandler(13);
    private String m_pageTitle = "";
    private boolean m_printing = false;

    public TilePrinter() {
        this.m_page = new Terminal(25, 21);
    }

    @Override
    public void destroy() {
        this.ejectContents();
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (!this.func_145831_w().field_72995_K) {
                ComputerCraft.openPrinterGUI(player, this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        Terminal terminal = this.m_page;
        synchronized (terminal) {
            this.m_printing = nbttagcompound.func_74767_n("printing");
            this.m_pageTitle = nbttagcompound.func_74779_i("pageTitle");
            this.m_page.readFromNBT(nbttagcompound);
        }
        terminal = this.inventory;
        synchronized (terminal) {
            this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        Terminal terminal = this.m_page;
        synchronized (terminal) {
            nbttagcompound.func_74757_a("printing", this.m_printing);
            nbttagcompound.func_74778_a("pageTitle", this.m_pageTitle);
            this.m_page.writeToNBT(nbttagcompound);
        }
        terminal = this.inventory;
        synchronized (terminal) {
            nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        }
        return nbttagcompound;
    }

    @Override
    public final void readDescription(NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.updateBlock();
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return super.shouldRefresh(world, pos, oldState, newState) || ComputerCraft.Blocks.peripheral.getPeripheralType(newState) != PeripheralType.Printer;
    }

    public boolean isPrinting() {
        return this.m_printing;
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int i) {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            return this.inventory.getStackInSlot(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70304_b(int i) {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            ItemStack result = this.inventory.getStackInSlot(i);
            this.inventory.setStackInSlot(i, null);
            this.updateAnim();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int i, int j) {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            if (this.inventory.getStackInSlot(i) == null) {
                return null;
            }
            if (this.inventory.getStackInSlot((int)i).field_77994_a <= j) {
                ItemStack itemstack = this.inventory.getStackInSlot(i);
                this.inventory.setStackInSlot(i, null);
                this.func_70296_d();
                this.updateAnim();
                return itemstack;
            }
            ItemStack part = this.inventory.getStackInSlot(i).func_77979_a(j);
            if (this.inventory.getStackInSlot((int)i).field_77994_a == 0) {
                this.inventory.setStackInSlot(i, null);
                this.updateAnim();
            }
            this.func_70296_d();
            return part;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int i, ItemStack stack) {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            this.inventory.setStackInSlot(i, stack);
            this.func_70296_d();
            this.updateAnim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_174888_l() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, null);
            }
            this.func_70296_d();
            this.updateAnim();
        }
    }

    public boolean func_145818_k_() {
        return this.getLabel() != null;
    }

    public String func_70005_c_() {
        String label = this.getLabel();
        if (label != null) {
            return label;
        }
        return "tile.computercraft:printer.name";
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_70005_c_());
        }
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player, false);
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return bottomSlots;
            }
            case UP: {
                return topSlots;
            }
        }
        return sideSlots;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing face) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing face) {
        return true;
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        return new PrinterPeripheral(this);
    }

    public Terminal getCurrentPage() {
        if (this.m_printing) {
            return this.m_page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startNewPage() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            if (this.canInputPage()) {
                if (this.m_printing && !this.outputPage()) {
                    return false;
                }
                if (this.inputPage()) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endCurrentPage() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            if (this.m_printing && this.outputPage()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInkLevel() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            ItemStack inkStack = this.inventory.getStackInSlot(0);
            if (inkStack != null && this.isInk(inkStack)) {
                return inkStack.field_77994_a;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPaperLevel() {
        int count = 0;
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            for (int i = 1; i < 7; ++i) {
                ItemStack paperStack = this.inventory.getStackInSlot(i);
                if (paperStack == null || !this.isPaper(paperStack)) continue;
                count += paperStack.field_77994_a;
            }
        }
        return count;
    }

    public void setPageTitle(String title) {
        if (this.m_printing) {
            this.m_pageTitle = title;
        }
    }

    private boolean isInk(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR;
    }

    private boolean isPaper(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151121_aF || item instanceof ItemPrintout && ItemPrintout.getType(stack) == ItemPrintout.Type.Single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canInputPage() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            ItemStack inkStack = this.inventory.getStackInSlot(0);
            if (inkStack == null || !this.isInk(inkStack)) {
                return false;
            }
            return this.getPaperLevel() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputPage() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            ItemStack inkStack = this.inventory.getStackInSlot(0);
            if (inkStack == null || !this.isInk(inkStack)) {
                return false;
            }
            for (int i = 1; i < 7; ++i) {
                int colour;
                ItemStack paperStack = this.inventory.getStackInSlot(i);
                if (paperStack == null || !this.isPaper(paperStack)) continue;
                --inkStack.field_77994_a;
                if (inkStack.field_77994_a <= 0) {
                    this.inventory.setStackInSlot(0, null);
                }
                --paperStack.field_77994_a;
                if (paperStack.field_77994_a <= 0) {
                    this.inventory.setStackInSlot(i, null);
                    this.updateAnim();
                }
                if ((colour = inkStack.func_77952_i()) >= 0 && colour < 16) {
                    this.m_page.setTextColour(15 - colour);
                } else {
                    this.m_page.setTextColour(15);
                }
                this.m_page.clear();
                if (paperStack.func_77973_b() instanceof ItemPrintout) {
                    this.m_pageTitle = ItemPrintout.getTitle(paperStack);
                    String[] text = ItemPrintout.getText(paperStack);
                    String[] textColour = ItemPrintout.getColours(paperStack);
                    for (int y = 0; y < this.m_page.getHeight(); ++y) {
                        this.m_page.setLine(y, text[y], textColour[y], "");
                    }
                } else {
                    this.m_pageTitle = "";
                }
                this.m_page.setCursorPos(0, 0);
                this.func_70296_d();
                this.m_printing = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outputPage() {
        Terminal terminal = this.m_page;
        synchronized (terminal) {
            int height = this.m_page.getHeight();
            String[] lines = new String[height];
            String[] colours = new String[height];
            for (int i = 0; i < height; ++i) {
                lines[i] = this.m_page.getLine(i).toString();
                colours[i] = this.m_page.getTextColourLine(i).toString();
            }
            ItemStack stack = ItemPrintout.createSingleFromTitleAndText(this.m_pageTitle, lines, colours);
            ItemStackHandler itemStackHandler = this.inventory;
            synchronized (itemStackHandler) {
                ItemStack remainder = InventoryUtil.storeItems(stack, this, 7, 6, 7);
                if (remainder == null) {
                    this.m_printing = false;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ejectContents() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            for (int i = 0; i < 13; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack == null) continue;
                this.func_70299_a(i, null);
                BlockPos pos = this.func_174877_v();
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.75;
                double z = (double)pos.func_177952_p() + 0.5;
                EntityItem entityitem = new EntityItem(this.func_145831_w(), x, y, z, stack);
                entityitem.field_70159_w = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                entityitem.field_70181_x = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                entityitem.field_70179_y = (double)this.func_145831_w().field_73012_v.nextFloat() * 0.2 - 0.1;
                this.func_145831_w().func_72838_d((Entity)entityitem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnim() {
        ItemStackHandler itemStackHandler = this.inventory;
        synchronized (itemStackHandler) {
            ItemStack stack;
            int i;
            int anim = 0;
            for (i = 1; i < 7; ++i) {
                stack = this.inventory.getStackInSlot(i);
                if (stack == null || !this.isPaper(stack)) continue;
                ++anim;
                break;
            }
            for (i = 7; i < 13; ++i) {
                stack = this.inventory.getStackInSlot(i);
                if (stack == null || !this.isPaper(stack)) continue;
                anim += 2;
                break;
            }
            this.setAnim(anim);
        }
    }
}

