/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer m_computer;

    public PocketAPI(PocketServerComputer computer) {
        this.m_computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @Override
    public void startup() {
    }

    @Override
    public void advance(double dt) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"equip", "unequip", "getColor"};
    }

    @Override
    public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException {
        switch (method) {
            case 0: {
                ItemStack stack;
                if (!(this.m_computer.getEntity() instanceof EntityPlayer)) {
                    throw new LuaException("Cannot find player");
                }
                ItemStack pocketStack = this.m_computer.getStack();
                EntityPlayer player = (EntityPlayer)this.m_computer.getEntity();
                InventoryPlayer inventory = player.field_71071_by;
                IPocketUpgrade previousUpgrade = this.m_computer.getUpgrade();
                IPocketUpgrade newUpgrade = null;
                int size = inventory.func_70302_i_();
                int held = inventory.field_70461_c;
                for (int i = 0; i < size; ++i) {
                    ItemStack invStack = inventory.func_70301_a((i + held) % size);
                    if (invStack == null || (newUpgrade = ComputerCraft.getPocketUpgrade(invStack)) == null || newUpgrade == previousUpgrade) continue;
                    invStack = invStack.func_77946_l();
                    --invStack.field_77994_a;
                    inventory.func_70299_a((i + held) % size, invStack.field_77994_a <= 0 ? null : invStack);
                    break;
                }
                if (newUpgrade == null) {
                    throw new LuaException("Cannot find a valid upgrade");
                }
                if (previousUpgrade != null && (stack = previousUpgrade.getCraftingItem()) != null && (stack = InventoryUtil.storeItems(stack, (IInventory)inventory, 0, 36, inventory.field_70461_c)) != null) {
                    WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                }
                ItemPocketComputer.setUpgrade(pocketStack, newUpgrade);
                this.m_computer.setUpgrade(newUpgrade);
                return null;
            }
            case 1: {
                if (!(this.m_computer.getEntity() instanceof EntityPlayer)) {
                    throw new LuaException("Cannot find player");
                }
                ItemStack pocketStack = this.m_computer.getStack();
                EntityPlayer player = (EntityPlayer)this.m_computer.getEntity();
                InventoryPlayer inventory = player.field_71071_by;
                IPocketUpgrade previousUpgrade = this.m_computer.getUpgrade();
                if (previousUpgrade == null) {
                    throw new LuaException("Nothing to unequip");
                }
                ItemPocketComputer.setUpgrade(pocketStack, null);
                this.m_computer.setUpgrade(null);
                ItemStack stack = previousUpgrade.getCraftingItem();
                if (stack != null && (stack = InventoryUtil.storeItems(stack, (IInventory)inventory, 0, 36, inventory.field_70461_c)) != null) {
                    WorldUtil.dropItemStack(stack, player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                }
                return null;
            }
            case 3: {
                ItemStack pocketStack = this.m_computer.getStack();
                return new Object[]{String.valueOf(ItemPocketComputer.getLightState(pocketStack))};
            }
        }
        return null;
    }
}

