/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess<PocketServerComputer> {
    private IPocketUpgrade m_upgrade;
    private Entity m_entity;
    private ItemStack m_stack;

    public PocketServerComputer(World world, int computerID, String label, int instanceID, ComputerFamily family, ItemStack stack, Entity entity) {
        super(world, computerID, label, instanceID, family, 26, 20);
        this.update(entity, stack);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.m_entity;
    }

    @Override
    public int getModemLight() {
        int value = this.getUserData().func_74762_e("modemLight");
        return value >= 0 && value <= 15 ? value : 0;
    }

    @Override
    public PocketServerComputer setModemLight(int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("Colour out of bounds");
        }
        NBTTagCompound tag = this.getUserData();
        if (tag.func_74762_e("modemLight") != value) {
            tag.func_74768_a("modemLight", value);
            this.updateUserData();
        }
        return this;
    }

    @Override
    @Nonnull
    public NBTTagCompound getUpgradeNBTData() {
        return ComputerCraft.Items.pocketComputer.getUpgradeInfo(this.m_stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        InventoryPlayer inventory;
        InventoryPlayer inventoryPlayer = inventory = this.m_entity instanceof EntityPlayer ? ((EntityPlayer)this.m_entity).field_71071_by : null;
        if (inventory != null) {
            inventory.func_70296_d();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.m_upgrade == null ? null : this.m_upgrade.createPeripheral(this);
        this.setPeripheral(2, peripheral);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        if (this.m_upgrade == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.m_upgrade.getUpgradeID(), this.getPeripheral(2));
    }

    public ItemStack getStack() {
        return this.m_stack;
    }

    public IPocketUpgrade getUpgrade() {
        return this.m_upgrade;
    }

    public synchronized void setUpgrade(IPocketUpgrade upgrade) {
        NBTTagCompound tag;
        if (this.m_upgrade == upgrade) {
            return;
        }
        if (this.m_stack.func_77942_o() && (tag = this.m_stack.func_77978_p()).func_150297_b("upgrade_info", 10)) {
            tag.func_82580_o("upgrade_info");
            this.updateUpgradeNBTData();
        }
        this.m_upgrade = upgrade;
        this.invalidatePeripheral();
    }

    public void update(Entity entity, ItemStack stack) {
        if (this.m_entity != null) {
            this.setPosition(entity.func_180425_c());
        }
        this.m_entity = entity;
        this.m_stack = stack;
    }
}

