/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.computer.blocks.ComputerState;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.util.Colour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemPocketComputer
extends Item
implements IComputerItem,
IMedia {
    public ItemPocketComputer() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("computercraft.pocket_computer");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    public static IPocketUpgrade getUpgrade(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            int id;
            if (compound.func_150297_b("upgrade", 8)) {
                String name = compound.func_74779_i("upgrade");
                return ComputerCraft.getPocketUpgrade(name);
            }
            if (compound.func_150297_b("upgrade", 99) && (id = compound.func_74762_e("upgrade")) == 1) {
                return ComputerCraft.getPocketUpgrade("computercraft:wireless_modem");
            }
        }
        return null;
    }

    public static void setUpgrade(@Nullable ItemStack stack, IPocketUpgrade upgrade) {
        if (stack == null) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        if (upgrade == null) {
            compound.func_82580_o("upgrade");
        } else {
            compound.func_74778_a("upgrade", upgrade.getUpgradeID().toString());
        }
        compound.func_82580_o("upgrade_info");
    }

    public ItemStack create(int id, String label, ComputerFamily family, IPocketUpgrade upgrade) {
        if (family != ComputerFamily.Normal && family != ComputerFamily.Advanced) {
            return null;
        }
        int damage = family == ComputerFamily.Advanced ? 1 : 0;
        ItemStack result = new ItemStack((Item)this, 1, damage);
        if (id >= 0 || upgrade != null) {
            NBTTagCompound compound = new NBTTagCompound();
            if (id >= 0) {
                compound.func_74768_a("computerID", id);
            }
            if (upgrade != null) {
                compound.func_74778_a("upgrade", upgrade.getUpgradeID().toString());
            }
            result.func_77982_d(compound);
        }
        if (label != null) {
            result.func_151001_c(label);
        }
        return result;
    }

    public void func_150895_a(Item itemID, CreativeTabs tabs, List<ItemStack> list) {
        this.getSubItems(list, ComputerFamily.Normal);
        this.getSubItems(list, ComputerFamily.Advanced);
    }

    private void getSubItems(List<ItemStack> list, ComputerFamily family) {
        list.add(PocketComputerItemFactory.create(-1, null, family, null));
        for (IPocketUpgrade upgrade : ComputerCraft.getVanillaPocketUpgrades()) {
            list.add(PocketComputerItemFactory.create(-1, null, family, upgrade));
        }
    }

    public void func_77663_a(@Nullable ItemStack stack, World world, Entity entity, int slotNum, boolean selected) {
        if (!world.field_72995_K) {
            InventoryPlayer inventory = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by : null;
            PocketServerComputer computer = this.createServerComputer(world, (IInventory)inventory, entity, stack);
            if (computer != null) {
                String label;
                IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
                computer.keepAlive();
                computer.setWorld(world);
                computer.update(entity, stack);
                int id = computer.getID();
                if (id != this.getComputerID(stack)) {
                    this.setComputerID(stack, id);
                    if (inventory != null) {
                        inventory.func_70296_d();
                    }
                }
                if (!Objects.equal((Object)(label = computer.getLabel()), (Object)this.getLabel(stack))) {
                    this.setLabel(stack, label);
                    if (inventory != null) {
                        inventory.func_70296_d();
                    }
                }
                if (upgrade != null) {
                    upgrade.update(computer, computer.getPeripheral(2));
                }
            }
        } else {
            ClientComputer computer = this.createClientComputer(stack);
            if (computer != null) {
                // empty if block
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            PocketServerComputer computer = this.createServerComputer(world, (IInventory)player.field_71071_by, (Entity)player, stack);
            boolean stop = false;
            if (computer != null) {
                computer.turnOn();
                IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
                if (upgrade != null) {
                    stop = upgrade.onRightClick(world, computer, computer.getPeripheral(2));
                }
            }
            if (!stop) {
                ComputerCraft.openPocketComputerGUI(player, hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77667_c(@Nullable ItemStack stack) {
        switch (this.getFamily(stack)) {
            default: {
                return "item.computercraft.pocket_computer";
            }
            case Advanced: 
        }
        return "item.computercraft.advanced_pocket_computer";
    }

    public String func_77653_i(@Nullable ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            return I18n.func_74837_a((String)(baseString + ".upgraded.name"), (Object[])new Object[]{I18n.func_74838_a((String)upgrade.getUnlocalisedAdjective())});
        }
        return I18n.func_74838_a((String)(baseString + ".name"));
    }

    public void func_77624_a(@Nullable ItemStack stack, EntityPlayer player, List list, boolean debug) {
        int id;
        if (debug && (id = this.getComputerID(stack)) >= 0) {
            list.add("(Computer ID: " + id + ")");
        }
    }

    private PocketServerComputer createServerComputer(World world, IInventory inventory, Entity entity, ItemStack stack) {
        PocketServerComputer computer;
        if (world.field_72995_K) {
            return null;
        }
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        int sessionID = this.getSessionID(stack);
        int correctSessionID = ComputerCraft.serverComputerRegistry.getSessionID();
        if (instanceID >= 0 && sessionID == correctSessionID && ComputerCraft.serverComputerRegistry.contains(instanceID)) {
            computer = (PocketServerComputer)ComputerCraft.serverComputerRegistry.get(instanceID);
        } else {
            int computerID;
            if (instanceID < 0 || sessionID != correctSessionID) {
                instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                this.setInstanceID(stack, instanceID);
                this.setSessionID(stack, correctSessionID);
            }
            if ((computerID = this.getComputerID(stack)) < 0) {
                computerID = ComputerCraft.createUniqueNumberedSaveDir(world, "computer");
                this.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, computerID, this.getLabel(stack), instanceID, this.getFamily(stack), stack, entity);
            computer.addAPI(new PocketAPI(computer));
            computer.setUpgrade(ItemPocketComputer.getUpgrade(stack));
            ComputerCraft.serverComputerRegistry.add(instanceID, computer);
            if (inventory != null) {
                inventory.func_70296_d();
            }
        }
        computer.setWorld(world);
        return computer;
    }

    public ClientComputer createClientComputer(@Nullable ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        if (instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(instanceID)) {
                ComputerCraft.clientComputerRegistry.add(instanceID, new ClientComputer(instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    private static ClientComputer getClientComputer(@Nullable ItemStack stack) {
        int instanceID = ItemPocketComputer.getInstanceID(stack);
        if (instanceID >= 0) {
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceID);
        }
        return null;
    }

    @Override
    public int getComputerID(@Nullable ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("computerID")) {
            return compound.func_74762_e("computerID");
        }
        return -1;
    }

    private void setComputerID(@Nullable ItemStack stack, int computerID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("computerID", computerID);
    }

    @Override
    public String getLabel(@Nullable ItemStack stack) {
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return null;
    }

    @Override
    public ComputerFamily getFamily(@Nullable ItemStack stack) {
        int damage = stack.func_77952_i();
        switch (damage) {
            default: {
                return ComputerFamily.Normal;
            }
            case 1: 
        }
        return ComputerFamily.Advanced;
    }

    @Override
    public boolean setLabel(@Nullable ItemStack stack, String label) {
        if (label != null) {
            stack.func_151001_c(label);
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public String getAudioTitle(@Nullable ItemStack stack) {
        return null;
    }

    @Override
    public SoundEvent getAudio(@Nullable ItemStack stack) {
        return null;
    }

    @Override
    public IMount createDataMount(@Nullable ItemStack stack, World world) {
        PocketServerComputer computer = this.createServerComputer(world, null, null, stack);
        if (computer != null) {
            return computer.getRootMount();
        }
        return null;
    }

    private static int getInstanceID(@Nullable ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("instanceID")) {
            return compound.func_74762_e("instanceID");
        }
        return -1;
    }

    private void setInstanceID(@Nullable ItemStack stack, int instanceID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("instanceID", instanceID);
    }

    private int getSessionID(@Nullable ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("sessionID")) {
            return compound.func_74762_e("sessionID");
        }
        return -1;
    }

    private void setSessionID(@Nullable ItemStack stack, int sessionID) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("sessionID", sessionID);
    }

    public ComputerState getState(@Nullable ItemStack stack) {
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        return computer != null && computer.isOn() ? (computer.isCursorDisplayed() ? ComputerState.Blinking : ComputerState.On) : ComputerState.Off;
    }

    public static int getLightState(@Nullable ItemStack stack) {
        NBTTagCompound computerNBT;
        ClientComputer computer = ItemPocketComputer.getClientComputer(stack);
        if (computer != null && computer.isOn() && (computerNBT = computer.getUserData()) != null && computerNBT.func_74764_b("modemLight")) {
            return computerNBT.func_74762_e("modemLight");
        }
        return Colour.Black.ordinal();
    }

    public NBTTagCompound getUpgradeInfo(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        if (tag.func_150297_b("upgrade_info", 10)) {
            return tag.func_74775_l("upgrade_info");
        }
        NBTTagCompound sub = new NBTTagCompound();
        tag.func_74782_a("upgrade_info", (NBTBase)sub);
        return sub;
    }
}

