/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.proxy.ICCTurtleProxy;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtleAdvanced;
import dan200.computercraft.shared.turtle.blocks.TileTurtleExpanded;
import dan200.computercraft.shared.turtle.items.ItemTurtleAdvanced;
import dan200.computercraft.shared.turtle.items.ItemTurtleLegacy;
import dan200.computercraft.shared.turtle.items.ItemTurtleNormal;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleAxe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleHoe;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleShovel;
import dan200.computercraft.shared.turtle.upgrades.TurtleSword;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.IEntityDropConsumer;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

public abstract class CCTurtleProxyCommon
implements ICCTurtleProxy {
    private Map<Integer, ITurtleUpgrade> m_legacyTurtleUpgrades = new HashMap<Integer, ITurtleUpgrade>();
    private Map<String, ITurtleUpgrade> m_turtleUpgrades = new HashMap<String, ITurtleUpgrade>();
    private Map<Entity, IEntityDropConsumer> m_dropConsumers = new WeakHashMap<Entity, IEntityDropConsumer>();

    public static boolean isUpgradeVanilla(ITurtleUpgrade upgrade) {
        return upgrade instanceof TurtleTool || upgrade instanceof TurtleModem || upgrade instanceof TurtleCraftingTable;
    }

    public static boolean isUpgradeSuitableForFamily(ComputerFamily family, ITurtleUpgrade upgrade) {
        return family != ComputerFamily.Beginners || upgrade.getType().isTool();
    }

    @Override
    public void preInit() {
        this.registerItems();
    }

    @Override
    public void init() {
        this.registerForgeHandlers();
        this.registerTileEntities();
    }

    @Override
    public void registerTurtleUpgrade(ITurtleUpgrade upgrade) {
        int id = upgrade.getLegacyUpgradeID();
        if (id >= 0 && id < 64) {
            throw new RuntimeException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. Legacy UpgradeID '" + id + "' is reserved by ComputerCraft");
        }
        this.registerTurtleUpgradeInternal(upgrade);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(String id) {
        return this.m_turtleUpgrades.get(id);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(int legacyId) {
        return this.m_legacyTurtleUpgrades.get(legacyId);
    }

    @Override
    public ITurtleUpgrade getTurtleUpgrade(ItemStack stack) {
        for (ITurtleUpgrade upgrade : this.m_turtleUpgrades.values()) {
            try {
                ItemStack upgradeStack = upgrade.getCraftingItem();
                if (!InventoryUtil.areItemsStackable(upgradeStack, stack)) continue;
                return upgrade;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private void addAllUpgradedTurtles(ComputerFamily family, List<ItemStack> list) {
        ItemStack basicStack = TurtleItemFactory.create(-1, null, null, family, null, null, 0, null);
        if (basicStack != null) {
            list.add(basicStack);
        }
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondPickaxe, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondAxe, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondSword, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondShovel, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.diamondHoe, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.craftingTable, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.wirelessModem, list);
        this.addUpgradedTurtle(family, ComputerCraft.Upgrades.advancedModem, list);
    }

    private void addUpgradedTurtle(ComputerFamily family, ITurtleUpgrade upgrade, List<ItemStack> list) {
        ItemStack stack;
        if (CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, upgrade) && (stack = TurtleItemFactory.create(-1, null, null, family, upgrade, null, 0, null)) != null) {
            list.add(stack);
        }
    }

    @Override
    public void addAllUpgradedTurtles(List<ItemStack> list) {
        this.addAllUpgradedTurtles(ComputerFamily.Normal, list);
        this.addAllUpgradedTurtles(ComputerFamily.Advanced, list);
    }

    @Override
    public void setEntityDropConsumer(Entity entity, IEntityDropConsumer consumer) {
        boolean captured;
        if (!this.m_dropConsumers.containsKey(entity) && !(captured = ((Boolean)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])new String[]{"captureDrops"})).booleanValue())) {
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entity, (Object)true, (String[])new String[]{"captureDrops"});
            ArrayList items = (ArrayList)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])new String[]{"capturedDrops"});
            if (items == null || items.size() == 0) {
                this.m_dropConsumers.put(entity, consumer);
            }
        }
    }

    @Override
    public void clearEntityDropConsumer(Entity entity) {
        if (this.m_dropConsumers.containsKey(entity)) {
            boolean captured = (Boolean)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])new String[]{"captureDrops"});
            if (captured) {
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entity, (Object)false, (String[])new String[]{"captureDrops"});
                ArrayList items = (ArrayList)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String[])new String[]{"capturedDrops"});
                if (items != null) {
                    this.dispatchEntityDrops(entity, items);
                    items.clear();
                }
            }
            this.m_dropConsumers.remove(entity);
        }
    }

    private void registerTurtleUpgradeInternal(ITurtleUpgrade upgrade) {
        String id;
        ITurtleUpgrade existing;
        int legacyID = upgrade.getLegacyUpgradeID();
        if (legacyID >= 0) {
            if (legacyID >= Short.MAX_VALUE) {
                throw new RuntimeException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + legacyID + "' is out of range");
            }
            ITurtleUpgrade existing2 = this.m_legacyTurtleUpgrades.get(legacyID);
            if (existing2 != null) {
                throw new RuntimeException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + legacyID + "' is already registered by '" + existing2.getUnlocalisedAdjective() + " Turtle'");
            }
        }
        if ((existing = this.m_turtleUpgrades.get(id = upgrade.getUpgradeID().toString())) != null) {
            throw new RuntimeException("Error registering '" + upgrade.getUnlocalisedAdjective() + " Turtle'. UpgradeID '" + id + "' is already registered by '" + existing.getUnlocalisedAdjective() + " Turtle'");
        }
        if (legacyID >= 0) {
            this.m_legacyTurtleUpgrades.put(legacyID, upgrade);
        }
        this.m_turtleUpgrades.put(id, upgrade);
        if (CCTurtleProxyCommon.isUpgradeVanilla(upgrade)) {
            List recipeList = CraftingManager.func_77594_a().func_77592_b();
            ItemStack craftingItem = upgrade.getCraftingItem();
            for (ComputerFamily family : ComputerFamily.values()) {
                ItemStack baseTurtle;
                if (!CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, upgrade) || (baseTurtle = TurtleItemFactory.create(-1, null, null, family, null, null, 0, null)) == null) continue;
                ItemStack craftedTurtle = TurtleItemFactory.create(-1, null, null, family, upgrade, null, 0, null);
                ItemStack craftedTurtleFlipped = TurtleItemFactory.create(-1, null, null, family, null, upgrade, 0, null);
                recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{baseTurtle, craftingItem}, craftedTurtle));
                recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftingItem, baseTurtle}, craftedTurtleFlipped));
                for (ITurtleUpgrade otherUpgrade : this.m_turtleUpgrades.values()) {
                    if (!CCTurtleProxyCommon.isUpgradeVanilla(otherUpgrade) || !CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, otherUpgrade)) continue;
                    ItemStack otherCraftingItem = otherUpgrade.getCraftingItem();
                    ItemStack otherCraftedTurtle = TurtleItemFactory.create(-1, null, null, family, null, otherUpgrade, 0, null);
                    ItemStack comboCraftedTurtle = TurtleItemFactory.create(-1, null, null, family, upgrade, otherUpgrade, 0, null);
                    ItemStack otherCraftedTurtleFlipped = TurtleItemFactory.create(-1, null, null, family, otherUpgrade, null, 0, null);
                    ItemStack comboCraftedTurtleFlipped = TurtleItemFactory.create(-1, null, null, family, otherUpgrade, upgrade, 0, null);
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{otherCraftingItem, craftedTurtle}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{otherCraftedTurtle, craftingItem}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftedTurtleFlipped, otherCraftingItem}, comboCraftedTurtleFlipped));
                    recipeList.add(new ImpostorRecipe(2, 1, new ItemStack[]{craftingItem, otherCraftedTurtleFlipped}, comboCraftedTurtleFlipped));
                    recipeList.add(new ImpostorRecipe(3, 1, new ItemStack[]{otherCraftingItem, baseTurtle, craftingItem}, comboCraftedTurtle));
                    recipeList.add(new ImpostorRecipe(3, 1, new ItemStack[]{craftingItem, baseTurtle, otherCraftingItem}, comboCraftedTurtleFlipped));
                }
            }
        }
    }

    private void registerItems() {
        ComputerCraft.Blocks.turtle = BlockTurtle.createTurtleBlock();
        ComputerCraft.Blocks.turtle.setRegistryName("turtle");
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Blocks.turtle);
        GameRegistry.register((IForgeRegistryEntry)new ItemTurtleLegacy(ComputerCraft.Blocks.turtle).setRegistryName("turtle"));
        ComputerCraft.Blocks.turtleExpanded = BlockTurtle.createTurtleBlock();
        ComputerCraft.Blocks.turtleExpanded.setRegistryName("turtle_expanded");
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Blocks.turtleExpanded);
        GameRegistry.register((IForgeRegistryEntry)new ItemTurtleNormal(ComputerCraft.Blocks.turtleExpanded).setRegistryName("turtle_expanded"));
        ComputerCraft.Blocks.turtleAdvanced = BlockTurtle.createTurtleBlock();
        ComputerCraft.Blocks.turtleAdvanced.setRegistryName("turtle_advanced");
        GameRegistry.register((IForgeRegistryEntry)ComputerCraft.Blocks.turtleAdvanced);
        GameRegistry.register((IForgeRegistryEntry)new ItemTurtleAdvanced(ComputerCraft.Blocks.turtleAdvanced).setRegistryName("turtle_advanced"));
        RecipeSorter.register((String)"computercraft:turtle", TurtleRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"computercraft:turtle_upgrade", TurtleUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new TurtleRecipe(new Item[]{Items.field_151042_j, Items.field_151042_j, Items.field_151042_j, Items.field_151042_j, Item.func_150898_a((Block)ComputerCraft.Blocks.computer), Items.field_151042_j, Items.field_151042_j, Item.func_150898_a((Block)Blocks.field_150486_ae), Items.field_151042_j}, ComputerFamily.Normal));
        GameRegistry.addRecipe((IRecipe)new TurtleUpgradeRecipe());
        ItemStack iron = new ItemStack(Items.field_151042_j, 1);
        GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(3, 3, new ItemStack[]{iron, iron, iron, iron, ComputerItemFactory.create(-1, null, ComputerFamily.Normal), iron, iron, new ItemStack((Block)Blocks.field_150486_ae, 1), iron}, TurtleItemFactory.create(-1, null, null, ComputerFamily.Normal, null, null, 0, null)));
        GameRegistry.addRecipe((IRecipe)new TurtleRecipe(new Item[]{Items.field_151043_k, Items.field_151043_k, Items.field_151043_k, Items.field_151043_k, Item.func_150898_a((Block)ComputerCraft.Blocks.computer), Items.field_151043_k, Items.field_151043_k, Item.func_150898_a((Block)Blocks.field_150486_ae), Items.field_151043_k}, ComputerFamily.Advanced));
        ItemStack gold = new ItemStack(Items.field_151043_k, 1);
        GameRegistry.addRecipe((IRecipe)new ImpostorRecipe(3, 3, new ItemStack[]{gold, gold, gold, gold, ComputerItemFactory.create(-1, null, ComputerFamily.Advanced), gold, gold, new ItemStack((Block)Blocks.field_150486_ae, 1), gold}, TurtleItemFactory.create(-1, null, null, ComputerFamily.Advanced, null, null, 0, null)));
        ComputerCraft.Upgrades.wirelessModem = new TurtleModem(false, new ResourceLocation("computercraft", "wireless_modem"), 1);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.wirelessModem);
        ComputerCraft.Upgrades.craftingTable = new TurtleCraftingTable(2);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.craftingTable);
        ComputerCraft.Upgrades.diamondSword = new TurtleSword(new ResourceLocation("minecraft", "diamond_sword"), 3, "upgrade.minecraft.diamond_sword.adjective", Items.field_151048_u);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondSword);
        ComputerCraft.Upgrades.diamondShovel = new TurtleShovel(new ResourceLocation("minecraft", "diamond_shovel"), 4, "upgrade.minecraft.diamond_shovel.adjective", Items.field_151047_v);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondShovel);
        ComputerCraft.Upgrades.diamondPickaxe = new TurtleTool(new ResourceLocation("minecraft", "diamond_pickaxe"), 5, "upgrade.minecraft.diamond_pickaxe.adjective", Items.field_151046_w);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondPickaxe);
        ComputerCraft.Upgrades.diamondAxe = new TurtleAxe(new ResourceLocation("minecraft", "diamond_axe"), 6, "upgrade.minecraft.diamond_axe.adjective", Items.field_151056_x);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondAxe);
        ComputerCraft.Upgrades.diamondHoe = new TurtleHoe(new ResourceLocation("minecraft", "diamond_hoe"), 7, "upgrade.minecraft.diamond_hoe.adjective", Items.field_151012_L);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.diamondHoe);
        ComputerCraft.Upgrades.advancedModem = new TurtleModem(true, new ResourceLocation("computercraft", "advanced_modem"), -1);
        this.registerTurtleUpgradeInternal(ComputerCraft.Upgrades.advancedModem);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileTurtle.class, (String)"turtle");
        GameRegistry.registerTileEntity(TileTurtleExpanded.class, (String)"turtleex");
        GameRegistry.registerTileEntity(TileTurtleAdvanced.class, (String)"turtleadv");
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    private void dispatchEntityDrops(Entity entity, List<EntityItem> drops) {
        IEntityDropConsumer consumer = this.m_dropConsumers.get(entity);
        if (consumer != null) {
            for (EntityItem entityItem : drops) {
                consumer.consumeDrop(entity, entityItem.func_92059_d());
            }
            drops.clear();
        }
    }

    public class ForgeHandlers {
        private ForgeHandlers() {
        }

        @SubscribeEvent
        public void onEntityLivingDrops(LivingDropsEvent event) {
            CCTurtleProxyCommon.this.dispatchEntityDrops(event.getEntity(), event.getDrops());
        }
    }
}

